/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.NamespaceContextImpl;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.SafeDocumentBuilderFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.WSTrustVersion;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
class WSTrustResponse {
    private static final Logger log = LoggerFactory.getLogger(WSTrustResponse.class);
    public static final String SAML1_ASSERTION = "urn:oasis:names:tc:SAML:1.0:assertion";
    private String faultMessage;
    private boolean errorFound;
    private String errorCode;
    private String token;
    private String tokenType;

    private WSTrustResponse() {
    }

    String getFaultMessage() {
        return this.faultMessage;
    }

    boolean isErrorFound() {
        return this.errorFound;
    }

    String getErrorCode() {
        return this.errorCode;
    }

    String getToken() {
        return this.token;
    }

    String getTokenType() {
        return this.tokenType;
    }

    boolean isTokenSaml2() {
        return this.tokenType != null && !"urn:oasis:names:tc:SAML:1.0:assertion".equalsIgnoreCase(this.tokenType);
    }

    static WSTrustResponse parse(String string, WSTrustVersion wSTrustVersion) throws Exception {
        WSTrustResponse wSTrustResponse = new WSTrustResponse();
        DocumentBuilderFactory documentBuilderFactory = SafeDocumentBuilderFactory.createInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8"))));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        xPath.setNamespaceContext((NamespaceContext)namespaceContextImpl);
        if (WSTrustResponse.parseError((WSTrustResponse)wSTrustResponse, (Document)document, (XPath)xPath)) {
            if (StringHelper.isBlank((String)wSTrustResponse.errorCode)) {
                wSTrustResponse.errorCode = "NONE";
            }
            if (StringHelper.isBlank((String)wSTrustResponse.faultMessage)) {
                wSTrustResponse.faultMessage = "NONE";
            }
            throw new Exception("Server returned error in RSTR - ErrorCode: " + wSTrustResponse.errorCode + " : FaultMessage: " + wSTrustResponse.faultMessage.trim());
        }
        WSTrustResponse.parseToken((WSTrustResponse)wSTrustResponse, (Document)document, (XPath)xPath, (WSTrustVersion)wSTrustVersion);
        return wSTrustResponse;
    }

    private static void parseToken(WSTrustResponse wSTrustResponse, Document document, XPath xPath, WSTrustVersion wSTrustVersion) throws Exception {
        NodeList nodeList = (NodeList)xPath.compile(wSTrustVersion.getResponseTokenTypePath()).evaluate(document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            log.warn("No TokenType elements found in RSTR");
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            NodeList nodeList2;
            if (!StringHelper.isBlank((String)wSTrustResponse.token)) {
                log.warn("Found more than one returned token.  Using the first.");
                break;
            }
            Node node = nodeList.item(i2);
            wSTrustResponse.tokenType = node.getTextContent();
            if (StringHelper.isBlank((String)wSTrustResponse.tokenType)) {
                log.warn("Could not find token type in RSTR token");
            }
            if ((nodeList2 = (NodeList)xPath.compile(wSTrustVersion.getResponseSecurityTokenPath()).evaluate(node.getParentNode(), XPathConstants.NODESET)).getLength() > 1) {
                throw new Exception("Found too many RequestedSecurityToken nodes for token type: " + wSTrustResponse.tokenType);
            }
            if (nodeList2.getLength() == 0) {
                log.warn("Unable to find RequestsSecurityToken element associated with TokenType element: " + wSTrustResponse.tokenType);
                continue;
            }
            wSTrustResponse.token = WSTrustResponse.innerXml((Node)nodeList2.item(0));
            if (StringHelper.isBlank((String)wSTrustResponse.token)) {
                log.warn("Unable to find token associated with TokenType element: " + wSTrustResponse.tokenType);
                continue;
            }
            log.info("Found token of type: " + wSTrustResponse.tokenType);
        }
        if (StringHelper.isBlank((String)wSTrustResponse.token)) {
            throw new Exception("Unable to find any tokens in RSTR");
        }
    }

    private static boolean parseError(WSTrustResponse wSTrustResponse, Document document, XPath xPath) throws Exception {
        NodeList nodeList;
        boolean bl2 = false;
        NodeList nodeList2 = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Reason").evaluate(document, XPathConstants.NODESET);
        if (nodeList2.getLength() > 0) {
            wSTrustResponse.faultMessage = nodeList2.item(0).getTextContent();
            if (!StringHelper.isBlank((String)wSTrustResponse.faultMessage)) {
                wSTrustResponse.errorFound = true;
            }
        }
        if ((nodeList = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Code/s:Subcode/s:Value").evaluate(document, XPathConstants.NODESET)).getLength() > 1) {
            throw new Exception("Found too many fault code values:" + nodeList.getLength());
        }
        if (nodeList.getLength() == 1) {
            wSTrustResponse.errorCode = nodeList.item(0).getChildNodes().item(0).getTextContent();
            wSTrustResponse.errorCode = wSTrustResponse.errorCode.split(":")[1];
            bl2 = true;
        }
        return bl2;
    }

    static String innerXml(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                DOMSource dOMSource = new DOMSource(node2);
                transformer.transform(dOMSource, streamResult);
                stringBuilder.append(stringWriter.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString().trim();
    }
}

