/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String uniqueId;
    String displayableId;
    String givenName;
    String familyName;
    String identityProvider;
    String passwordChangeUrl;
    Date passwordExpiresOn;
    String tenantId;

    private UserInfo() {
    }

    public String getDisplayableId() {
        return this.displayableId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getPasswordChangeUrl() {
        return this.passwordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        if (this.passwordExpiresOn != null) {
            return (Date)this.passwordExpiresOn.clone();
        }
        return null;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    static UserInfo createFromIdTokenClaims(JWTClaimsSet jWTClaimsSet) throws ParseException {
        int n2;
        if (jWTClaimsSet == null || jWTClaimsSet.getClaims().size() == 0) {
            return null;
        }
        String string = null;
        String string2 = null;
        if (!StringHelper.isBlank((String)jWTClaimsSet.getStringClaim("oid"))) {
            string = jWTClaimsSet.getStringClaim("oid");
        } else if (!StringHelper.isBlank((String)jWTClaimsSet.getStringClaim("sub"))) {
            string = jWTClaimsSet.getStringClaim("sub");
        }
        if (!StringHelper.isBlank((String)jWTClaimsSet.getStringClaim("upn"))) {
            string2 = jWTClaimsSet.getStringClaim("upn");
        } else if (!StringHelper.isBlank((String)jWTClaimsSet.getStringClaim("email"))) {
            string2 = jWTClaimsSet.getStringClaim("email");
        }
        UserInfo userInfo = new UserInfo();
        userInfo.uniqueId = string;
        userInfo.displayableId = string2;
        userInfo.familyName = jWTClaimsSet.getStringClaim("family_name");
        userInfo.givenName = jWTClaimsSet.getStringClaim("given_name");
        userInfo.identityProvider = jWTClaimsSet.getStringClaim("idp");
        userInfo.tenantId = jWTClaimsSet.getStringClaim("tid");
        if (!StringHelper.isBlank((String)jWTClaimsSet.getStringClaim("pwd_url"))) {
            userInfo.passwordChangeUrl = jWTClaimsSet.getStringClaim("pwd_url");
        }
        if (jWTClaimsSet.getClaim("pwd_exp") != null && (n2 = Integer.parseInt((String)jWTClaimsSet.getClaim("pwd_exp"))) > 0) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            ((Calendar)gregorianCalendar).add(13, n2);
            userInfo.passwordExpiresOn = gregorianCalendar.getTime();
        }
        return userInfo;
    }

    public int hashCode() {
        int n2 = 5;
        n2 = 37 * n2 + Objects.hashCode(this.uniqueId);
        n2 = 37 * n2 + Objects.hashCode(this.displayableId);
        n2 = 37 * n2 + Objects.hashCode(this.givenName);
        n2 = 37 * n2 + Objects.hashCode(this.familyName);
        n2 = 37 * n2 + Objects.hashCode(this.identityProvider);
        n2 = 37 * n2 + Objects.hashCode(this.passwordChangeUrl);
        n2 = 37 * n2 + Objects.hashCode(this.passwordExpiresOn);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)object;
        if (!Objects.equals(this.uniqueId, userInfo.uniqueId)) {
            return false;
        }
        if (!Objects.equals(this.displayableId, userInfo.displayableId)) {
            return false;
        }
        if (!Objects.equals(this.givenName, userInfo.givenName)) {
            return false;
        }
        if (!Objects.equals(this.familyName, userInfo.familyName)) {
            return false;
        }
        if (!Objects.equals(this.identityProvider, userInfo.identityProvider)) {
            return false;
        }
        if (!Objects.equals(this.passwordChangeUrl, userInfo.passwordChangeUrl)) {
            return false;
        }
        return Objects.equals(this.passwordExpiresOn, userInfo.passwordExpiresOn);
    }
}

