/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.ByteArrayInputStream;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.BindingPolicy;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.HttpHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.NamespaceContextImpl;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.SafeDocumentBuilderFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.WSTrustVersion;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
class MexParser {
    private static final Logger log = LoggerFactory.getLogger(MexParser.class);
    private static final String TRANSPORT_BINDING_XPATH = "wsp:ExactlyOne/wsp:All/sp:TransportBinding";
    private static final String TRANSPORT_BINDING_2005_XPATH = "wsp:ExactlyOne/wsp:All/sp2005:TransportBinding";
    private static final String PORT_XPATH = "//wsdl:definitions/wsdl:service/wsdl:port";
    private static final String ADDRESS_XPATH = "wsa10:EndpointReference/wsa10:Address";
    private static final String SOAP_ACTION_XPATH = "wsdl:operation/soap12:operation/@soapAction";
    private static final String RST_SOAP_ACTION = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
    private static final String RST_SOAP_ACTION_2005 = "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue";
    private static final String SOAP_TRANSPORT_XPATH = "soap12:binding/@transport";
    private static final String SOAP_HTTP_TRANSPORT_VALUE = "http://schemas.xmlsoap.org/soap/http";

    MexParser() {
    }

    static BindingPolicy getWsTrustEndpointFromMexResponse(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = SafeDocumentBuilderFactory.createInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8"))));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        xPath.setNamespaceContext((NamespaceContext)namespaceContextImpl);
        String string2 = "//wsdl:definitions/wsp:Policy/wsp:ExactlyOne/wsp:All/sp:SignedEncryptedSupportingTokens/wsp:Policy/sp:UsernameToken/wsp:Policy/sp:WssUsernameToken10";
        Map map = MexParser.selectUsernamePasswordPoliciesWithExpression((Document)document, (XPath)xPath, (String)string2);
        namespaceContextImpl.modifyNameSpace("sp", "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy");
        string2 = "//wsdl:definitions/wsp:Policy/wsp:ExactlyOne/wsp:All/sp:SignedSupportingTokens/wsp:Policy/sp:UsernameToken/wsp:Policy/sp:WssUsernameToken10";
        map.putAll(MexParser.selectUsernamePasswordPoliciesWithExpression((Document)document, (XPath)xPath, (String)string2));
        if (map.isEmpty()) {
            log.debug("No matching policies");
            return null;
        }
        Map map2 = MexParser.getMatchingBindings((Document)document, (XPath)xPath, (Map)map);
        if (map2.isEmpty()) {
            log.debug("No matching bindings");
            return null;
        }
        MexParser.getPortsForPolicyBindings((Document)document, (XPath)xPath, (Map)map2, (Map)map);
        return MexParser.selectSingleMatchingPolicy((Map)map);
    }

    static BindingPolicy getWsTrustEndpointFromMexEndpoint(String string, Proxy proxy, SSLSocketFactory sSLSocketFactory) throws Exception {
        String string2 = HttpHelper.executeHttpGet((Logger)log, (String)string, (Proxy)proxy, (SSLSocketFactory)sSLSocketFactory);
        return MexParser.getWsTrustEndpointFromMexResponse((String)string2);
    }

    private static BindingPolicy selectSingleMatchingPolicy(Map<String, BindingPolicy> map) {
        BindingPolicy bindingPolicy = null;
        BindingPolicy bindingPolicy2 = null;
        for (Map.Entry<String, BindingPolicy> entry : map.entrySet()) {
            if (entry.getValue().getUrl() == null) continue;
            if (entry.getValue().getVersion() == WSTrustVersion.WSTRUST13) {
                bindingPolicy = entry.getValue();
                continue;
            }
            if (entry.getValue().getVersion() != WSTrustVersion.WSTRUST2005) continue;
            bindingPolicy2 = entry.getValue();
        }
        if (bindingPolicy == null && bindingPolicy2 == null) {
            log.warn("no policies found with the url");
            return null;
        }
        return bindingPolicy != null ? bindingPolicy : bindingPolicy2;
    }

    private static void getPortsForPolicyBindings(Document document, XPath xPath, Map<String, BindingPolicy> map, Map<String, BindingPolicy> map2) throws Exception {
        NodeList nodeList = (NodeList)xPath.compile("//wsdl:definitions/wsdl:service/wsdl:port").evaluate(document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            log.warn("no ports found");
        } else {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                BindingPolicy bindingPolicy;
                Node node = nodeList.item(i2);
                String string = node.getAttributes().getNamedItem("binding").getNodeValue();
                String[] stringArray = string.split(":");
                BindingPolicy bindingPolicy2 = map.get(string = stringArray[stringArray.length - 1]);
                if (bindingPolicy2 == null || (bindingPolicy = map2.get(bindingPolicy2.getUrl())) == null || !StringHelper.isBlank((String)bindingPolicy.getUrl())) continue;
                bindingPolicy.setVersion(bindingPolicy2.getVersion());
                NodeList nodeList2 = (NodeList)xPath.compile("wsa10:EndpointReference/wsa10:Address").evaluate(node, XPathConstants.NODESET);
                if (nodeList2.getLength() > 0) {
                    String string2 = nodeList2.item(0).getTextContent();
                    if (string2 != null && string2.toLowerCase().startsWith("https://")) {
                        bindingPolicy.setUrl(string2.trim());
                        continue;
                    }
                    log.warn("skipping insecure endpoint: " + string2);
                    continue;
                }
                throw new Exception("no address nodes on port");
            }
        }
    }

    private static Map<String, BindingPolicy> getMatchingBindings(Document document, XPath xPath, Map<String, BindingPolicy> map) throws XPathExpressionException {
        HashMap<String, BindingPolicy> hashMap = new HashMap<String, BindingPolicy>();
        NodeList nodeList = (NodeList)xPath.compile("//wsdl:definitions/wsdl:binding/wsp:PolicyReference").evaluate(document, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            String string = node.getAttributes().getNamedItem("URI").getNodeValue();
            if (!map.containsKey(string)) continue;
            Node node2 = node.getParentNode();
            String string2 = node2.getAttributes().getNamedItem("name").getNodeValue();
            WSTrustVersion wSTrustVersion = MexParser.checkSoapActionAndTransport((XPath)xPath, (Node)node2);
            if (wSTrustVersion == WSTrustVersion.UNDEFINED) continue;
            BindingPolicy bindingPolicy = new BindingPolicy("");
            bindingPolicy.setUrl(string);
            bindingPolicy.setVersion(wSTrustVersion);
            hashMap.put(string2, bindingPolicy);
        }
        return hashMap;
    }

    private static WSTrustVersion checkSoapActionAndTransport(XPath xPath, Node node) throws XPathExpressionException {
        NodeList nodeList = null;
        String string = null;
        String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
        NodeList nodeList2 = (NodeList)xPath.compile("wsdl:operation/soap12:operation/@soapAction").evaluate(node, XPathConstants.NODESET);
        if (nodeList2.getLength() > 0) {
            string = nodeList2.item(0).getNodeValue();
            nodeList = (NodeList)xPath.compile("soap12:binding/@transport").evaluate(node, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() > 0 && nodeList.item(0).getNodeValue().equalsIgnoreCase("http://schemas.xmlsoap.org/soap/http")) {
                if (string.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue")) {
                    log.debug("Found binding matching Action and Transport: " + string2);
                    return WSTrustVersion.WSTRUST13;
                }
                if (string.equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue")) {
                    log.debug("Binding node did not match soap Action or Transport: " + string2);
                    return WSTrustVersion.WSTRUST2005;
                }
            }
        }
        return WSTrustVersion.UNDEFINED;
    }

    private static Map<String, BindingPolicy> selectUsernamePasswordPoliciesWithExpression(Document document, XPath xPath, String string) throws XPathExpressionException {
        HashMap<String, BindingPolicy> hashMap = new HashMap<String, BindingPolicy>();
        NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string2 = MexParser.checkPolicy((XPath)xPath, (Node)nodeList.item(i2).getParentNode().getParentNode().getParentNode().getParentNode().getParentNode().getParentNode().getParentNode());
            hashMap.put("#" + string2, new BindingPolicy("#" + string2));
        }
        return hashMap;
    }

    private static String checkPolicy(XPath xPath, Node node) throws XPathExpressionException {
        String string = null;
        Node node2 = node.getAttributes().getNamedItem("wsu:Id");
        NodeList nodeList = (NodeList)xPath.compile("wsp:ExactlyOne/wsp:All/sp:TransportBinding").evaluate(node, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            nodeList = (NodeList)xPath.compile("wsp:ExactlyOne/wsp:All/sp2005:TransportBinding").evaluate(node, XPathConstants.NODESET);
        }
        if (nodeList.getLength() > 0 && node2 != null) {
            string = node2.getNodeValue();
            log.debug("found matching policy id: " + string);
        } else {
            String string2 = "none";
            if (node2 != null) {
                string2 = node2.getNodeValue();
            }
            log.debug("potential policy did not match required transport binding: " + string2);
        }
        return string;
    }
}

