/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AsymmetricKeyCredential;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationException;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.ClientAssertion;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.RSASSASigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;

final class JwtHelper {
    JwtHelper() {
    }

    static ClientAssertion buildJwt(AsymmetricKeyCredential asymmetricKeyCredential, String string) throws AuthenticationException {
        SignedJWT signedJWT;
        if (asymmetricKeyCredential == null) {
            throw new IllegalArgumentException("credential is null");
        }
        long l2 = System.currentTimeMillis();
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().audience(Collections.singletonList(string)).issuer(asymmetricKeyCredential.getClientId()).notBeforeTime(new Date(l2)).expirationTime(new Date(l2 + 600000L)).subject(asymmetricKeyCredential.getClientId()).build();
        try {
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256);
            ArrayList<Base64> arrayList = new ArrayList<Base64>();
            arrayList.add(new Base64(asymmetricKeyCredential.getPublicCertificate()));
            builder.x509CertChain(arrayList);
            builder.x509CertThumbprint(new Base64URL(asymmetricKeyCredential.getPublicCertificateHash()));
            signedJWT = new SignedJWT(builder.build(), jWTClaimsSet);
            RSASSASigner rSASSASigner = new RSASSASigner(asymmetricKeyCredential.getKey());
            signedJWT.sign((JWSSigner)rSASSASigner);
        }
        catch (Exception exception) {
            throw new AuthenticationException((Throwable)exception);
        }
        return new ClientAssertion(signedJWT.serialize());
    }
}

