/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;

final class ClientDataHttpHeaders {
    public static final String PRODUCT_HEADER_NAME = "x-client-SKU";
    public static final String PRODUCT_HEADER_VALUE = "java";
    public static final String PRODUCT_VERSION_HEADER_NAME = "x-client-VER";
    public static final String PRODUCT_VERSION_HEADER_VALUE = ClientDataHttpHeaders.getProductVersion();
    public static final String CPU_HEADER_NAME = "x-client-CPU";
    public static final String CPU_HEADER_VALUE = System.getProperty("os.arch");
    public static final String OS_HEADER_NAME = "x-client-OS";
    public static final String OS_HEADER_VALUE = System.getProperty("os.name");
    public static final String CORRELATION_ID_HEADER_NAME = "client-request-id";
    public final String correlationIdHeaderValue;
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME = "return-client-request-id";
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE = "true";
    private final String headerValues;
    private final Map<String, String> headerMap = new HashMap();

    ClientDataHttpHeaders(String string) {
        this.correlationIdHeaderValue = !StringHelper.isBlank((String)string) ? string : UUID.randomUUID().toString();
        this.headerValues = this.initHeaderMap();
    }

    private String initHeaderMap() {
        StringBuilder stringBuilder = new StringBuilder();
        this.headerMap.put(PRODUCT_HEADER_NAME, PRODUCT_HEADER_VALUE);
        stringBuilder.append(PRODUCT_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(PRODUCT_HEADER_VALUE);
        stringBuilder.append(";");
        this.headerMap.put(PRODUCT_VERSION_HEADER_NAME, PRODUCT_VERSION_HEADER_VALUE);
        stringBuilder.append(PRODUCT_VERSION_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(PRODUCT_VERSION_HEADER_VALUE);
        stringBuilder.append(";");
        this.headerMap.put(OS_HEADER_NAME, OS_HEADER_VALUE);
        stringBuilder.append(OS_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(OS_HEADER_VALUE);
        stringBuilder.append(";");
        this.headerMap.put(CPU_HEADER_NAME, CPU_HEADER_VALUE);
        stringBuilder.append(CPU_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(CPU_HEADER_VALUE);
        stringBuilder.append(";");
        this.headerMap.put(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME, REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        stringBuilder.append(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        stringBuilder.append(";");
        this.headerMap.put(CORRELATION_ID_HEADER_NAME, this.correlationIdHeaderValue);
        stringBuilder.append(CORRELATION_ID_HEADER_NAME);
        stringBuilder.append("=");
        stringBuilder.append(this.correlationIdHeaderValue);
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    Map<String, String> getReadonlyHeaderMap() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    String getHeaderCorrelationIdValue() {
        return this.correlationIdHeaderValue;
    }

    public String toString() {
        return this.headerValues;
    }

    private static String getProductVersion() {
        if (ClientDataHttpHeaders.class.getPackage().getImplementationVersion() == null) {
            return "1.0";
        }
        return ClientDataHttpHeaders.class.getPackage().getImplementationVersion();
    }
}

