/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import macromedia.externals.com.google.gson_2_2_4.JsonElement;
import macromedia.externals.com.google.gson_2_2_4.JsonParser;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalAccessTokenResponse;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalAuthorizatonGrant;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalClaimsChallengeException;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalOAuthRequest;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationException;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationResult;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.UserInfo;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.TokenErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.token.OIDCTokens;

class AdalTokenRequest {
    private final URL uri;
    private final ClientAuthentication clientAuth;
    private final AdalAuthorizatonGrant authzGrant;
    private final Map<String, String> headerMap;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;

    AdalTokenRequest(URL uRL, ClientAuthentication clientAuthentication, AdalAuthorizatonGrant adalAuthorizatonGrant, Map<String, String> map, Proxy proxy, SSLSocketFactory sSLSocketFactory) {
        this.clientAuth = clientAuthentication;
        this.authzGrant = adalAuthorizatonGrant;
        this.uri = uRL;
        this.headerMap = map;
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
    }

    AuthenticationResult executeOAuthRequestAndProcessResponse() throws ParseException, AuthenticationException, SerializeException, IOException, java.text.ParseException {
        UserInfo userInfo;
        String string;
        OIDCTokens oIDCTokens;
        AdalAccessTokenResponse adalAccessTokenResponse;
        AuthenticationResult authenticationResult = null;
        HTTPResponse hTTPResponse = null;
        AdalOAuthRequest adalOAuthRequest = this.toOAuthRequest();
        hTTPResponse = adalOAuthRequest.send();
        if (hTTPResponse.getStatusCode() == 200) {
            adalAccessTokenResponse = AdalAccessTokenResponse.parseHttpResponse((HTTPResponse)hTTPResponse);
            oIDCTokens = adalAccessTokenResponse.getOIDCTokens();
            string = null;
            if (oIDCTokens.getRefreshToken() != null) {
                string = oIDCTokens.getRefreshToken().getValue();
            }
            userInfo = null;
            if (oIDCTokens.getIDToken() != null) {
                userInfo = UserInfo.createFromIdTokenClaims((JWTClaimsSet)oIDCTokens.getIDToken().getJWTClaimsSet());
            }
        } else {
            TokenErrorResponse tokenErrorResponse = TokenErrorResponse.parse((HTTPResponse)hTTPResponse);
            if (400 == tokenErrorResponse.getErrorObject().getHTTPStatusCode() && "interaction_required".equals(tokenErrorResponse.getErrorObject().getCode())) {
                throw new AdalClaimsChallengeException(tokenErrorResponse.toJSONObject().toJSONString(), this.getClaims(hTTPResponse.getContent()));
            }
            throw new AuthenticationException(tokenErrorResponse.toJSONObject().toJSONString());
        }
        authenticationResult = new AuthenticationResult(oIDCTokens.getAccessToken().getType().getValue(), oIDCTokens.getAccessToken().getValue(), string, oIDCTokens.getAccessToken().getLifetime(), oIDCTokens.getIDTokenString(), userInfo, !StringHelper.isBlank((String)adalAccessTokenResponse.getResource()));
        return authenticationResult;
    }

    private String getClaims(String string) {
        JsonElement jsonElement = new JsonParser().parse(string);
        JsonElement jsonElement2 = jsonElement.getAsJsonObject().get("claims");
        return jsonElement2 != null ? jsonElement2.getAsString() : null;
    }

    AdalOAuthRequest toOAuthRequest() throws SerializeException {
        if (this.uri == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        AdalOAuthRequest adalOAuthRequest = new AdalOAuthRequest(HTTPRequest.Method.POST, this.uri, this.headerMap, this.proxy, this.sslSocketFactory);
        adalOAuthRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map map = this.authzGrant.toParameters();
        adalOAuthRequest.setQuery(URLUtils.serializeParameters((Map)map));
        if (this.clientAuth != null) {
            this.clientAuth.applyTo((HTTPRequest)adalOAuthRequest);
        }
        return adalOAuthRequest;
    }
}

