/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.HttpHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.LoggerFactory;

class AdalOAuthRequest
extends HTTPRequest {
    private final Map<String, String> extraHeaderParams;
    private final Logger log = LoggerFactory.getLogger(AdalOAuthRequest.class);
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;

    AdalOAuthRequest(HTTPRequest.Method method, URL uRL, Map<String, String> map, Proxy proxy, SSLSocketFactory sSLSocketFactory) {
        super(method, uRL);
        this.extraHeaderParams = map;
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
    }

    Map<String, String> getReadOnlyExtraHeaderParameters() {
        return Collections.unmodifiableMap(this.extraHeaderParams);
    }

    public HTTPResponse send() throws IOException {
        HttpsURLConnection httpsURLConnection = HttpHelper.openConnection((URL)this.getURL(), (Proxy)this.proxy, (SSLSocketFactory)this.sslSocketFactory);
        this.configureHeaderAndExecuteOAuthCall(httpsURLConnection);
        String string = this.processAndReadResponse((HttpURLConnection)httpsURLConnection);
        HttpHelper.verifyReturnedCorrelationId((Logger)this.log, (HttpsURLConnection)httpsURLConnection, (String)((String)this.extraHeaderParams.get("client-request-id")));
        return this.createResponse((HttpURLConnection)httpsURLConnection, string);
    }

    HTTPResponse createResponse(HttpURLConnection httpURLConnection, String string) throws IOException {
        HTTPResponse hTTPResponse = new HTTPResponse(httpURLConnection.getResponseCode());
        String string2 = httpURLConnection.getHeaderField("Location");
        if (!StringHelper.isBlank((String)string2)) {
            try {
                hTTPResponse.setLocation(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException("Invalid location URI " + string2, uRISyntaxException);
            }
        }
        try {
            hTTPResponse.setContentType(httpURLConnection.getContentType());
        }
        catch (ParseException parseException) {
            throw new IOException("Couldn't parse Content-Type header: " + parseException.getMessage(), parseException);
        }
        hTTPResponse.setCacheControl(httpURLConnection.getHeaderField("Cache-Control"));
        hTTPResponse.setPragma(httpURLConnection.getHeaderField("Pragma"));
        hTTPResponse.setWWWAuthenticate(httpURLConnection.getHeaderField("WWW-Authenticate"));
        if (!StringHelper.isBlank((String)string)) {
            hTTPResponse.setContent(string);
        }
        return hTTPResponse;
    }

    void configureHeaderAndExecuteOAuthCall(HttpsURLConnection httpsURLConnection) throws IOException {
        if (this.getAuthorization() != null) {
            httpsURLConnection.setRequestProperty("Authorization", this.getAuthorization());
        }
        HashMap hashMap = new HashMap();
        if (this.extraHeaderParams != null && !this.extraHeaderParams.isEmpty()) {
            for (Map.Entry entry : this.extraHeaderParams.entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).isEmpty()) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        HttpHelper.configureAdditionalHeaders((HttpsURLConnection)httpsURLConnection, hashMap);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setRequestProperty("Content-Type", CommonContentTypes.APPLICATION_URLENCODED.toString());
        if (this.getQuery() != null) {
            Map.Entry entry;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            entry = null;
            try {
                outputStreamWriter.write(this.getQuery());
                outputStreamWriter.flush();
            }
            catch (Throwable throwable) {
                entry = throwable;
                throw throwable;
            }
            finally {
                if (outputStreamWriter != null) {
                    if (entry != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)entry)).addSuppressed(throwable);
                        }
                    } else {
                        outputStreamWriter.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processAndReadResponse(HttpURLConnection httpURLConnection) throws IOException {
        Closeable closeable;
        InputStreamReader inputStreamReader = null;
        int n2 = httpURLConnection.getResponseCode();
        if (n2 == 200) {
            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
        } else {
            closeable = httpURLConnection.getErrorStream();
            if (closeable == null && n2 == 404) {
                closeable = httpURLConnection.getInputStream();
            }
            if (closeable == null) {
                closeable = httpURLConnection.getInputStream();
            }
            inputStreamReader = new InputStreamReader((InputStream)closeable);
        }
        closeable = new BufferedReader(inputStreamReader);
        char[] cArray = new char[256];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n3;
            while ((n3 = ((BufferedReader)closeable).read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n3);
            }
        }
        finally {
            ((BufferedReader)closeable).close();
        }
        return stringBuilder.toString();
    }
}

