/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4.internal.bind;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import macromedia.externals.com.google.gson_2_2_4.JsonSyntaxException;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapterFactory;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonReader;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonToken;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonWriter;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new /* Unavailable Anonymous Inner Class!! */;
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat localFormat = DateFormat.getDateTimeInstance(2, 2);
    private final DateFormat iso8601Format = DateTypeAdapter.buildIso8601Format();

    private static DateFormat buildIso8601Format() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.deserializeToDate(jsonReader.nextString());
    }

    private synchronized Date deserializeToDate(String string) {
        try {
            return this.localFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.enUsFormat.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    return this.iso8601Format.parse(string);
                }
                catch (ParseException parseException3) {
                    throw new JsonSyntaxException(string, (Throwable)parseException3);
                }
            }
        }
    }

    public synchronized void write(JsonWriter jsonWriter, Date date) throws IOException {
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        String string = this.enUsFormat.format(date);
        jsonWriter.value(string);
    }
}

