/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.google.gson_2_2_4.internal.LinkedTreeMap;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new /* Unavailable Anonymous Inner Class!! */;
    Comparator<? super K> comparator;
    Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final Node<K, V> header = new Node();
    private EntrySet entrySet;
    private KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER);
    }

    public LinkedTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object object) {
        Node node = this.findByObject(object);
        return (V)(node != null ? node.value : null);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new NullPointerException("key == null");
        }
        Node node = this.find(k2, true);
        Object object = node.value;
        node.value = v2;
        return (V)object;
    }

    @Override
    public void clear() {
        Node node;
        this.root = null;
        this.size = 0;
        ++this.modCount;
        node.next = node.prev = (node = this.header);
    }

    @Override
    public V remove(Object object) {
        Node node = this.removeInternalByKey(object);
        return (V)(node != null ? node.value : null);
    }

    Node<K, V> find(K k2, boolean bl2) {
        Node node;
        Comparable comparable;
        Comparator comparator = this.comparator;
        Node node2 = this.root;
        int n2 = 0;
        if (node2 != null) {
            comparable = comparator == NATURAL_ORDER ? (Comparable)k2 : null;
            while (true) {
                int n3 = n2 = comparable != null ? comparable.compareTo(node2.key) : comparator.compare(k2, node2.key);
                if (n2 == 0) {
                    return node2;
                }
                Node node3 = node = n2 < 0 ? node2.left : node2.right;
                if (node == null) break;
                node2 = node;
            }
        }
        if (!bl2) {
            return null;
        }
        comparable = this.header;
        if (node2 == null) {
            if (comparator == NATURAL_ORDER && !(k2 instanceof Comparable)) {
                throw new ClassCastException(k2.getClass().getName() + " is not Comparable");
            }
            this.root = node = new Node(node2, k2, (Node)comparable, ((Node)comparable).prev);
        } else {
            node = new Node(node2, k2, (Node)comparable, ((Node)comparable).prev);
            if (n2 < 0) {
                node2.left = node;
            } else {
                node2.right = node;
            }
            this.rebalance(node2, true);
        }
        ++this.size;
        ++this.modCount;
        return node;
    }

    Node<K, V> findByObject(Object object) {
        try {
            return object != null ? this.find(object, false) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node node = this.findByObject(entry.getKey());
        boolean bl2 = node != null && this.equal(node.value, entry.getValue());
        return bl2 ? node : null;
    }

    private boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    void removeInternal(Node<K, V> node, boolean bl2) {
        if (bl2) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        if (node2 != null && node3 != null) {
            Node node5 = node2.height > node3.height ? node2.last() : node3.first();
            this.removeInternal(node5, false);
            int n2 = 0;
            node2 = node.left;
            if (node2 != null) {
                n2 = node2.height;
                node5.left = node2;
                node2.parent = node5;
                node.left = null;
            }
            int n3 = 0;
            node3 = node.right;
            if (node3 != null) {
                n3 = node3.height;
                node5.right = node3;
                node3.parent = node5;
                node.right = null;
            }
            node5.height = Math.max(n2, n3) + 1;
            this.replaceInParent(node, node5);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        --this.size;
        ++this.modCount;
    }

    Node<K, V> removeInternalByKey(Object object) {
        Node node = this.findByObject(object);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> node2) {
        Node node3 = node.parent;
        node.parent = null;
        if (node2 != null) {
            node2.parent = node3;
        }
        if (node3 != null) {
            if (node3.left == node) {
                node3.left = node2;
            } else {
                assert (node3.right == node);
                node3.right = node2;
            }
        } else {
            this.root = node2;
        }
    }

    private void rebalance(Node<K, V> node, boolean bl2) {
        Node node2 = node;
        while (node2 != null) {
            int n2;
            Node node3;
            int n3;
            int n4;
            Node node4;
            Node node5;
            int n5;
            Node node6 = node2.left;
            int n6 = node6 != null ? node6.height : 0;
            int n7 = n6 - (n5 = (node5 = node2.right) != null ? node5.height : 0);
            if (n7 == -2) {
                node4 = node5.left;
                n4 = node4 != null ? node4.height : 0;
                n2 = n4 - (n3 = (node3 = node5.right) != null ? node3.height : 0);
                if (n2 == -1 || n2 == 0 && !bl2) {
                    this.rotateLeft(node2);
                } else {
                    assert (n2 == 1);
                    this.rotateRight(node5);
                    this.rotateLeft(node2);
                }
                if (bl2) {
                    break;
                }
            } else if (n7 == 2) {
                node4 = node6.left;
                n4 = node4 != null ? node4.height : 0;
                n2 = n4 - (n3 = (node3 = node6.right) != null ? node3.height : 0);
                if (n2 == 1 || n2 == 0 && !bl2) {
                    this.rotateRight(node2);
                } else {
                    assert (n2 == -1);
                    this.rotateLeft(node6);
                    this.rotateRight(node2);
                }
                if (bl2) {
                    break;
                }
            } else if (n7 == 0) {
                node2.height = n6 + 1;
                if (bl2) {
                    break;
                }
            } else {
                assert (n7 == -1 || n7 == 1);
                node2.height = Math.max(n6, n5) + 1;
                if (!bl2) break;
            }
            node2 = node2.parent;
        }
    }

    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        node.height = Math.max(node2 != null ? node2.height : 0, node4 != null ? node4.height : 0) + 1;
        node3.height = Math.max(node.height, node5 != null ? node5.height : 0) + 1;
    }

    private void rotateRight(Node<K, V> node) {
        Node node2;
        Node node3 = node.left;
        Node node4 = node.right;
        Node node5 = node3.left;
        node.left = node2 = node3.right;
        if (node2 != null) {
            node2.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.right = node;
        node.parent = node3;
        node.height = Math.max(node4 != null ? node4.height : 0, node2 != null ? node2.height : 0) + 1;
        node3.height = Math.max(node.height, node5 != null ? node5.height : 0) + 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this));
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet(this));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }
}

