/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4;

import java.io.IOException;
import macromedia.externals.com.google.gson_2_2_4.Gson;
import macromedia.externals.com.google.gson_2_2_4.JsonDeserializer;
import macromedia.externals.com.google.gson_2_2_4.JsonElement;
import macromedia.externals.com.google.gson_2_2_4.JsonSerializer;
import macromedia.externals.com.google.gson_2_2_4.TreeTypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapterFactory;
import macromedia.externals.com.google.gson_2_2_4.internal.Streams;
import macromedia.externals.com.google.gson_2_2_4.reflect.TypeToken;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonReader;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonWriter;

final class TreeTypeAdapter<T>
extends TypeAdapter<T> {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;
    private final Gson gson;
    private final TypeToken<T> typeToken;
    private final TypeAdapterFactory skipPast;
    private TypeAdapter<T> delegate;

    private TreeTypeAdapter(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory typeAdapterFactory) {
        this.serializer = jsonSerializer;
        this.deserializer = jsonDeserializer;
        this.gson = gson;
        this.typeToken = typeToken;
        this.skipPast = typeAdapterFactory;
    }

    public T read(JsonReader jsonReader) throws IOException {
        if (this.deserializer == null) {
            return (T)this.delegate().read(jsonReader);
        }
        JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
        if (jsonElement.isJsonNull()) {
            return null;
        }
        return (T)this.deserializer.deserialize(jsonElement, this.typeToken.getType(), this.gson.deserializationContext);
    }

    public void write(JsonWriter jsonWriter, T t2) throws IOException {
        if (this.serializer == null) {
            this.delegate().write(jsonWriter, t2);
            return;
        }
        if (t2 == null) {
            jsonWriter.nullValue();
            return;
        }
        JsonElement jsonElement = this.serializer.serialize(t2, this.typeToken.getType(), this.gson.serializationContext);
        Streams.write((JsonElement)jsonElement, (JsonWriter)jsonWriter);
    }

    private TypeAdapter<T> delegate() {
        TypeAdapter typeAdapter = this.delegate;
        return typeAdapter != null ? typeAdapter : (this.delegate = this.gson.getDelegateAdapter(this.skipPast, this.typeToken));
    }

    public static TypeAdapterFactory newFactory(TypeToken<?> typeToken, Object object) {
        return new SingleTypeFactory(object, typeToken, false, null, null);
    }

    public static TypeAdapterFactory newFactoryWithMatchRawType(TypeToken<?> typeToken, Object object) {
        boolean bl2 = typeToken.getType() == typeToken.getRawType();
        return new SingleTypeFactory(object, typeToken, bl2, null, null);
    }

    public static TypeAdapterFactory newTypeHierarchyFactory(Class<?> clazz, Object object) {
        return new SingleTypeFactory(object, null, false, clazz, null);
    }
}

