/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.vfs.s3.S3FileUploadUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jets3t.service.S3Service;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

class S3OutputStream
extends OutputStream {
    private FileOutputStream out;
    private File tempFile;
    private S3Object obj;
    private S3Service service;
    private S3Bucket bucket;

    S3OutputStream(S3Object obj, S3Service service, S3Bucket bucket, boolean append) throws IOException {
        this.obj = obj;
        this.service = service;
        this.bucket = bucket;
        this.tempFile = this.createTempFile();
        this.out = this.createTempOutputStream(this.tempFile);
        if (append) {
            this.writeObjectToTempFile(service, bucket, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObjectToTempFile(S3Service service, S3Bucket bucket, S3Object obj) throws IOException {
        try {
            obj = service.getObject(bucket, obj.getKey());
            try (InputStream in = obj.getDataInputStream();){
                int read;
                byte[] buffer = new byte[1024];
                while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                    this.out.write(buffer, 0, read);
                }
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    S3OutputStream.this._close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private void _close() throws IOException {
        this.out.close();
        try {
            S3FileUploadUtil.copyFile(this.tempFile, this.obj, this.service, this.bucket);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            String string = errMsg = errMsg == null ? "" : errMsg + " ";
            if (e instanceof ServiceException) {
                errMsg = errMsg + ((ServiceException)((Object)e)).getErrorMessage();
            }
            throw new IOException(errMsg);
        }
        finally {
            this.tempFile.delete();
        }
    }

    private File createTempFile() throws IOException {
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return File.createTempFile("s3_", ".tmp");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private FileOutputStream createTempOutputStream(final File file) throws IOException {
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

