/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.server.StoreService;
import coldfusion.store.S3StoreService;
import coldfusion.util.MimeTypeUtils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import coldfusion.vfs.s3.S3FileObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.vfs2.FileContent;
import org.jets3t.service.S3Service;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.utils.MultipartUtils;
import org.jets3t.service.utils.ServiceUtils;

public class S3FileUploadUtil {
    private static final String[] ignoreKeys = new String[]{"Date", "date", "ETag", "etag", "content_language", "content_length", "id-2", "last_modified", "owner", "request-id"};
    public static int SIMPLE_UPLOADER_MAX_FILE_SIZE = 5;

    public static void copyFile(String source, VFile dest) throws IOException {
        File dataFile = VFSFileFactory.getFileObject((String)source);
        S3FileUploadUtil.copyFile(dataFile, dest);
    }

    public static void copyFile(File dataFile, VFile dest) throws IOException {
        S3FileObject fo = (S3FileObject)dest.getFileObject();
        S3FileObject s3File = fo;
        if (s3File.getS3Object() == null) {
            s3File.createS3Object();
        }
        S3Object s3Object = s3File.getS3Object();
        try {
            String mimeType = S3FileUploadUtil.getMimeType(dest.getName());
            if (dataFile instanceof VFile && ((VFile)dataFile).getFileObject() instanceof S3FileObject) {
                S3StoreService storeService = (S3StoreService)StoreService.getStoreService((String)"s3");
                Map metadataMap = storeService.getMetadata(null, (VFile)dataFile, false);
                S3FileUploadUtil.cleanMetadata(metadataMap);
                if (mimeType != null) {
                    metadataMap.put("Content-Type", mimeType);
                }
                S3FileUploadUtil.setMetadata(s3File, metadataMap);
                S3FileUploadUtil.copyFile((S3FileObject)((VFile)dataFile).getFileObject(), s3Object, s3File.getS3Service());
            } else {
                if (mimeType != null) {
                    s3Object.setContentType(mimeType);
                }
                S3FileUploadUtil.copyFile(dataFile, s3Object, s3File.getS3Service(), null, false);
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            String string = errMsg = errMsg == null ? "" : errMsg + " ";
            if (e instanceof ServiceException) {
                errMsg = errMsg + ((ServiceException)((Object)e)).getErrorMessage();
            }
            throw new IOException(errMsg);
        }
    }

    private static void copyFile(S3FileObject src, S3Object dest, S3Service service) throws ServiceException {
        service.copyObject(src.getBucketName(), src.getS3Key(), dest.getBucketName(), (StorageObject)dest, true);
        S3FileUploadUtil.cleanMetadata(dest);
        dest.setMetadataComplete(true);
    }

    private static void cleanMetadata(Map map) {
        for (String key : ignoreKeys) {
            if (!map.containsKey(key)) continue;
            map.remove(key);
        }
    }

    private static void setMetadata(S3FileObject fileObject, Map metadata) {
        try {
            FileContent content = fileObject.getContent();
            if (metadata != null) {
                for (String key : metadata.keySet()) {
                    if (key.startsWith("__")) continue;
                    Object value = metadata.get(key);
                    content.setAttribute(key, value);
                }
            }
        }
        catch (Exception e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
    }

    public static String getMimeType(String name) {
        try {
            String mime = MimeTypeUtils.guessMimeType((String)name);
            if (mime == null) {
                return Files.probeContentType(Paths.get(name, new String[0]));
            }
            return mime;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void copyFile(File source, S3Object s3Object, S3Service service, S3Bucket bucket) throws Exception {
        S3FileUploadUtil.copyFile(source, s3Object, service, bucket, true);
    }

    private static void copyFile(File source, S3Object s3Object, S3Service service, S3Bucket bucket, boolean guessMimeType) throws Exception {
        String mimeType22;
        String contentType;
        s3Object.setContentLength(source.length());
        if (!(!guessMimeType || (contentType = s3Object.getContentType()) != null && !contentType.equals("application/octet-stream") || (mimeType22 = S3FileUploadUtil.getMimeType(s3Object.getKey())) == null || contentType != null && mimeType22.equals(contentType))) {
            s3Object.setContentType(mimeType22);
        }
        FileInputStream is = new FileInputStream(source);
        s3Object.setDataInputFile(source);
        try {
            if (is != null) {
                s3Object.setMd5Hash(ServiceUtils.computeMD5Hash((InputStream)is));
            }
        }
        catch (NoSuchAlgorithmException mimeType22) {
            // empty catch block
        }
        S3FileUploadUtil.cleanMetadata(s3Object);
        if (source.length() / 0x100000L > (long)SIMPLE_UPLOADER_MAX_FILE_SIZE) {
            MultipartUtils mpUtils = new MultipartUtils();
            ArrayList<S3Object> list = new ArrayList<S3Object>();
            list.add(s3Object);
            mpUtils.uploadObjects(s3Object.getBucketName(), service, list, null);
        } else if (bucket != null) {
            service.putObject(bucket, s3Object);
        } else {
            service.putObject(s3Object.getBucketName(), s3Object);
        }
        S3FileUploadUtil.cleanMetadata(s3Object);
        s3Object.setMetadataComplete(true);
    }

    private static void cleanMetadata(S3Object s3Obj) {
        if (s3Obj != null) {
            s3Obj.removeMetadata("Date");
            s3Obj.removeMetadata("last-modified");
            s3Obj.removeMetadata("etag");
            s3Obj.removeMetadata("__complete__");
            s3Obj.removeMetadata("__service__");
            s3Obj.removeMetadata("__http__");
            s3Obj.removeMetadata("__user__");
        }
    }
}

