/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class UpdateKeyRequest {
    private final String vaultBaseUrl;
    private final String keyName;
    private final String keyVersion;
    private final List<JsonWebKeyOperation> keyOperations;
    private final KeyAttributes keyAttributes;
    private final Map<String, String> tags;

    private UpdateKeyRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.keyName = builder.keyName;
        this.keyVersion = builder.keyVersion == null ? "" : builder.keyVersion;
        this.keyOperations = builder.keyOperations != null ? new ArrayList<JsonWebKeyOperation>(builder.keyOperations) : null;
        this.keyAttributes = builder.attributes != null ? (KeyAttributes)new KeyAttributes().withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()).withNotBefore(builder.attributes.notBefore()) : null;
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String keyName() {
        return this.keyName;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    public List<JsonWebKeyOperation> keyOperations() {
        return this.keyOperations;
    }

    public KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String keyName;
        private String keyVersion;
        private List<JsonWebKeyOperation> keyOperations;
        private KeyAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String keyName) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.keyName = keyName;
        }

        public Builder(String keyIdentifier) {
            KeyIdentifier id = new KeyIdentifier(keyIdentifier);
            this.vaultBaseUrl = id.vault();
            this.keyName = id.name();
            this.keyVersion = id.version();
        }

        public Builder withVersion(String keyVersion) {
            this.keyVersion = keyVersion;
            return this;
        }

        public Builder withKeyOperations(List<JsonWebKeyOperation> keyOperations) {
            this.keyOperations = keyOperations;
            return this;
        }

        public Builder withAttributes(Attributes attributes) {
            if (!(attributes instanceof KeyAttributes)) {
                throw new IllegalArgumentException("Parameter 'attributes' should be instance of CertificateAttributes, or a subclass");
            }
            this.attributes = (KeyAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public UpdateKeyRequest build() {
            return new UpdateKeyRequest(this);
        }
    }
}

