/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.document.JPedalFontRegistry;
import coldfusion.document.webkit.core.PDFgHFContentProvider;
import coldfusion.filter.FusionContext;
import coldfusion.pdf.PDFDocSecurityHandler;
import coldfusion.pdf.PDFDocUtil;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.core.PDFDocException;
import coldfusion.pdf.core.PDFException;
import coldfusion.pdf.customfilters.DCTCustomEncodeFilter;
import coldfusion.pdf.customfilters.JBIG2CustomFilter;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.io.DirFileUtils;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.vfs.VFSFileFactory;
import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteBufferByteReader;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ChainedInputStream;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.LazyRandomAccessFileByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import com.adobe.internal.pdfm.pagelabeler.PageLabelInfo;
import com.adobe.internal.pdfm.pagelabeler.PageLabelRange;
import com.adobe.internal.pdfm.util.FontSetBuilder;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.credentials.CredentialFactory;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolderFactory;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSetManager;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageWithLocation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageWithLocationMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsField;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJavaScriptEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItemData;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSort;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabel;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabelStyle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabels;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTabOrder;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldFactory;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.CertJNonFIPSProvider;
import com.adobe.internal.pdftoolkit.services.imageconversion.BufferedImageWrapper;
import com.adobe.internal.pdftoolkit.services.imageconversion.ImageManager;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMPageTransformations;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.rcg.RichTextContentGenerator;
import com.adobe.internal.pdftoolkit.services.readingorder.ReadingOrderTextExtractor;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractionOptions;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractor;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import com.adobe.internal.pdftoolkit.services.textextraction.WordsIterator;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xobjhandler.PageContentXObject;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectContentType;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.JAI;
import javax.print.attribute.standard.PageRanges;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.exception.PdfException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PDFDocHandler {
    private PDFDocSecurityHandler secHandler;
    private String PAGE_END_REPLACE = "[*]";
    private String PAGE_END_CHECK = "*";
    private static final String WORDNS = "";
    private static final String WORDSELEM = "DocText";
    private static final String TEXTPERPAGEELEM = "TextPerPage";
    private static final String WITHQUADSELEM = "WithQuads";
    private static final String WORDELEM = "Word";
    private static final String PAGEELEM = "Page";
    private static final String QUADELEM = "Quad";
    private static final String P1ELEM = "P1";
    private static final String P2ELEM = "P2";
    private static final String P3ELEM = "P3";
    private static final String P4ELEM = "P4";
    private static final String PAGENUMATTR = "pageNumber";
    private static final String XATTR = "X";
    private static final String YATTR = "Y";
    private static final String JKS_TYPE = "jks";
    private static final String PKCS12_TYPE = "pkcs12";
    public boolean removeBackground = false;
    private int dpi = 72;
    private static final String strIndexKey = "index_key";
    private static final ASName indexKey = ASName.create((String)"index_key");
    private static final boolean matchOnlyIfFirstMarkingOperator = true;
    private static final boolean removeFirstOccurrenceOnly = true;
    private static final double backgroundToPageRectMinRatio = 0.75;
    private static final boolean assumeBackgroundIsInsetOfPageRect = false;
    private static final HashSet markingOperators;
    private static final ASName[] matchSequence;

    public PDFDocSecurityHandler getPdfDocSecurityHandler() {
        if (this.secHandler == null) {
            this.secHandler = new PDFDocSecurityHandler();
        }
        return this.secHandler;
    }

    public PDFDocument readInternal(String password, Object source, boolean absorbError, boolean useRaf, boolean useFont) throws PDFException, IOException {
        if (source instanceof PDFDocWrapper) {
            PDFDocWrapper wrapper = (PDFDocWrapper)source;
            if (wrapper.getDoc().getCosDocument() == null) {
                throw new PDFException.PDFInvalidDocumentVariableException();
            }
            this.getPdfDocSecurityHandler().checkNDecrypt(wrapper.getDoc(), password, absorbError);
            return wrapper.getDoc();
        }
        if (source instanceof String) {
            return this.readInternal(password, (String)source, absorbError, useRaf, useFont);
        }
        if (source instanceof byte[]) {
            return this.readInternal(password, (byte[])source, absorbError, useFont);
        }
        if (source instanceof PDFDocument && ((PDFDocument)source).getCosDocument() == null) {
            throw new PDFException.PDFInvalidDocumentVariableException();
        }
        return (PDFDocument)source;
    }

    public PDFDocument readInternal(String password, Object source, boolean absorbError, boolean useRaf) throws PDFException, IOException {
        if (source instanceof PDFDocWrapper) {
            PDFDocWrapper wrapper = (PDFDocWrapper)source;
            if (wrapper.getDoc().getCosDocument() == null) {
                throw new PDFException.PDFInvalidDocumentVariableException();
            }
            this.getPdfDocSecurityHandler().checkNDecrypt(wrapper.getDoc(), password, absorbError);
            return wrapper.getDoc();
        }
        if (source instanceof String) {
            return this.readInternal(password, (String)source, absorbError, useRaf);
        }
        if (source instanceof byte[]) {
            return this.readInternal(password, (byte[])source, absorbError);
        }
        if (source instanceof PDFDocument && ((PDFDocument)source).getCosDocument() == null) {
            throw new PDFException.PDFInvalidDocumentVariableException();
        }
        return (PDFDocument)source;
    }

    private PDFDocument readInternal(String password, byte[] source, boolean absorbError) throws PDFException, IOException {
        return this.readInternal(password, source, absorbError, false);
    }

    private PDFDocument readInternal(String password, byte[] source, boolean absorbError, boolean useFont) throws PDFException, IOException {
        PDFDocument pdfDocument = null;
        try {
            InputStreamByteReader byteReader = new InputStreamByteReader((InputStream)new ByteArrayInputStream(source));
            PDFOpenOptions createCustomFilterOpenOptions = PDFDocHandler.createCustomFilterOpenOptions();
            if (useFont) {
                createCustomFilterOpenOptions.setFontSet((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet());
            }
            pdfDocument = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)createCustomFilterOpenOptions);
            this.getPdfDocSecurityHandler().checkNDecrypt(pdfDocument, password, absorbError);
            if (this.removeBackground) {
                ArrayList instructionAccumulator = new ArrayList();
                PDFPageTree pages = pdfDocument.requirePages();
                Iterator iter = pages.iterator();
                while (iter.hasNext()) {
                    this.removeBackground(instructionAccumulator, iter, pdfDocument);
                }
            }
            this.removeBackground = false;
            return pdfDocument;
        }
        catch (Exception e) {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof PDFUnsupportedFeatureException) {
                throw (PDFUnsupportedFeatureException)e;
            }
            if (e instanceof PDFException) {
                throw (PDFException)((Object)e);
            }
            if (e instanceof PDFException.PDFInvalidDocumentVariableException) {
                throw (PDFException.PDFInvalidDocumentVariableException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private void removeBackground(ArrayList instructionAccumulator, Iterator iter, PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        instructionAccumulator.clear();
        int currentMatchIndex = -1;
        boolean dropAccumulatedInstructions = false;
        boolean writeAccumulatedInstructions = false;
        boolean markingInstructionFound = false;
        boolean contentRemoved = false;
        PDFPage page = (PDFPage)iter.next();
        Content pageContent = Content.newInstance((PDFPage)page);
        ContentReader reader = ContentReader.newInstance((Content)pageContent);
        ContentWriter writer = ContentWriter.newInstance((PDFDocument)pdfDocument);
        while (reader.hasNext()) {
            Instruction instr = reader.next();
            boolean instrInAccumulator = false;
            if (markingOperators.contains(instr.getOperator())) {
                markingInstructionFound = true;
            }
            if (contentRemoved) {
                if (contentRemoved) {
                    // empty if block
                }
            } else {
                if (instr.getOperator().equals((Object)matchSequence[currentMatchIndex + 1])) {
                    instructionAccumulator.add(instr);
                    instrInAccumulator = true;
                    if (++currentMatchIndex == matchSequence.length - 1) {
                        if (PDFDocHandler.sequenceContraintsSatisfied(pdfDocument, page, instructionAccumulator)) {
                            dropAccumulatedInstructions = true;
                        } else {
                            writeAccumulatedInstructions = true;
                        }
                    }
                } else {
                    writeAccumulatedInstructions = true;
                }
                if (markingInstructionFound && !contentRemoved && !instrInAccumulator) break;
            }
            if (writeAccumulatedInstructions && !instructionAccumulator.isEmpty()) {
                for (Instruction currentMatchInstr : instructionAccumulator) {
                    writer.write(currentMatchInstr);
                }
            }
            if (!instrInAccumulator) {
                writer.write(instr);
            }
            if (dropAccumulatedInstructions) {
                contentRemoved = true;
            }
            if (!dropAccumulatedInstructions && !writeAccumulatedInstructions) continue;
            instructionAccumulator.clear();
            currentMatchIndex = -1;
            writeAccumulatedInstructions = false;
            dropAccumulatedInstructions = false;
        }
        if (contentRemoved) {
            Content newContent = writer.close();
            page.setContents(newContent.getContents());
        }
    }

    private static boolean sequenceContraintsSatisfied(PDFDocument doc, PDFPage page, ArrayList instructions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int i;
        Instruction instr = (Instruction)instructions.get(0);
        OperandStack ops = instr.getOperands();
        for (i = 0; i < 3; ++i) {
            if (ops.peekTypeIsNumber()) {
                if (ops.popNumber().intValue() == 1) continue;
                return false;
            }
            return false;
        }
        instr = (Instruction)instructions.get(8);
        ops = instr.getOperands();
        for (i = 0; i < 3; ++i) {
            if (ops.peekTypeIsNumber()) {
                if (ops.popNumber().doubleValue() == 0.0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static PDFOpenOptions createCustomFilterOpenOptions() {
        PDFOpenOptions openOptions = PDFOpenOptions.newInstance();
        ArrayList<Object> customFilters = new ArrayList<Object>(2);
        customFilters.add(new DCTCustomEncodeFilter());
        customFilters.add(new JBIG2CustomFilter());
        openOptions.registerCustomFilters(customFilters);
        return openOptions;
    }

    private PDFDocument readInternal(String password, String source, boolean absorbError, boolean useRaf) throws PDFException, IOException {
        return this.readInternal(password, source, absorbError, useRaf, false);
    }

    private PDFDocument readInternal(String password, String source, boolean absorbError, boolean useRaf, boolean useFont) throws PDFException, IOException {
        PDFDocument pdfDocument = null;
        ByteReader inputFile = null;
        try {
            inputFile = useRaf ? PDFDocUtil.getRAFByteReader(source) : PDFDocUtil.getInputStreamByteReader(source);
            PDFOpenOptions createCustomFilterOpenOptions = PDFDocHandler.createCustomFilterOpenOptions();
            if (useFont) {
                createCustomFilterOpenOptions.setFontSet((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet());
            }
            pdfDocument = PDFDocument.newInstance((ByteReader)inputFile, (PDFOpenOptions)createCustomFilterOpenOptions);
            this.getPdfDocSecurityHandler().checkNDecrypt(pdfDocument, password, absorbError);
            try {
                pdfDocument.requirePages();
            }
            catch (Exception ex) {
                throw new PDFInvalidDocumentException((Throwable)ex);
            }
            return pdfDocument;
        }
        catch (Exception e) {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
                if (inputFile != null) {
                    inputFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof PDFUnsupportedFeatureException) {
                throw (PDFUnsupportedFeatureException)e;
            }
            if (e instanceof PDFException) {
                throw (PDFException)((Object)e);
            }
            if (e instanceof PDFException.PDFInvalidDocumentVariableException) {
                throw (PDFException.PDFInvalidDocumentVariableException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readFile(String source) {
        PDFDocument pdfDocument = null;
        ByteReader inputFile = null;
        boolean isPdf = false;
        try {
            inputFile = PDFDocUtil.getInputStreamByteReader(source);
            pdfDocument = PDFDocument.newInstance((ByteReader)inputFile, (PDFOpenOptions)PDFDocHandler.createCustomFilterOpenOptions());
            isPdf = true;
        }
        catch (Exception e) {
            isPdf = false;
        }
        finally {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
                if (inputFile != null) {
                    inputFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return isPdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(String keystoreFile, String keystorePassword, String storeType) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(keystoreFile);
            KeyStore keystore = KeyStore.getInstance(storeType);
            keystore.load(fis, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
    }

    private KeyStore getKeyStore(String keystoreFile, String keystorePassword) {
        try {
            return this.getKeyStore(keystoreFile, keystorePassword, JKS_TYPE);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return this.getKeyStore(keystoreFile, keystorePassword, PKCS12_TYPE);
            }
            catch (ApplicationException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new PDFException.InvalidKeystoreException(t);
            }
        }
    }

    private String getKeyAlias(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }

    public Credentials getCredentials(String keystoreFile, String keyPassword, String keyalias, String keystorePassword) {
        Credentials cred = null;
        if (keystoreFile == null || keystoreFile.trim().length() == 0 || !new File(keystoreFile).exists()) {
            throw new PDFException.KeyStoreNotFoundException(keystoreFile);
        }
        if (keyPassword == null) {
            keyPassword = keystorePassword;
        }
        KeyStore keystore = this.getKeyStore(keystoreFile, keystorePassword);
        try {
            Certificate[] chain;
            if (keyalias == null || keyalias.trim().length() == 0) {
                keyalias = this.getKeyAlias(keystore);
            }
            if ((chain = keystore.getCertificateChain(keyalias)) == null || chain.length == 0) {
                throw new PDFException.KeyNotFoundException(keyalias);
            }
            PrivateKey privateKey = (PrivateKey)keystore.getKey(keyalias, keyPassword.toCharArray());
            X509Certificate cert = (X509Certificate)keystore.getCertificate(keyalias);
            PrivateKeyHolder createPrivateKey = PrivateKeyHolderFactory.newInstance().createPrivateKey(privateKey, "BC");
            cred = CredentialFactory.newInstance().createCredentials(createPrivateKey, cert, chain);
        }
        catch (UnrecoverableKeyException e) {
            throw new PDFException.UnrecoverablePrivateKeyException((Throwable)e);
        }
        catch (ApplicationException a) {
            throw a;
        }
        catch (Exception e) {
            throw new PDFException.UnabletoSignPDFUsingGivenKeyStoreException(keystoreFile);
        }
        return cred;
    }

    public PDFDocument createPortfolio(List pdfs, String destination) throws PDFException, IOException {
        PDFDocument collection = this.createNewDocument();
        HashSet keySet = new HashSet();
        int count = 0;
        for (Object pdf : pdfs) {
            PDFDocWrapper wrap = (PDFDocWrapper)pdf;
            if (wrap.getFilePath() != null) {
                this.setupFile(collection, (PDFDocWrapper)pdf, keySet, ++count);
                continue;
            }
            this.setupPDFFile(collection, (PDFDocWrapper)pdf, keySet, ++count);
        }
        PDFPortableCollection collectionDict = PDFPortableCollection.newInstance((PDFDocument)collection);
        if (destination == null) {
            destination = "collection";
        }
        collectionDict.setInitialDocumentName(new ASString(destination));
        collection.requireCatalog().setCollection(collectionDict);
        collectionDict.setSchema(this.setupSchema(collection, keySet));
        collectionDict.setSort(this.setupSort(collection, keySet));
        return collection;
    }

    private PDFDocument createNewDocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument collection = PDFDocument.newInstance((PDFOpenOptions)PDFOpenOptions.newInstance());
        PDFRectangle mediaBox = PDFRectangle.newInstance((PDFDocument)collection, (double)0.0, (double)0.0, (double)612.0, (double)792.0);
        PDFPage emptyPage = PDFPage.newInstance((PDFDocument)collection, (PDFRectangle)mediaBox);
        PDFPageTree.newInstance((PDFDocument)collection, (PDFPage)emptyPage);
        return collection;
    }

    private PDFCollectionSort setupSort(PDFDocument collection, Set keys) throws PDFException {
        PDFCollectionSort sort = PDFCollectionSort.newInstance((PDFDocument)collection, (ASName[])new ASName[]{indexKey});
        sort.setNames(new ASName[]{indexKey});
        return sort;
    }

    private PDFCollectionSchema setupSchema(PDFDocument collection, Set keys) throws PDFException {
        PDFCollectionSchema schema = PDFCollectionSchema.newInstance((PDFDocument)collection);
        PDFCollectionField field = PDFCollectionField.newInstance((PDFDocument)collection, (PDFCollectionFieldType)PDFCollectionFieldType.file, (String)this.PAGE_END_CHECK);
        field.setName(strIndexKey);
        field.setOrder(0);
        field.setVisibility(false);
        field.setFieldType(PDFCollectionFieldType.number);
        schema.set(indexKey, field);
        Iterator itr = keys.iterator();
        int i = 1;
        while (itr.hasNext()) {
            String keyStr = (String)itr.next();
            field = PDFCollectionField.newInstance((PDFDocument)collection, (PDFCollectionFieldType)PDFCollectionFieldType.file, (String)keyStr);
            field.setName(keyStr);
            field.setOrder(i);
            field.setFieldType(PDFCollectionFieldType.text);
            schema.set(ASName.create((String)keyStr), field);
            ++i;
        }
        return schema;
    }

    private void setupPDFFile(PDFDocument collection, PDFDocWrapper wrap, Set keys, int count) throws PDFException, IOException {
        byte[] attByte = this.writeDocument(wrap.getDoc(), null);
        ByteBufferByteReader attByteReader = new ByteBufferByteReader(attByte);
        ASDate modDate = new ASDate();
        PDFEmbeddedFile embeddedFile = PDFEmbeddedFile.newInstance((PDFDocument)collection, (PDFEmbeddedFileInfo)PDFEmbeddedFileInfo.newInstance((PDFDocument)collection, (int)attByte.length, (ASDate)modDate, (ASDate)modDate), (ByteReader)attByteReader);
        PDFFileSpecification fileSpec = PDFFileSpecification.newInstance((PDFDocument)collection, (byte[])wrap.getCalledSource().getBytes(), (PDFEmbeddedFile)embeddedFile);
        PDFCollectionItem colItem = PDFCollectionItem.newInstance((PDFDocument)collection);
        Map args = wrap.getArgsPortfolio();
        PDFCollectionItemData data = PDFCollectionItemData.newInstance((PDFDocument)collection, (Number)count, (ASName)indexKey);
        colItem.setData(indexKey, data);
        if (args != null) {
            for (Object o : args.keySet()) {
                String key = (String)o;
                keys.add(key);
                ASName itemKey = ASName.create((String)key);
                String value = (String)args.get(key);
                data = PDFCollectionItemData.newInstance((PDFDocument)collection, (String)value, (ASName)itemKey);
                colItem.setData(itemKey, data);
            }
        }
        fileSpec.setCollectionItem(colItem);
        PDFNameDictionary nameDictionary = collection.requireCatalog().procureNameDictionary();
        PDFNamedEmbeddedFiles namedFiles = nameDictionary.procureNamedEmbeddedFiles();
        namedFiles.addEntry((Object)new ASString(wrap.getCalledSource()), (Object)fileSpec);
    }

    private void setupFile(PDFDocument collection, PDFDocWrapper wrap, Set keys, int count) throws PDFException, IOException {
        File attFile = new File(wrap.getFilePath());
        LazyRandomAccessFileByteReader attByteReader = new LazyRandomAccessFileByteReader(attFile);
        ASDate modDate = new ASDate(new Date(attFile.lastModified()));
        PDFEmbeddedFile embeddedFile = PDFEmbeddedFile.newInstance((PDFDocument)collection, (PDFEmbeddedFileInfo)PDFEmbeddedFileInfo.newInstance((PDFDocument)collection, (int)((int)attByteReader.length()), (ASDate)new ASDate(), (ASDate)modDate), (ByteReader)attByteReader);
        PDFFileSpecification fileSpec = PDFFileSpecification.newInstance((PDFDocument)collection, (byte[])attFile.getAbsolutePath().getBytes(), (PDFEmbeddedFile)embeddedFile);
        PDFCollectionItem colItem = PDFCollectionItem.newInstance((PDFDocument)collection);
        Map args = wrap.getArgsPortfolio();
        PDFCollectionItemData data = PDFCollectionItemData.newInstance((PDFDocument)collection, (Number)count, (ASName)indexKey);
        colItem.setData(indexKey, data);
        if (args != null) {
            for (Object o : args.keySet()) {
                String key = (String)o;
                keys.add(key);
                ASName itemKey = ASName.create((String)key);
                String value = (String)args.get(key);
                data = PDFCollectionItemData.newInstance((PDFDocument)collection, (String)value, (ASName)itemKey);
                colItem.setData(itemKey, data);
            }
        }
        fileSpec.setCollectionItem(colItem);
        PDFNameDictionary nameDictionary = collection.requireCatalog().procureNameDictionary();
        PDFNamedEmbeddedFiles namedFiles = nameDictionary.procureNamedEmbeddedFiles();
        namedFiles.addEntry((Object)new ASString(attFile.getAbsolutePath()), (Object)fileSpec);
    }

    public QueryTable readSignatureFields(PDFDocument pdfdoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        QueryTable res = new QueryTable(0, PDFDocUtil.SignatureColumnsNames, PDFDocUtil.SignatureColumnTypes);
        SignatureManager sigmgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
        SignatureFieldInterface sfi = sigmgr.getCertifiedSignatureField();
        String sfiname = WORDNS;
        if (sfi != null) {
            sfiname = sfi.getQualifiedName();
        }
        if (sigmgr.hasSignatureFields()) {
            Iterator iter = sigmgr.getDocSignatureFieldIterator();
            while (iter.hasNext()) {
                SignatureFieldInterface sigfield = (SignatureFieldInterface)iter.next();
                QueryFunction.QueryAddRow((Object)res);
                QueryFunction.QuerySetCell((Object)res, (String)"FIELDNAME", (Object)sigfield.getQualifiedName());
                if (sigfield.isSigned()) {
                    if (sigfield.getQualifiedName().equals(sfiname)) {
                        QueryFunction.QuerySetCell((Object)res, (String)"AUTHORED", (Object)"YES");
                        QueryFunction.QuerySetCell((Object)res, (String)"SIGNED", (Object)"NO");
                    } else {
                        QueryFunction.QuerySetCell((Object)res, (String)"SIGNED", (Object)"YES");
                        QueryFunction.QuerySetCell((Object)res, (String)"AUTHORED", (Object)"NO");
                    }
                } else {
                    QueryFunction.QuerySetCell((Object)res, (String)"SIGNED", (Object)"NO");
                    QueryFunction.QuerySetCell((Object)res, (String)"AUTHORED", (Object)"NO");
                }
                if (sigfield.isSigningPermitted()) {
                    QueryFunction.QuerySetCell((Object)res, (String)"CAN_BE_SIGNED", (Object)"YES");
                } else {
                    QueryFunction.QuerySetCell((Object)res, (String)"CAN_BE_SIGNED", (Object)"NO");
                }
                if (sigfield.isCertifyingPermitted()) {
                    QueryFunction.QuerySetCell((Object)res, (String)"CAN_BE_AUTHORED", (Object)"YES");
                } else {
                    QueryFunction.QuerySetCell((Object)res, (String)"CAN_BE_AUTHORED", (Object)"NO");
                }
                if (sigfield.isVisible()) {
                    QueryFunction.QuerySetCell((Object)res, (String)"VISIBLE", (Object)"YES");
                    continue;
                }
                QueryFunction.QuerySetCell((Object)res, (String)"VISIBLE", (Object)"NO");
            }
        }
        return res;
    }

    public void checkAndCreateXFADomService(PDFDocument pdfdoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDocument.PDFDocumentType type = XFAService.getDocumentType((PDFDocument)pdfdoc);
        try {
            if (type.isXFA()) {
                XFADOMService.getXFADOM((PDFDocument)pdfdoc, (XFAProcessingOptions)new XFAProcessingOptions(true, true));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SignatureFieldInterface getSignatureField(PDFDocument pdfdoc, String field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureFieldInterface sigfield;
        Iterator iter;
        SignatureManager sigmgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
        SignatureFieldInterface sfi = null;
        if (sigmgr.hasSignatureFields()) {
            iter = sigmgr.getDocSignatureFieldIterator();
            while (iter.hasNext()) {
                sigfield = (SignatureFieldInterface)iter.next();
                if (!sigfield.getQualifiedName().equals(field)) continue;
                sfi = sigfield;
                break;
            }
        }
        if (sfi != null) {
            return sfi;
        }
        if (sigmgr.hasSignatureFields()) {
            iter = sigmgr.getDocSignatureFieldIterator();
            while (iter.hasNext()) {
                sigfield = (SignatureFieldInterface)iter.next();
                if (!sigfield.getQualifiedName().equalsIgnoreCase(field)) continue;
                sfi = sigfield;
                break;
            }
        }
        if (sfi == null) {
            throw new PDFException.SignatureFieldNotFoundException(field, (Object)pdfdoc);
        }
        return sfi;
    }

    public SignatureFieldInterface getSignatureField(String pageNos, int[] position, double width, double height, PDFDocument pdfdoc, String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int pageno;
        SignatureFieldInterface sfi = null;
        if (pageNos == null) {
            pageno = 0;
        } else {
            pageno = this.getFirstPage(pageNos, pdfdoc);
            --pageno;
        }
        double[] coords = new double[]{0.0, 0.0, 0.0, 0.0};
        if (position != null) {
            try {
                coords = this.getCoordinateArray(position, width, height);
            }
            catch (Exception e) {
                String input = position[0] + " " + position[1] + " " + width + " " + height;
                throw new PDFException.InvalidCoordinateException(input, (Object)pdfdoc);
            }
        }
        PDFPage page = pdfdoc.requireCatalog().getPages().getPage(pageno);
        PDFRectangle annotRect = PDFRectangle.newInstance((PDFDocument)pdfdoc, (ASRectangle)new ASRectangle(coords));
        PDFInteractiveForm iform = pdfdoc.requireCatalog().procureInteractiveForm();
        sfi = fieldName == null ? SignatureFieldFactory.createSignatureField((PDFPage)page, (PDFRectangle)annotRect, (PDFFieldNode)iform) : SignatureFieldFactory.createSignatureField((PDFPage)page, (PDFRectangle)annotRect, (String)fieldName);
        return sfi;
    }

    public void unsignSignature(PDFDocument pdfdoc, String field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureManager sigmgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
        SignatureFieldInterface sfi = this.getSignatureField(pdfdoc, field);
        if (!sfi.isSigned()) {
            throw new PDFException.SignatureFieldNotSignedException((Object)pdfdoc);
        }
        sigmgr.unsignSignatureField(sfi);
    }

    public void unsignAllSignatures(PDFDocument pdfdoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureManager sigmgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
        if (!sigmgr.hasSignedSignatureFields()) {
            throw new PDFException.NoSignaturesInPDFException((Object)pdfdoc);
        }
        sigmgr.unsignAllPDFSignatureFields();
    }

    public void validateSignatures(PDFDocument pdfdoc, Struct result) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFSignatureException {
        CaseInsensitiveMap res = new CaseInsensitiveMap();
        res.put("SUCCESS", true);
        ArrayList<String> invalidSignatures = new ArrayList<String>();
        SignatureManager sigMgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
        if (!sigMgr.hasSignedSignatureFields()) {
            throw new PDFException.NoSignaturesInPDFException((Object)pdfdoc);
        }
        Iterator iter = sigMgr.getDocSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigfield = (SignatureFieldInterface)iter.next();
            if (!sigfield.isSigned()) continue;
            CryptoContext cryptoContext = new CryptoContext(CryptoMode.NON_FIPS_MODE, null, null);
            CertJNonFIPSProvider defaultCryptoProvider = new CertJNonFIPSProvider(cryptoContext);
            SignatureOptions options = SignatureOptions.newInstance();
            options.enableA9Validation();
            boolean valid = SignatureManager.validate((SignatureFieldInterface)sigfield, (SignatureOptions)options, (SignatureServiceProvider)defaultCryptoProvider).isValid();
            if (valid) continue;
            invalidSignatures.add(sigfield.getQualifiedName());
        }
        if (invalidSignatures.size() > 0) {
            res.put("SUCCESS", false);
        }
        res.put("INVALIDSIGNATURES", invalidSignatures);
        result.putAll((Map)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signAndWriteDocument(String outputPDFFileName, PDFDocument pdfDocument, Credentials credentials, SignatureFieldInterface signaturefield, boolean author, boolean flatten) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IOException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        File resultFile;
        File outputFile = VFSFileFactory.getFileObject((String)outputPDFFileName);
        File parentDir = outputFile.getParentFile();
        if (parentDir == null || !parentDir.exists() || parentDir.isFile()) {
            pdfDocument.close();
            throw new PDFException.PDFNoDirectoryException(outputPDFFileName);
        }
        if (DirFileUtils.isReadOnly((File)outputFile)) {
            pdfDocument.close();
            throw new PDFException.DirFileIsReadOnlyException(outputFile.getAbsolutePath(), "delete", "source");
        }
        RandomAccessFileByteWriter outputPDF = null;
        boolean tempfileDeleteFlag = false;
        File tempoutputFile = null;
        try {
            tempoutputFile = File.createTempFile("cfm", ".tmp", parentDir);
            if (DirFileUtils.isReadOnly((File)tempoutputFile)) {
                pdfDocument.close();
                throw new PDFException.DirFileIsReadOnlyException(outputFile.getAbsolutePath(), "delete", "source");
            }
            RandomAccessFile outputPDFFile = new RandomAccessFile(tempoutputFile, "rw");
            outputPDF = new RandomAccessFileByteWriter(outputPDFFile);
            SignatureManager sigmgr = SignatureManager.newInstance((PDFDocument)pdfDocument);
            if (author) {
                if (sigmgr.getCertificationSignature() != null) {
                    throw new PDFException.DocumentAlreadyCertifiedException((Object)pdfDocument);
                }
                if (sigmgr.hasSignedSignatureFields()) {
                    throw new PDFException.SignaturesAlreadyExistException((Object)pdfDocument);
                }
                try {
                    sigmgr.certify(signaturefield, credentials, (ByteWriter)outputPDF);
                    tempfileDeleteFlag = true;
                }
                catch (Exception e) {
                    throw new PDFException.UnableToCertifyDocumentException((Object)pdfDocument);
                }
            } else {
                sigmgr.sign(signaturefield, credentials, (ByteWriter)outputPDF);
                tempfileDeleteFlag = true;
            }
            if (flatten) {
                sigmgr.flattenSignatureField(signaturefield);
            }
            resultFile = tempoutputFile;
        }
        finally {
            if (outputPDF != null) {
                outputPDF.close();
            }
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            if (!tempfileDeleteFlag) {
                try {
                    tempoutputFile.delete();
                }
                catch (Exception exception) {}
            }
        }
        if (outputFile.exists() && !outputFile.delete()) {
            resultFile.delete();
            throw new PDFException.CouldNotDeleteFileException(outputPDFFileName);
        }
        if (!resultFile.renameTo(outputFile)) {
            resultFile.delete();
            throw new PDFException.CouldNotDeleteFileException(outputPDFFileName);
        }
    }

    public void writeDocument(String outputPDFFileName, PDFDocument pdfDocument, PDFSaveOptions saveOption) throws IOException, PDFException {
        this.writeDocument(outputPDFFileName, pdfDocument, saveOption, false);
    }

    public void writeDocument(String outputPDFFileName, PDFDocument pdfDocument, PDFSaveOptions saveOption, boolean encodeAll) throws IOException, PDFException {
        File outputFile = VFSFileFactory.getFileObject((String)outputPDFFileName);
        File parentDir = outputFile.getParentFile();
        if (parentDir == null || !parentDir.exists() || parentDir.isFile()) {
            pdfDocument.close();
            throw new PDFException.PDFNoDirectoryException(outputPDFFileName);
        }
        if (DirFileUtils.isReadOnly((File)outputFile)) {
            pdfDocument.close();
            throw new PDFException.DirFileIsReadOnlyException(outputFile.getAbsolutePath(), "delete", "source");
        }
        File resultFile = this.writeDocument(parentDir, pdfDocument, saveOption, encodeAll);
        if (outputFile.exists() && !outputFile.delete()) {
            resultFile.delete();
            throw new PDFException.CouldNotDeleteFileException(outputPDFFileName);
        }
        if (!resultFile.renameTo(outputFile)) {
            try {
                FileUtils.copyFile((File)resultFile, (String)outputFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new PDFException.CouldNotDeleteFileException(outputPDFFileName);
            }
            finally {
                resultFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeDocument(File directory, PDFDocument pdfDocument, PDFSaveOptions saveOption, boolean encodeAll) throws IOException, PDFException {
        RandomAccessFileByteWriter outputPDF = null;
        try {
            File outputFile = File.createTempFile("cfm", ".tmp", directory);
            if (DirFileUtils.isReadOnly((File)outputFile)) {
                pdfDocument.close();
                throw new PDFException.DirFileIsReadOnlyException(outputFile.getAbsolutePath(), "delete", "source");
            }
            RandomAccessFile outputPDFFile = new RandomAccessFile(outputFile, "rw");
            outputPDF = new RandomAccessFileByteWriter(outputPDFFile);
            if (saveOption == null) {
                saveOption = PDFSaveFullOptions.newInstance();
                saveOption.setForceCompress(encodeAll);
                pdfDocument.save((ByteWriter)outputPDF, saveOption);
            } else {
                saveOption.setForceCompress(encodeAll);
                pdfDocument.save((ByteWriter)outputPDF, saveOption);
            }
            File file = outputFile;
            return file;
        }
        finally {
            if (outputPDF != null) {
                outputPDF.close();
            }
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public byte[] writeDocument(PDFDocument pdfDocument, PDFSaveOptions saveOption) throws IOException, PDFException {
        ByteArrayByteWriter outputPDF = null;
        try {
            outputPDF = new ByteArrayByteWriter();
            SignatureManager sigMgr = SignatureManager.newInstance((PDFDocument)pdfDocument);
            if (sigMgr != null && (sigMgr.hasUsageRights() || sigMgr.hasSignedSignatureFields())) {
                saveOption = PDFSaveIncrementalOptions.newInstance();
            }
            if (saveOption == null) {
                saveOption = PDFSaveFullOptions.newInstance();
            }
            pdfDocument.save((ByteWriter)outputPDF, saveOption);
            byte[] byArray = outputPDF.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new PDFDocException((Throwable)e, (Object)pdfDocument);
        }
        finally {
            if (outputPDF != null) {
                outputPDF.close();
            }
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public void getJavascriptEventForFormField(PDFDocument doc) throws Exception {
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance((PDFDocument)doc);
        if (jsHandler == null) {
            ProtectionDomain domains = this.createProtectionDomain();
            ChainedInputStream chain = this.getAcroScripts();
            if (chain == null) {
                return;
            }
            jsHandler = JavaScriptHandler.getInstance((PDFDocument)doc, (InputStream)chain, (ProtectionDomain)domains, (PermissionsManager)PermissionsManager.newInstance((PDFDocument)doc), (boolean)true);
        }
        this.removeNoCache(doc);
        try {
            jsHandler.executeDocumentScript();
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        this.executeCalculateEvents(doc, jsHandler);
    }

    private void removeNoCache(PDFDocument pdfDocument) {
        try {
            PDFNameDictionary pdfNameDictionary = pdfDocument.requireCatalog().getNameDictionary();
            PDFNamedJavaScripts js1 = pdfNameDictionary.getNamedJavaScripts();
            js1.removeEntry((Object)new ASString("nocache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ChainedInputStream getAcroScripts() {
        URL resource1 = Thread.currentThread().getContextClassLoader().getResource("coldfusion/pdf/scripts/AForm.js");
        URL resource2 = Thread.currentThread().getContextClassLoader().getResource("coldfusion/pdf/scripts/Annots.js");
        ChainedInputStream chain = null;
        try {
            InputStream[] streamArray = null;
            if (resource1 != null && resource2 != null) {
                streamArray = new InputStream[]{resource1.openStream(), resource2.openStream()};
                chain = new ChainedInputStream(streamArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return chain;
    }

    private void executeCalculateEvents(PDFDocument doc, JavaScriptHandler jsHandler) throws Exception {
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        if (acroForm == null) {
            return;
        }
        Iterator fieldIterator = acroForm.iterator(true);
        while (fieldIterator.hasNext()) {
            PDFField pdfField = (PDFField)fieldIterator.next();
            PDFAdditionalActionsField aas = (PDFAdditionalActionsField)pdfField.getAdditionalActions();
            if (aas != null) {
                Set aasMap = aas.keySet();
                for (Object anAasMap : aasMap) {
                    ASName actName = (ASName)anAasMap;
                    PDFAction additionalAction = aas.getAction(actName);
                    PDFJavaScriptEvent event = new PDFJavaScriptEvent(pdfField, (PDFActionJavaScript)additionalAction, actName.asString());
                    if (!event.getEventName().equalsIgnoreCase("calculate") && !event.getEventName().equalsIgnoreCase("format")) continue;
                    jsHandler.execute(event);
                }
                continue;
            }
            PDFAnnotationIterator annotIter = pdfField.getAnnotationsIterator();
            while (annotIter != null && annotIter.hasNext()) {
                PDFAnnotation annot = annotIter.next();
                aas = (PDFAdditionalActionsField)annot.getAdditionalActions();
                if (aas == null) continue;
                Set aasMap = aas.keySet();
                for (Object anAasMap : aasMap) {
                    ASName actName = (ASName)anAasMap;
                    PDFAction additionalAction = aas.getAction(actName);
                    PDFJavaScriptEvent event = new PDFJavaScriptEvent(pdfField, (PDFActionJavaScript)additionalAction, actName.asString());
                    if (!event.getEventName().equalsIgnoreCase("calculate") && !event.getEventName().equalsIgnoreCase("format")) continue;
                    jsHandler.execute(event);
                }
            }
        }
        this.setFormattedValues(doc, jsHandler);
    }

    private void setFormattedValues(PDFDocument doc, JavaScriptHandler jsHandler) throws PDFException {
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        if (acroForm == null) {
            return;
        }
        if (jsHandler.getFormattedFieldValueMap() != null) {
            doc.getInteractiveForm().setNeedAppearances(false);
            HashMap<PDFFieldNode, List> oldValueMap = new HashMap<PDFFieldNode, List>();
            HashMap map = jsHandler.getFormattedFieldValueMap();
            for (Object o : map.keySet()) {
                String fieldName = (String)o;
                PDFFieldNode field = jsHandler.getField(fieldName).getNode();
                Object value = map.get(fieldName);
                List val = field.getValueList();
                Object oldVal = null;
                if (val != null) {
                    oldVal = val.size() > 1 ? val : val.get(0).toString();
                }
                oldValueMap.put(field, (List)oldVal);
                field.setStringValue(value.toString());
            }
            APResources apResources = new APResources(doc.getCosDocument().getOptions().getFontSet(), doc.getCosDocument().getOptions().getDocLocale(), null);
            APContext apContext = new APContext(apResources, true, null);
            TextFormatterImpl textFormatter = new TextFormatterImpl(doc);
            AppearanceService.generateAppearances((PDFDocument)doc, (APContext)apContext, (TextFormatter)textFormatter);
            this.setOldValuesBackOnField(doc, oldValueMap);
        }
    }

    private void setOldValuesBackOnField(PDFDocument doc, HashMap map) throws PDFException {
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        if (acroForm == null) {
            return;
        }
        for (Object field : map.keySet()) {
            Object value = map.get(field);
            ((PDFFieldNode)field).setStringValue(value.toString());
        }
    }

    private ProtectionDomain createProtectionDomain() throws MalformedURLException {
        String requestURL = FusionContext.getCurrent().getRequest().getRequestURL().toString();
        CodeSource cs = new CodeSource(new URL(requestURL), (Certificate[])null);
        PermissionCollection pc = Policy.getPolicy().getPermissions(cs);
        return new ProtectionDomain(cs, pc);
    }

    public PDFDocument deletePagesInternal(PDFDocument pdfDocument, String page) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int totalPagenumber = tempPages.getNumPages();
        int[] pages = new int[tempPages.getNumPages()];
        int pagecount = this.getPages(page, pages);
        PDFPage[] curPdfPage = new PDFPage[pagecount];
        int pageDelCount = 0;
        for (int i = 0; i < pagecount; ++i) {
            if (pages[i] == 0) continue;
            if (pages[i] > totalPagenumber) {
                throw new PDFException.PDFDeleteInvalidPageException("DELETEPAGES", page, (Object)pdfDocument);
            }
            curPdfPage[pageDelCount++] = tempPages.getPage(pages[i] - 1);
        }
        if (pageDelCount >= totalPagenumber) {
            throw new PDFException.PDFDeleteInvalidPageException("DELETEPAGES", page, (Object)pdfDocument);
        }
        PMMService pmmService = new PMMService(pdfDocument);
        for (int j = 0; j < pageDelCount; ++j) {
            pmmService.deletePages(curPdfPage[j], 1);
        }
        return pdfDocument;
    }

    public PDFPage[] getPagesInternal(PDFDocument pdfDocument, String page, String action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int totalPagenumber = tempPages.getNumPages();
        int[] pages = new int[tempPages.getNumPages()];
        int pagecount = this.getPages(page, pages);
        PDFPage[] curPdfPage = new PDFPage[pagecount];
        int pageDelCount = 0;
        for (int i = 0; i < pagecount; ++i) {
            if (pages[i] == 0) continue;
            if (pages[i] > totalPagenumber) {
                throw new PDFException.PDFInvalidPageNumberException(action, page, (Object)pdfDocument);
            }
            curPdfPage[pageDelCount++] = tempPages.getPage(pages[i] - 1);
        }
        if (pageDelCount > totalPagenumber) {
            throw new PDFException.PDFInvalidPageNumberException(action, page, (Object)pdfDocument);
        }
        PDFPage[] result = new PDFPage[pageDelCount];
        for (int j = 0; j < pageDelCount; ++j) {
            result[j] = curPdfPage[j];
        }
        return result;
    }

    public PDFPage[] getPagesInternal(PDFDocument pdfDocument, String page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int totalPagenumber = tempPages.getNumPages();
        int[] pages = new int[tempPages.getNumPages()];
        int pagecount = this.getPages(page, pages);
        PDFPage[] curPdfPage = new PDFPage[pagecount];
        int pageDelCount = 0;
        for (int i = 0; i < pagecount; ++i) {
            if (pages[i] == 0) continue;
            if (pages[i] > totalPagenumber) {
                throw new PDFException.PDFDeleteInvalidPageException("MERGE", page, (Object)pdfDocument);
            }
            curPdfPage[pageDelCount++] = tempPages.getPage(pages[i] - 1);
        }
        if (pageDelCount > totalPagenumber) {
            throw new PDFException.PDFDeleteInvalidPageException("MERGE", page, (Object)pdfDocument);
        }
        PDFPage[] result = new PDFPage[pageDelCount];
        for (int j = 0; j < pageDelCount; ++j) {
            result[j] = curPdfPage[j];
        }
        return result;
    }

    public double[] getCoordinateArray(int[] position, double width, double height) {
        if (width < 0.0 || height < 0.0) {
            throw new PDFException.InvalidCoordinatesException("Invalid width or height attribute");
        }
        double[] result = new double[4];
        try {
            result[0] = position[0];
            result[1] = position[1];
            result[2] = (double)position[0] + width;
            result[3] = (double)position[1] + height;
        }
        catch (Exception e) {
            throw new PDFException.InvalidCoordinatesException(position + " " + width + " " + height);
        }
        return result;
    }

    public int getFirstPage(String pageAttr, PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int[] pages = new int[tempPages.getNumPages()];
        int x = this.getPages(pageAttr, pages);
        if (x > 1) {
            throw new PDFException.InvalidPageValueException();
        }
        if (pages[0] > tempPages.getNumPages()) {
            throw new PDFException.PageNumberOutOfRangeException(pages[0], (Object)pdfDocument);
        }
        return pages[0];
    }

    private int getPages(String pageAttr, int[] pages) throws PDFException.PDFInvalidPageException {
        String page = pageAttr;
        if (page == null || page.equals(this.PAGE_END_CHECK)) {
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = i + 1;
            }
            return pages.length;
        }
        if (page.endsWith(this.PAGE_END_CHECK)) {
            page = page.replaceAll(this.PAGE_END_REPLACE, WORDNS + pages.length);
        }
        try {
            PageRanges pageRanges = new PageRanges(page);
            int[][] ranges = pageRanges.getMembers();
            int size = 0;
            for (int[] range : ranges) {
                int min = range[0];
                int max = range[1];
                int j = min;
                while (j <= max && size != pages.length) {
                    pages[size++] = j++;
                }
            }
            return size;
        }
        catch (Exception e) {
            throw new PDFException.PDFInvalidPageException("pages", pageAttr);
        }
    }

    public void addWatermark(PDFDocument pdfDocument, String page, String richText, boolean foreground, int opacity, int[] position, int rotation, boolean showOnPrint, double height, double width) throws PDFFontException, PDFInvalidParameterException, PDFConfigurationException, PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, foreground);
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        applyOptions.setRotation((double)rotation);
        PDFXObjectForm xobject = this.getXObjectToWatermark(richText, pdfDocument, useOptions, height, width);
        if (page == null) {
            for (PDFPage sourcePage : tempPages) {
                this.applyWatermark(position, sourcePage, xobject, applyOptions, useOptions, null);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("ADDWATERMARK", page, (Object)pdfDocument);
                }
                PDFPage sourcePage = tempPages.getPage(pages[i] - 1);
                this.applyWatermark(position, sourcePage, xobject, applyOptions, useOptions, null);
            }
        }
    }

    private PDFXObjectForm getXObjectToWatermark(String richText, PDFDocument pdfDocument, XObjectUseOptions useOptions, double height, double width) throws PDFInvalidDocumentException, PDFIOException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        double wid;
        PDFFontSet pdfFontSet = (PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet();
        PDFRectangle cropbox = pdfDocument.requirePages().getPage(0).getCropBox();
        double len = width;
        if (len == -1.0) {
            double d = len = cropbox != null ? cropbox.getValues()[2] - cropbox.getValues()[0] : 300.0;
        }
        if ((wid = height) == -1.0) {
            wid = cropbox != null ? cropbox.getValues()[3] - cropbox.getValues()[1] : 150.0;
        }
        RCGOptions rcgOptions = new RCGOptions(len, wid);
        String defaultStyle = "font: 'Courier' 10pt";
        rcgOptions.setDefaultStyle(defaultStyle);
        rcgOptions.setOverflow(RCGOverflowMode.ShrinkToFit);
        rcgOptions.setVerticalAlignment(RCGAlignment.Middle);
        rcgOptions.setWrap(RCGWrapOption.Emergency);
        richText = new StringBuffer("<body><p>").append(richText).append("</p></body>").toString();
        ByteArrayInputStream richTextStream = new ByteArrayInputStream(richText.getBytes());
        PDFXObjectForm xobject = RichTextContentGenerator.generateXObject((PDFDocument)pdfDocument, (InputStream)richTextStream, (PDFFontSet)pdfFontSet, (RCGOptions)rcgOptions, (XObjectUseOptions)useOptions);
        return xobject;
    }

    public void downsampleImage(PDFDocument pdfDocument, String password, String algo, double vScale, double hScale, String page) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        if (page == null) {
            for (PDFPage pdfPage : tempPages) {
                this.downsampleImage(pdfPage, pdfDocument, algo, hScale, vScale);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("OPTIMIZE", page, (Object)pdfDocument);
                }
                PDFPage pdfPage = tempPages.getPage(pages[i] - 1);
                this.downsampleImage(pdfPage, pdfDocument, algo, hScale, vScale);
            }
        }
    }

    private void downsampleImage(PDFPage pdfPage, PDFDocument pdfDocument, String algo, double hScale, double vScale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFXObjectMap xobjMap;
        PDFResources pdfResources = pdfPage.getResources();
        int iAlgo = -1;
        if (algo.equalsIgnoreCase("BICUBIC")) {
            iAlgo = 2;
        } else if (algo.equalsIgnoreCase("BILINEAR")) {
            iAlgo = 3;
        } else if (algo.equalsIgnoreCase("NEAREST_NEIGHBOUR")) {
            iAlgo = 1;
        }
        if (pdfResources != null && (xobjMap = pdfResources.getXObjectMap()) != null) {
            for (Object o : xobjMap.keySet()) {
                ASName key = (ASName)o;
                PDFXObject xobj = xobjMap.get(key);
                CosStream sourceObj = xobj.getCosStream();
                boolean flag = false;
                CosObject cosObject = sourceObj.get(ASName.k_Filter);
                if (cosObject != null && ((String)cosObject.getValue()).equalsIgnoreCase("JPXDecode")) {
                    flag = true;
                }
                if (!(xobj instanceof PDFXObjectImage) || flag) continue;
                PDFXObjectImage resampledImage = ImageManager.resampleXObjImage((PDFDocument)pdfDocument, (PDFXObjectImage)((PDFXObjectImage)xobj), (double)hScale, (double)vScale, (int)iAlgo);
                xobjMap.set(key, (PDFXObject)resampledImage);
            }
        }
    }

    public void noThumbnails(PDFDocument pdfDocument, String page) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        if (page == null) {
            for (PDFPage pdfPage : tempPages) {
                pdfPage.removeThumbnail();
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("OPTIMIZE", page, (Object)pdfDocument);
                }
                PDFPage pdfPage = tempPages.getPage(pages[i] - 1);
                pdfPage.removeThumbnail();
            }
        }
    }

    public void noBookmarks(PDFDocument pdfDocument, String page) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        PMMService pmmService = new PMMService(pdfDocument);
        if (page == null) {
            Object[] obj = tempPages.toArray();
            PDFPage[] pdfPages = new PDFPage[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                pdfPages[i] = (PDFPage)obj[i];
            }
            pmmService.deleteBookmarks(pdfPages);
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            PDFPage[] pdfPages = new PDFPage[pagecount];
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("OPTIMIZE", page, (Object)pdfDocument);
                }
                pdfPages[i] = tempPages.getPage(pages[i] - 1);
            }
            pmmService.deleteBookmarks(pdfPages);
        }
    }

    public void removeJavaScriptsFromField(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        if (acroForm == null) {
            return;
        }
        Iterator fieldIterator = acroForm.iterator();
        PDFField pdfField = null;
        while (fieldIterator.hasNext()) {
            pdfField = (PDFField)fieldIterator.next();
            PDFAdditionalActionsField aas = (PDFAdditionalActionsField)pdfField.getAdditionalActions();
            if (aas != null) {
                Set aasMap = aas.keySet();
                for (Object anAasMap : aasMap) {
                    ASName actName = (ASName)anAasMap;
                    PDFAction additionalAction = aas.getAction(actName);
                    PDFJavaScriptEvent event = new PDFJavaScriptEvent(pdfField, (PDFActionJavaScript)additionalAction, actName.asString());
                    event.getPdfJSAction().removeJavaScript();
                }
                continue;
            }
            PDFAnnotationIterator annotIter = pdfField.getAnnotationsIterator();
            while (annotIter != null && annotIter.hasNext()) {
                PDFAction action;
                PDFAnnotation annot = annotIter.next();
                aas = (PDFAdditionalActionsField)annot.getAdditionalActions();
                if (aas != null) {
                    Set aasMap = aas.keySet();
                    for (Object anAasMap : aasMap) {
                        ASName actName = (ASName)anAasMap;
                        PDFAction additionalAction = aas.getAction(actName);
                        PDFJavaScriptEvent event = new PDFJavaScriptEvent(pdfField, (PDFActionJavaScript)additionalAction, actName.asString());
                        event.getPdfJSAction().removeJavaScript();
                    }
                }
                if ((action = annot.getAction()) == null || !(action instanceof PDFActionJavaScript)) continue;
                ((PDFActionJavaScript)action).removeJavaScript();
            }
        }
    }

    public void noComments(PDFDocument pdfDocument, String page) throws PDFException {
        if (page == null) {
            PDFAnnotationIterator annotItr = pdfDocument.requireCatalog().getPages().getAnnotationsIterator();
            while (annotItr.hasNext()) {
                PDFAnnotation pdfAnnotation = annotItr.next();
                if (pdfAnnotation instanceof PDFAnnotationWidget || pdfAnnotation instanceof PDFAnnotationLink) continue;
                annotItr.remove();
            }
        } else {
            PDFPageTree tempPages = pdfDocument.requirePages();
            int totalPagenumber = tempPages.getNumPages();
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("OPTIMIZE", page, (Object)pdfDocument);
                }
                PDFPage pdfPage = tempPages.getPage(pages[i] - 1);
                PDFAnnotationIterator annotItr = pdfPage.getAnnotationsIterator();
                while (annotItr.hasNext()) {
                    PDFAnnotation pdfAnnotation = annotItr.next();
                    if (pdfAnnotation instanceof PDFAnnotationWidget || pdfAnnotation instanceof PDFAnnotationLink) continue;
                    annotItr.remove();
                }
            }
        }
    }

    public void removeFonts(PDFDocument pdfDoc) throws Exception {
        CosDocument cosDoc = pdfDoc.getCosDocument();
        for (int i = 0; i < cosDoc.getNumObjects(); ++i) {
            CosObject cosSubtype;
            CosDictionary cosDict;
            CosObject cosType;
            CosObject cosObj = cosDoc.getIndirectObjectByNumber(i);
            if (!(cosObj instanceof CosDictionary) || !((cosType = (cosDict = (CosDictionary)cosObj).get(ASName.k_Type)) instanceof CosName) || ((CosName)cosType).nameValue() != ASName.k_Font || !((cosSubtype = cosDict.get(ASName.k_Subtype)) instanceof CosName)) continue;
            Object pdfFontObj = null;
            try {
                pdfFontObj = PDFFontFactory.getInstance((CosObject)cosDict);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(pdfFontObj instanceof PDFFont)) continue;
            this.processFont((PDFFont)pdfFontObj);
        }
    }

    private void processFont(PDFFont pdfFont) throws Exception {
        if (pdfFont == null) {
            return;
        }
        PDFFontDescriptor fontDesc = pdfFont.getFontDescriptor();
        if (fontDesc == null) {
            return;
        }
        if (fontDesc.getFontFile() == null && fontDesc.getFontFile2() == null && fontDesc.getFontFile3() == null) {
            return;
        }
        String baseName = pdfFont.getBaseFont().asString(true);
        boolean isSubsetName = false;
        if (baseName != null && baseName.length() > 7) {
            isSubsetName = true;
            for (int i = 0; i < 6; ++i) {
                char prefixChar = baseName.charAt(i);
                if (prefixChar >= 'A' && prefixChar <= 'Z') continue;
                isSubsetName = false;
            }
            if (baseName.charAt(6) != '+') {
                isSubsetName = false;
            }
        }
        if (isSubsetName) {
            baseName = baseName.substring(7);
        }
        ASName newName = ASName.create((String)baseName);
        if (pdfFont instanceof PDFFontSimple) {
            if ((fontDesc.getFlags() & 4) != 0) {
                return;
            }
        } else if (pdfFont instanceof PDFFontType0) {
            PDFCIDFont descendentFont = ((PDFFontType0)pdfFont).getDescendantFont();
            if (descendentFont == null) {
                return;
            }
            PDFCIDSystemInfo cidSysInfo = descendentFont.getCIDSystemInfo();
            if (cidSysInfo == null) {
                return;
            }
            if (cidSysInfo.getOrdering().asString().equals("Identity")) {
                return;
            }
            if (isSubsetName) {
                descendentFont.setBaseFont(newName);
            }
            descendentFont.getCosDictionary().remove(ASName.k_CIDToGIDMap);
        }
        if (isSubsetName) {
            pdfFont.setBaseFont(newName);
            fontDesc.setFontName(newName);
        }
        fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_CharSet);
        fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_CIDSet);
        fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_FontFile);
        fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_FontFile2);
        fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_FontFile3);
    }

    public void noLinks(PDFDocument pdfDocument, String page) throws PDFException {
        if (page == null) {
            PDFAnnotationIterator annotItr = pdfDocument.requireCatalog().getPages().getAnnotationsIterator();
            while (annotItr.hasNext()) {
                PDFAnnotation pdfAnnotation = annotItr.next();
                if (!(pdfAnnotation instanceof PDFAnnotationLink)) continue;
                annotItr.remove();
            }
        } else {
            PDFPageTree tempPages = pdfDocument.requirePages();
            int totalPagenumber = tempPages.getNumPages();
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("OPTIMIZE", page, (Object)pdfDocument);
                }
                PDFPage pdfPage = tempPages.getPage(pages[i] - 1);
                PDFAnnotationIterator annotItr = pdfPage.getAnnotationsIterator();
                while (annotItr.hasNext()) {
                    PDFAnnotation pdfAnnotation = annotItr.next();
                    if (!(pdfAnnotation instanceof PDFAnnotationLink)) continue;
                    annotItr.remove();
                }
            }
        }
    }

    private PDFRectangle transform(PDFRectangle rect, int rotationAngle, double hScale, double vScale, int[] position) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle asRect = rect.getRectangle();
        asRect = asRect.transform(this.getTransformationMatrix(rotationAngle));
        asRect = asRect.transform(this.getTransformationMatrixScale(hScale, vScale));
        if (position != null) {
            asRect = asRect.transform(this.getTransformationMatrixTranslate((double)position[0] / (asRect.top() - asRect.bottom()), (double)position[1] / (asRect.right() - asRect.left())));
        }
        return PDFRectangle.newInstance((PDFDocument)rect.getPDFDocument(), (ASRectangle)asRect);
    }

    private ASMatrix getTransformationMatrix(int rotationAngle) {
        return ASMatrix.createIdentityMatrix().rotate(Math.toRadians(rotationAngle));
    }

    private ASMatrix getTransformationMatrixScale(double hScale, double vScale) {
        return ASMatrix.createIdentityMatrix().scale(hScale, vScale);
    }

    private ASMatrix getTransformationMatrixTranslate(double h, double v) {
        return ASMatrix.createIdentityMatrix().translate(h, v);
    }

    public PDFDocument transform(PDFDocument pdfDocument, String password, String destination, int rotation, int[] position, double hScale, double vScale, String page) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        PMMPageTransformations pageTransformations = new PMMPageTransformations();
        pageTransformations.scale(hScale, vScale);
        pageTransformations.rotate(PDFRotation.getInstance((int)rotation));
        if (position != null) {
            pageTransformations.translate((double)position[0], (double)position[1]);
        }
        if (page == null) {
            for (PDFPage pdfPage : tempPages) {
                this.applyPageRectTransform(pdfPage, rotation, hScale, vScale, position);
                pageTransformations.transform(pdfPage);
            }
        } else {
            PDFPage[] pageList = this.getPagesInternal(pdfDocument, page);
            for (int i = 0; i < pageList.length; ++i) {
                PDFPage pdfPage = pageList[i];
                this.applyPageRectTransform(pdfPage, rotation, hScale, vScale, position);
                pageTransformations.transform(pdfPage);
            }
            PMMService pmmService = new PMMService(pdfDocument);
            pdfDocument = pmmService.extractPages(pageList, PMMOptions.newInstanceAll(), PDFOpenOptions.newInstance());
        }
        return pdfDocument;
    }

    private void applyPageRectTransform(PDFPage pdfPage, int rotation, double hScale, double vScale, int[] position) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle cropRect = pdfPage.getCropBox();
        if (cropRect != null) {
            cropRect = this.transform(cropRect, rotation, hScale, vScale, position);
            pdfPage.setCropBox(cropRect);
        }
        PDFRectangle mediaRect = pdfPage.getMediaBox();
        mediaRect = this.transform(mediaRect, rotation, hScale, vScale, position);
        pdfPage.setMediaBox(mediaRect);
    }

    public void addHF(PDFDocument pdfDocument, String page, int opacity, boolean showOnPrint, String type, String align, double leftMargin, double rightMargin, double horMargin, coldfusion.image.Image stampPage) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, true, type);
        if (page == null) {
            for (PDFPage sourcePage : tempPages) {
                this.applyHF(type, sourcePage, stampPage, applyOptions, useOptions, align, leftMargin, rightMargin, horMargin);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException(type, page, (Object)pdfDocument);
                }
                PDFPage sourcePage = tempPages.getPage(pages[i] - 1);
                this.applyHF(type, sourcePage, stampPage, applyOptions, useOptions, align, leftMargin, rightMargin, horMargin);
            }
        }
    }

    private void applyHF(String type, PDFPage sourcePage, coldfusion.image.Image stampPage, XObjectApplyOptions applyOptions, XObjectUseOptions useOptions, String align, double leftMargin, double rightMargin, double horMargin) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isHeader = "ADDHEADER".equalsIgnoreCase(type);
        PDFRectangle cropbox = sourcePage.getCropBox();
        double len = cropbox.getValues()[2] - cropbox.getValues()[0] - (rightMargin + leftMargin) * (double)this.dpi;
        PDFDocument document = this.getHFImage(stampPage, len, horMargin * (double)this.dpi);
        double[] position = isHeader ? this.getHeaderPosition(sourcePage, stampPage, align, leftMargin, rightMargin, horMargin) : this.getFooterPosition(sourcePage, stampPage, align, leftMargin, rightMargin, horMargin);
        double llx = position[0];
        double lly = position[1];
        applyOptions.setPosition(llx, lly);
        if (document != null) {
            PageContentXObject.applyPageContent((PDFPage)sourcePage, (PDFPage)document.requirePages().getPage(0), (XObjectApplyOptions)applyOptions, (XObjectUseOptions)useOptions);
        }
    }

    private double[] getHeaderPosition(PDFPage sourcePage, coldfusion.image.Image stampPage, String align, double leftMargin, double rightMargin, double horMargin) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] llxy = new double[2];
        PDFRectangle cropbox = sourcePage.getCropBox();
        llxy[1] = cropbox.getValues()[3] - cropbox.getValues()[1] - horMargin * (double)this.dpi;
        if ("LEFT".equalsIgnoreCase(align)) {
            llxy[0] = leftMargin * (double)this.dpi;
        } else if ("CENTER".equalsIgnoreCase(align)) {
            llxy[0] = (cropbox.getValues()[2] - cropbox.getValues()[0] - (double)stampPage.getCurrentImage().getWidth()) / 2.0;
        } else if ("RIGHT".equalsIgnoreCase(align)) {
            llxy[0] = cropbox.getValues()[2] - cropbox.getValues()[0] - (double)stampPage.getCurrentImage().getWidth() - rightMargin * (double)this.dpi;
        }
        if (llxy[1] < 0.0) {
            llxy[1] = 0.0;
        }
        if (llxy[0] < 0.0) {
            llxy[0] = 0.0;
        }
        return llxy;
    }

    private double[] getFooterPosition(PDFPage sourcePage, coldfusion.image.Image stampPage, String align, double leftMargin, double rightMargin, double horMargin) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] llxy = new double[2];
        PDFRectangle cropbox = sourcePage.getCropBox();
        llxy[1] = horMargin * (double)this.dpi - (double)stampPage.getCurrentImage().getHeight();
        if ("LEFT".equalsIgnoreCase(align)) {
            llxy[0] = leftMargin * (double)this.dpi;
        } else if ("CENTER".equalsIgnoreCase(align)) {
            llxy[0] = (cropbox.getValues()[2] - cropbox.getValues()[0] - (double)stampPage.getCurrentImage().getWidth()) / 2.0;
        } else if ("RIGHT".equalsIgnoreCase(align)) {
            llxy[0] = cropbox.getValues()[2] - cropbox.getValues()[0] - (double)stampPage.getCurrentImage().getWidth() - rightMargin * (double)this.dpi;
        }
        if (llxy[1] < 0.0) {
            llxy[1] = 0.0;
        }
        if (llxy[0] < 0.0) {
            llxy[0] = 0.0;
        }
        return llxy;
    }

    public void addHF(PDFDocument pdfDocument, String page, int opacity, boolean showOnPrint, String richText, String type, String align, String numberFormat, double leftMargin, double rightMargin, double horMargin) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        Object document = null;
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, true, type);
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        boolean isHeader = "ADDHEADER".equalsIgnoreCase(type);
        int builtinKeyType = this.findBuiltinKeys(richText);
        LinkedHashMap<Integer, PageLabelRange> pageLabelMap = null;
        if (builtinKeyType == 2) {
            pageLabelMap = this.getPageLabelsAsMap(pdfDocument);
        } else if (builtinKeyType == 0) {
            pageLabelMap = new LinkedHashMap<Integer, PageLabelRange>();
            pageLabelMap.put(new Integer(tempPages.getNumPages() - 1), this.getLastPageLabel(pdfDocument));
        }
        boolean cached = builtinKeyType < 1;
        PDFXObjectForm xobject = null;
        if (cached) {
            xobject = this.getXObjectToHF(richText, pdfDocument, useOptions, align, leftMargin, rightMargin, horMargin, isHeader, applyOptions, 0, numberFormat, pageLabelMap, -1);
        }
        if (page == null) {
            for (PDFPage sourcePage : tempPages) {
                if (!cached) {
                    xobject = this.getXObjectToHF(richText, pdfDocument, useOptions, align, leftMargin, rightMargin, horMargin, isHeader, applyOptions, sourcePage.getPageNumber(), numberFormat, pageLabelMap, -1);
                }
                applyOptions.applyXObjectForm(sourcePage, xobject, useOptions);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException(type, page, (Object)pdfDocument);
                }
                PDFPage sourcePage = tempPages.getPage(pages[i] - 1);
                if (!cached) {
                    xobject = this.getXObjectToHF(richText, pdfDocument, useOptions, align, leftMargin, rightMargin, horMargin, isHeader, applyOptions, sourcePage.getPageNumber(), numberFormat, pageLabelMap, i);
                }
                applyOptions.applyXObjectForm(sourcePage, xobject, useOptions);
            }
        }
    }

    public void addHF(PDFDocument pdfDocument, int opacity, boolean showOnPrint, PDFgHFContentProvider contentProvider, String type, String align, String numberFormat, double leftMargin, double rightMargin, double horMargin) throws PDFException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        Object document = null;
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, true, type);
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        boolean isHeader = "ADDHEADER".equalsIgnoreCase(type);
        Map pageLabelMap = this.getPageLabelsAsMap(pdfDocument);
        PDFXObjectForm xobject = null;
        for (PDFPage sourcePage : tempPages) {
            String richText = null;
            try {
                richText = contentProvider.getContent(sourcePage.getPageNumber(), pdfDocument.requirePages().getNumPages());
            }
            catch (Throwable e) {
                throw new PDFException(e.getMessage(), e);
            }
            xobject = this.getXObjectToHF(richText, pdfDocument, useOptions, align, leftMargin, rightMargin, horMargin, isHeader, applyOptions, sourcePage.getPageNumber(), numberFormat, pageLabelMap, -1);
            applyOptions.applyXObjectForm(sourcePage, xobject, useOptions);
        }
    }

    public void addHFForDocument(PDFDocument pdfDocument, int opacity, boolean showOnPrint, PDFgHFContentProvider contentProvider, coldfusion.image.Image imagePage, String type, String numberFormat, String align, double leftMargin, double rightMargin, double horMargin) throws PDFException {
        if (imagePage != null) {
            this.addHF(pdfDocument, null, opacity, showOnPrint, type, align, leftMargin, rightMargin, horMargin, imagePage);
        } else {
            this.addHF(pdfDocument, opacity, showOnPrint, contentProvider, type, align, numberFormat, leftMargin, rightMargin, horMargin);
        }
    }

    private PDFXObjectForm getXObjectToHF(String richText, PDFDocument pdfDocument, XObjectUseOptions useOptions, String align, double leftMargin, double rightMargin, double horMargin, boolean isHeader, XObjectApplyOptions applyOptions, int currPageNum, String style, Map pageLabels, int insertPageNum) throws PDFException {
        PDFFontSet pdfFontSet = (PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet();
        PDFRectangle cropbox = ((PDFPage)pdfDocument.requirePages().get(currPageNum)).getCropBox();
        if (isHeader) {
            applyOptions.setPosition(0.0, cropbox.getValues()[3] - cropbox.getValues()[1] - horMargin * (double)this.dpi);
        } else {
            applyOptions.setPosition(0.0, 0.0);
        }
        double wid = cropbox != null ? cropbox.getValues()[2] - cropbox.getValues()[0] : 8.5 * (double)this.dpi;
        String defaultStyle = "font: 'Courier' 10pt";
        RCGOptions rcgOptions = new RCGOptions(wid, horMargin * (double)this.dpi);
        rcgOptions.setWrap(RCGWrapOption.NoWrap);
        rcgOptions.setOverflow(RCGOverflowMode.Auto);
        if (isHeader) {
            rcgOptions.setVerticalAlignment(RCGAlignment.Bottom);
        } else {
            rcgOptions.setVerticalAlignment(RCGAlignment.Top);
        }
        rcgOptions.setPaddingLeft(leftMargin * (double)this.dpi);
        rcgOptions.setPaddingRight(rightMargin * (double)this.dpi);
        if ("CENTER".equalsIgnoreCase(align)) {
            rcgOptions.setDefaultStyle("text-align:center;" + defaultStyle);
        } else if ("LEFT".equalsIgnoreCase(align)) {
            rcgOptions.setDefaultStyle("text-align:left;" + defaultStyle);
        } else {
            rcgOptions.setDefaultStyle("text-align:right;" + defaultStyle);
        }
        StringBuffer textBuffer = new StringBuffer("<body><p>").append(richText).append("</p></body>");
        this.resolvePageNumbers(textBuffer, currPageNum, pdfDocument.requirePages().getNumPages(), pageLabels, style, insertPageNum);
        ByteArrayInputStream richTextStream = new ByteArrayInputStream(textBuffer.toString().getBytes());
        PDFXObjectForm xobject = RichTextContentGenerator.generateXObject((PDFDocument)pdfDocument, (InputStream)richTextStream, (Charset)Charset.defaultCharset(), (PDFFontSet)pdfFontSet, (RCGOptions)rcgOptions, (XObjectUseOptions)useOptions);
        return xobject;
    }

    private int findBuiltinKeys(String text) {
        if ((text = text.toUpperCase()).indexOf("_PAGELABEL") != -1) {
            return 2;
        }
        if (text.indexOf("_PAGENUMBER") != -1) {
            return 1;
        }
        if (text.indexOf("_LASTPAGELABEL") != -1 || text.indexOf("_LASTPAGENUMBER") != -1) {
            return 0;
        }
        return -1;
    }

    private void resolvePageNumbers(StringBuffer inoutBuffer, int currentPageNumber, int lastPageNumber, Map pageLabelMap, String style, int insertPageNum) {
        this.replaceBuiltinKeys(inoutBuffer, "_PAGELABEL", this.generatePageLabelString(currentPageNumber, pageLabelMap, style));
        this.replaceBuiltinKeys(inoutBuffer, "_LASTPAGELABEL", this.generatePageLabelString(lastPageNumber - 1, pageLabelMap, style));
        if (insertPageNum == -1) {
            this.replaceBuiltinKeys(inoutBuffer, "_PAGENUMBER", this.generatePageNumberString(++currentPageNumber, style));
            this.replaceBuiltinKeys(inoutBuffer, "_CURRENTPAGENUMBER", this.generatePageNumberString(currentPageNumber, style));
        } else {
            this.replaceBuiltinKeys(inoutBuffer, "_PAGENUMBER", this.generatePageNumberString(++insertPageNum, style));
            this.replaceBuiltinKeys(inoutBuffer, "_CURRENTPAGENUMBER", this.generatePageNumberString(insertPageNum, style));
        }
        this.replaceBuiltinKeys(inoutBuffer, "_LASTPAGENUMBER", this.generatePageNumberString(lastPageNumber, style));
        this.replaceBuiltinKeys(inoutBuffer, "_TOTALPAGECOUNT", this.generatePageNumberString(lastPageNumber, style));
    }

    private void replaceBuiltinKeys(StringBuffer inoutBuffer, String keyToReplace, String replaceString) {
        int foundIndex = 0;
        while ((foundIndex = inoutBuffer.indexOf(keyToReplace, foundIndex)) != -1) {
            if (foundIndex <= 0) continue;
            inoutBuffer.replace(foundIndex, foundIndex + keyToReplace.length(), replaceString);
            foundIndex += replaceString.length();
        }
    }

    private String generatePageLabelString(int pageNumber, Map pageLabelMap, String style) {
        StringBuffer pageLabel = new StringBuffer();
        if (pageLabelMap == null) {
            pageLabel = new StringBuffer(this.generatePageNumberString(pageNumber + 1, style));
        } else {
            PageLabelRange pageLabelInfo = (PageLabelRange)pageLabelMap.get(new Integer(pageNumber));
            if (pageLabelInfo != null) {
                PDFPageLabelStyle pageLabelStyle = pageLabelInfo.labelInfo().getStyle();
                int pageLabelNumber = pageLabelInfo.labelInfo().getPageLabelNumber();
                String prefix = pageLabelInfo.labelInfo().getPrefix();
                int pageRangeStart = pageLabelInfo.getPageRange().getStartPage();
                if (prefix == null) {
                    prefix = WORDNS;
                }
                pageLabelNumber += pageNumber + 1 - pageRangeStart;
                if (pageLabelStyle != null) {
                    if (pageLabelStyle.equals((Object)PDFPageLabelStyle.Decimal)) {
                        pageLabel.append(prefix);
                        pageLabel.append(pageLabelNumber);
                    } else if (pageLabelStyle.equals((Object)PDFPageLabelStyle.UppercaseRoman)) {
                        pageLabel.append(prefix);
                        pageLabel.append(PDFDocUtil.romanNumeral(pageLabelNumber).toUpperCase());
                    } else if (pageLabelStyle.equals((Object)PDFPageLabelStyle.LowercaseRoman)) {
                        pageLabel.append(prefix);
                        pageLabel.append(PDFDocUtil.romanNumeral(pageLabelNumber));
                    } else if (pageLabelStyle.equals((Object)PDFPageLabelStyle.UppercaseLetter)) {
                        pageLabel.append(prefix);
                        pageLabel.append(PDFDocUtil.generateLCAlphaNumeralPDF(pageLabelNumber - 1).toUpperCase());
                    } else if (pageLabelStyle.equals((Object)PDFPageLabelStyle.LowercaseLetter)) {
                        pageLabel.append(prefix);
                        pageLabel.append(PDFDocUtil.generateLCAlphaNumeralPDF(pageLabelNumber));
                    }
                } else {
                    pageLabel.append(prefix);
                }
            } else {
                pageLabel = new StringBuffer(this.generatePageNumberString(pageNumber + 1, style));
            }
        }
        for (int i = 0; i < pageLabel.length(); ++i) {
            if (pageLabel.charAt(i) == '&') {
                pageLabel.replace(i, i + 1, "&#x26;");
                i += 5;
            }
            if (pageLabel.charAt(i) == '<') {
                pageLabel.replace(i, i + 1, "&#x3c;");
                i += 5;
            }
            if (pageLabel.charAt(i) == '>') {
                pageLabel.replace(i, i + 1, "&#x3e;");
                i += 5;
            }
            if (pageLabel.charAt(i) == '\'') {
                pageLabel.replace(i, i + 1, "&#x27;");
                i += 5;
            }
            if (pageLabel.charAt(i) != '\"') continue;
            pageLabel.replace(i, i + 1, "&#x22;");
            i += 5;
        }
        return pageLabel.toString();
    }

    private String generatePageNumberString(int pageNumber, String style) {
        if (style.equalsIgnoreCase("NUMERIC")) {
            return Integer.toString(pageNumber);
        }
        if (style.equalsIgnoreCase("UPPERCASEROMAN")) {
            return PDFDocUtil.romanNumeral(pageNumber).toUpperCase();
        }
        if (style.equalsIgnoreCase("LOWERCASEROMAN")) {
            return PDFDocUtil.romanNumeral(pageNumber);
        }
        return WORDNS;
    }

    public Map getPageLabelsAsMap(PDFDocument pdfDocument) throws PDFException {
        int totalPages = pdfDocument.requirePages().getNumPages();
        LinkedHashMap<Integer, PageLabelRange> resultMap = new LinkedHashMap<Integer, PageLabelRange>(totalPages);
        LinkedList<PageLabelRange> result = new LinkedList<PageLabelRange>();
        try {
            Iterator itr;
            PDFPageLabels pageLabels = pdfDocument.requireCatalog().getPageLabels();
            if (pageLabels != null) {
                PageLabelRange r;
                PageLabelInfo ii;
                Iterator i = pageLabels.iterator();
                PDFTree.Entry prevLabel = null;
                PDFTree.Entry thisLabel = null;
                while (i.hasNext()) {
                    thisLabel = (PDFTree.Entry)i.next();
                    if (prevLabel != null) {
                        ii = new PageLabelInfo(((PDFPageLabel)prevLabel.getValue()).getStartingNumber(), ((PDFPageLabel)prevLabel.getValue()).getPageLabelStyle(), ((PDFPageLabel)prevLabel.getValue()).getPrefix());
                        r = new PageLabelRange(ii, (Integer)prevLabel.getKey() + 1, ((Integer)thisLabel.getKey()).intValue());
                        result.add(r);
                    }
                    prevLabel = thisLabel;
                }
                if (prevLabel != null) {
                    ii = new PageLabelInfo(((PDFPageLabel)prevLabel.getValue()).getStartingNumber(), ((PDFPageLabel)prevLabel.getValue()).getPageLabelStyle(), ((PDFPageLabel)prevLabel.getValue()).getPrefix());
                    r = new PageLabelRange(ii, (Integer)prevLabel.getKey() + 1, pdfDocument.requireCatalog().getPages().getNumPages());
                    result.add(r);
                }
            }
            PageLabelRange next = (itr = result.iterator()).hasNext() ? (PageLabelRange)itr.next() : null;
            for (int count = 0; count < totalPages; ++count) {
                if (next != null) {
                    if (count < next.getPageRange().getEndPage() && count >= next.getPageRange().getStartPage() - 1) {
                        resultMap.put(new Integer(count), next);
                        continue;
                    }
                    if (itr.hasNext()) {
                        next = (PageLabelRange)itr.next();
                        if (count >= next.getPageRange().getEndPage() || count < next.getPageRange().getStartPage() - 1) continue;
                        resultMap.put(new Integer(count), next);
                        continue;
                    }
                    next = null;
                    continue;
                }
                resultMap.put(new Integer(count), null);
            }
        }
        catch (Exception e) {
            throw new PDFDocException((Throwable)e);
        }
        return resultMap;
    }

    public PageLabelRange getLastPageLabel(PDFDocument pdfDocument) throws PDFException {
        PageLabelRange result = null;
        try {
            PDFPageLabels pageLabels = pdfDocument.requireCatalog().getPageLabels();
            if (pageLabels != null) {
                Iterator i = pageLabels.iterator();
                PDFTree.Entry prevLabel = null;
                while (i.hasNext()) {
                    prevLabel = (PDFTree.Entry)i.next();
                }
                if (prevLabel != null) {
                    PageLabelInfo ii = new PageLabelInfo(((PDFPageLabel)prevLabel.getValue()).getStartingNumber(), ((PDFPageLabel)prevLabel.getValue()).getPageLabelStyle(), ((PDFPageLabel)prevLabel.getValue()).getPrefix());
                    result = new PageLabelRange(ii, (Integer)prevLabel.getKey() + 1, pdfDocument.requireCatalog().getPages().getNumPages());
                }
            }
        }
        catch (Exception e) {
            throw new PDFDocException((Throwable)e);
        }
        return result;
    }

    private PDFXObjectForm getWatermarkXObject(Object stampPage, PDFDocument inDoc, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFXObjectForm xObjectToApply = null;
        if (stampPage instanceof PDFPage) {
            xObjectToApply = PageContentXObject.generateContentXObject((PDFDocument)inDoc, (PDFPage)((PDFPage)stampPage), (XObjectUseOptions)useOptions);
        } else if (stampPage instanceof coldfusion.image.Image) {
            BufferedImage bimage = ((coldfusion.image.Image)stampPage).getCurrentImage();
            BufferedImage bufImage = this._convertImageToSupportedType(bimage);
            xObjectToApply = ImageManager.getXObjPDFImage((PDFDocument)inDoc, (BufferedImage)bufImage, (XObjectUseOptions)useOptions);
        } else if (stampPage instanceof PDFXObjectForm) {
            xObjectToApply = (PDFXObjectForm)stampPage;
        }
        return xObjectToApply;
    }

    private PDFXObjectForm getWatermarkXObjectForDocumentTag(Object stampPage, PDFDocument inDoc, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFXObjectForm xObjectToApply = null;
        if (stampPage instanceof PDFPage) {
            xObjectToApply = PageContentXObject.generateContentXObject((PDFDocument)inDoc, (PDFPage)((PDFPage)stampPage), (XObjectUseOptions)useOptions);
        } else if (stampPage instanceof coldfusion.image.Image) {
            BufferedImage bimage = ((coldfusion.image.Image)stampPage).getCurrentImage();
            xObjectToApply = ImageManager.getXObjPDFImage((PDFDocument)inDoc, (BufferedImage)bimage, (XObjectUseOptions)useOptions);
        } else if (stampPage instanceof PDFXObjectForm) {
            xObjectToApply = (PDFXObjectForm)stampPage;
        }
        return xObjectToApply;
    }

    private BufferedImage _convertImageToSupportedType(BufferedImage bimage) {
        ColorConvertOp convertOp = new ColorConvertOp(bimage.getColorModel().getColorSpace(), ColorSpace.getInstance(1000), null);
        BufferedImage bufImage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
        convertOp.filter(bimage, bufImage);
        return bufImage;
    }

    public void addBackgroundForDocument(PDFDocument pdfDocument, Object stampPage, boolean foreground, int opacity, int[] position, int rotation, boolean showOnPrint) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        applyOptions.setRotation((double)rotation);
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, foreground, "background");
        PDFXObjectForm xObjectToApply = this.getWatermarkXObjectForDocumentTag(stampPage, pdfDocument, useOptions);
        for (PDFPage sourcePage : tempPages) {
            this.applyWatermark(position, sourcePage, stampPage, applyOptions, useOptions, xObjectToApply);
        }
    }

    public void addWatermark(PDFDocument pdfDocument, String page, Object stampPage, boolean foreground, int opacity, int[] position, int rotation, boolean showOnPrint) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        Object document = null;
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        applyOptions.setOpacity((double)opacity / 10.0);
        applyOptions.setRotation((double)rotation);
        XObjectUseOptions useOptions = this.getUseOptions(showOnPrint, foreground);
        PDFXObjectForm xObjectToApply = this.getWatermarkXObject(stampPage, pdfDocument, useOptions);
        if (page == null) {
            for (PDFPage sourcePage : tempPages) {
                this.applyWatermark(position, sourcePage, stampPage, applyOptions, useOptions, xObjectToApply);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("ADDWATERMARK", page, (Object)pdfDocument);
                }
                PDFPage sourcePage = tempPages.getPage(pages[i] - 1);
                this.applyWatermark(position, sourcePage, stampPage, applyOptions, useOptions, xObjectToApply);
            }
        }
    }

    private XObjectUseOptions getUseOptions(boolean showOnPrint, boolean foreground) {
        return this.getUseOptions(showOnPrint, foreground, WORDNS);
    }

    private XObjectUseOptions getUseOptions(boolean showOnPrint, boolean foreground, String type) {
        XObjectUseOptions useOptions = new XObjectUseOptions();
        if ("ADDHEADER".equalsIgnoreCase(type)) {
            useOptions.setContentType(XObjectContentType.Header);
            useOptions.makeForeground();
        } else if ("ADDFOOTER".equalsIgnoreCase(type)) {
            useOptions.setContentType(XObjectContentType.Footer);
            useOptions.makeForeground();
        } else if ("background".equalsIgnoreCase(type)) {
            useOptions.setContentType(XObjectContentType.Background);
            if (foreground) {
                useOptions.makeForeground();
            } else {
                useOptions.makeBackground();
            }
        } else {
            useOptions.setContentType(XObjectContentType.Watermark);
            if (foreground) {
                useOptions.makeForeground();
            } else {
                useOptions.makeBackground();
            }
        }
        useOptions.setPrintOn(showOnPrint);
        useOptions.setViewOn(true);
        return useOptions;
    }

    private PDFDocument getWatermarkImage(Object stampPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument document = PDFDocument.newInstance((PDFOpenOptions)PDFDocHandler.createCustomFilterOpenOptions());
        BufferedImage bimage = ((coldfusion.image.Image)stampPage).getCurrentImage();
        PDFPage newPage = PDFPage.newInstance((PDFDocument)document, (PDFRectangle)PDFRectangle.newInstance((PDFDocument)document, (double)0.0, (double)0.0, (double)bimage.getWidth(), (double)bimage.getHeight()));
        PDFPageTree.newInstance((PDFDocument)document, (PDFPage)newPage);
        BufferedImage bufImage = this._convertImageToSupportedType(bimage);
        PDFXObjectImage objectImage = ImageManager.getPDFImage((BufferedImage)bufImage, (PDFDocument)document);
        ImageManager.insertImageInPDF((PDFXObjectImage)objectImage, (PDFPage)newPage, (PDFExtGState)PDFExtGState.newInstance((PDFDocument)document), (ASMatrix)new ASMatrix((double)bimage.getWidth(), 0.0, 0.0, (double)bimage.getHeight(), 0.0, 0.0));
        return document;
    }

    private PDFDocument getHFImage(Object stampPage, double len, double ht) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument document = PDFDocument.newInstance((PDFOpenOptions)PDFDocHandler.createCustomFilterOpenOptions());
        BufferedImage bimage = ((coldfusion.image.Image)stampPage).getCurrentImage();
        double width = bimage.getWidth();
        double height = bimage.getHeight();
        if (width > len) {
            width = len;
        }
        if (height > ht) {
            height = ht;
        }
        PDFPage newPage = PDFPage.newInstance((PDFDocument)document, (PDFRectangle)PDFRectangle.newInstance((PDFDocument)document, (double)0.0, (double)0.0, (double)width, (double)height));
        PDFPageTree.newInstance((PDFDocument)document, (PDFPage)newPage);
        BufferedImage bufImage = this._convertImageToSupportedType(bimage);
        PDFXObjectImage objectImage = ImageManager.getPDFImage((BufferedImage)bufImage, (PDFDocument)document);
        ImageManager.insertImageInPDF((PDFXObjectImage)objectImage, (PDFPage)newPage, (PDFExtGState)PDFExtGState.newInstance((PDFDocument)document), (ASMatrix)new ASMatrix(width, 0.0, 0.0, height, 0.0, 0.0));
        return document;
    }

    private void applyWatermark(int[] position, PDFPage sourcePage, Object stampPage, XObjectApplyOptions applyOptions, XObjectUseOptions useOptions, PDFXObjectForm xObjectToApply) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double lly;
        double llx;
        if (position != null) {
            llx = position[0];
            lly = position[1];
        } else {
            double[] centerPosition = this.getCenterPosition(sourcePage, stampPage);
            llx = centerPosition[0];
            lly = centerPosition[1];
        }
        applyOptions.setPosition(llx, lly);
        if (xObjectToApply != null) {
            applyOptions.applyXObjectForm(sourcePage, xObjectToApply, useOptions);
        } else if (stampPage instanceof PDFXObjectForm) {
            applyOptions.applyXObjectForm(sourcePage, (PDFXObjectForm)stampPage, useOptions);
        }
    }

    private double[] getCenterPosition(PDFPage sourcePage, Object stampPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] llxy = new double[2];
        PDFRectangle cropbox = sourcePage.getCropBox();
        if (cropbox != null) {
            llxy[0] = (cropbox.getValues()[2] - cropbox.getValues()[0]) / 2.0;
            llxy[1] = (cropbox.getValues()[3] - cropbox.getValues()[1]) / 2.0;
        }
        if (stampPage instanceof coldfusion.image.Image) {
            llxy[0] = llxy[0] - (double)(((coldfusion.image.Image)stampPage).getCurrentImage().getWidth() / 2);
            llxy[1] = llxy[1] - (double)(((coldfusion.image.Image)stampPage).getCurrentImage().getHeight() / 2);
        } else if (stampPage instanceof PDFPage) {
            PDFRectangle copyFromCropbox = ((PDFPage)stampPage).getCropBox();
            if (cropbox != null) {
                llxy[0] = llxy[0] - (copyFromCropbox.getValues()[0] + copyFromCropbox.getValues()[2]) / 2.0;
                llxy[1] = llxy[1] - (copyFromCropbox.getValues()[1] + copyFromCropbox.getValues()[3]) / 2.0;
            }
        } else if (stampPage instanceof PDFXObjectForm) {
            PDFRectangle stampBBox = ((PDFXObjectForm)stampPage).getBBox();
            if (stampBBox != null) {
                llxy[0] = llxy[0] - (stampBBox.getValues()[0] + stampBBox.getValues()[2]) / 2.0;
                llxy[1] = llxy[1] - (stampBBox.getValues()[1] + stampBBox.getValues()[3]) / 2.0;
            } else {
                llxy[0] = cropbox != null ? cropbox.getValues()[0] : 0.0;
                llxy[1] = cropbox != null ? cropbox.getValues()[1] : 0.0;
            }
        }
        return llxy;
    }

    public void removeHFW(PDFDocument pdfDocument, String page, boolean stopOnError, String type) throws PDFException {
        if ("REMOVEWATERMARK".equalsIgnoreCase(type)) {
            this.removeObjectType(pdfDocument, page, XObjectContentType.Watermark, stopOnError, type, false);
        } else if ("REMOVEHEADERFOOTER".equalsIgnoreCase(type)) {
            this.removeObjectType(pdfDocument, page, XObjectContentType.Header, stopOnError, type, true);
            this.removeObjectType(pdfDocument, page, XObjectContentType.Footer, stopOnError, type, true);
        }
    }

    private void removeObjectType(PDFDocument pdfDocument, String page, XObjectContentType xObjConType, boolean stopOnError, String type, boolean markedContent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int totalPagenumber = tempPages.getNumPages();
        if (page == null) {
            for (int i = 0; i < totalPagenumber; ++i) {
                if (PageContentXObject.removeAppliedContent((PDFPage)tempPages.getPage(i), (XObjectContentType)xObjConType, (boolean)markedContent) || !stopOnError) continue;
                pdfDocument.close();
                throw new PDFException.RemoveInvalidPageException(WORDNS + i, (Object)pdfDocument);
            }
        } else {
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException(type, page, (Object)pdfDocument);
                }
                if (PageContentXObject.removeAppliedContent((PDFPage)tempPages.getPage(pages[i] - 1), (XObjectContentType)xObjConType) || !stopOnError) continue;
                throw new PDFException.RemoveInvalidPageException(WORDNS + pages[i], (Object)pdfDocument);
            }
        }
    }

    public String extractText(PDFDocument pdfDocument, String page, String type, boolean addQuads, boolean honourSpaces, boolean useStructure, String charset) throws PDFException, IOException {
        String result = null;
        try {
            result = type.equalsIgnoreCase("XML") ? this.extractTextXML(pdfDocument, page, addQuads, honourSpaces, useStructure, charset) : this.extractTextString(pdfDocument, page, honourSpaces, useStructure);
        }
        catch (NullPointerException e) {
            if (useStructure) {
                return this.extractText(pdfDocument, page, type, addQuads, honourSpaces, false, charset);
            }
            throw new PDFDocException((Throwable)e, (Object)pdfDocument);
        }
        return result;
    }

    public String extractTextString(PDFDocument pdfDocument, String page, boolean honourSpaces, boolean useStructure) throws PDFException, IOException {
        PDFPageTree tempPages = pdfDocument.requirePages();
        int totalPagenumber = tempPages.getNumPages();
        StringBuilder unicodeOut = new StringBuilder();
        ReadingOrderTextExtractor extractor = null;
        if (honourSpaces) {
            TextExtractionOptions txtExtOptns = TextExtractionOptions.newInstance();
            txtExtOptns.setHonourSpaces(honourSpaces);
            txtExtOptns.setUseStructure(useStructure);
            extractor = TextExtractor.newInstance((PDFDocument)pdfDocument, (PDFFontSet)((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet()), (TextExtractionOptions)txtExtOptns);
        } else {
            extractor = ReadingOrderTextExtractor.newInstance((PDFDocument)pdfDocument, (PDFFontSet)((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet()), (boolean)useStructure);
        }
        WordsIterator wordsIter = extractor instanceof ReadingOrderTextExtractor ? extractor.getWordsIterator() : ((TextExtractor)extractor).getWordsIterator();
        int lastPageNo = -1;
        int[] pages = null;
        int pagecount = 0;
        int countPages = -1;
        if (page != null) {
            pages = new int[tempPages.getNumPages()];
            pagecount = this.getPages(page, pages);
            countPages = 0;
        }
        boolean firstWord = true;
        while (wordsIter.hasNext()) {
            Word word = wordsIter.next();
            int currentPageNo = word.getPageNumber();
            if (currentPageNo != lastPageNo) {
                if (countPages != -1 && pages[countPages] == lastPageNo) {
                    ++countPages;
                }
                if (countPages >= pagecount) break;
                if (countPages != -1 && pages[countPages] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("EXTRACTTEXT", page, (Object)pdfDocument);
                }
                lastPageNo = currentPageNo;
            }
            if (countPages != -1 && (pages[countPages] == 0 || pages[countPages] != currentPageNo)) continue;
            if (firstWord) {
                firstWord = false;
            } else {
                unicodeOut.append(" ");
            }
            String str = word.toString();
            unicodeOut.append(str);
        }
        return unicodeOut.toString();
    }

    public String extractTextXML(PDFDocument pdfDocument, String page, boolean addQuads, boolean honourSpaces, boolean useStructure, String charset) throws PDFException, IOException {
        try {
            PDFPageTree pageTree = pdfDocument.requirePages();
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = tf.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", charset);
            serializer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            handler.setResult(streamResult);
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.clear();
            handler.startElement(WORDNS, WORDSELEM, WORDSELEM, attrs);
            ReadingOrderTextExtractor extractor = null;
            PDFFontSetManager x = new PDFFontSetManager();
            if (honourSpaces) {
                TextExtractionOptions txtExtOptns = TextExtractionOptions.newInstance();
                txtExtOptns.setHonourSpaces(honourSpaces);
                txtExtOptns.setUseStructure(useStructure);
                extractor = TextExtractor.newInstance((PDFDocument)pdfDocument, (PDFFontSet)FontSetBuilder.getPdfFontSet(), (TextExtractionOptions)txtExtOptns);
            } else {
                extractor = ReadingOrderTextExtractor.newInstance((PDFDocument)pdfDocument, (PDFFontSet)FontSetBuilder.getPdfFontSet(), (boolean)useStructure);
            }
            if (addQuads) {
                attrs.clear();
                handler.startElement(WORDNS, WITHQUADSELEM, WITHQUADSELEM, attrs);
                if (page == null) {
                    for (int i = 0; i < pageTree.size(); ++i) {
                        this.textXMLPerPageQuads(extractor, pageTree, i, attrs, handler);
                    }
                } else {
                    int totalPagenumber = pageTree.getNumPages();
                    int[] pages = new int[totalPagenumber];
                    int pagecount = this.getPages(page, pages);
                    for (int i = 0; i < pagecount; ++i) {
                        if (pages[i] == 0) continue;
                        if (pages[i] > totalPagenumber) {
                            throw new PDFException.PDFDeleteInvalidPageException("EXTRACTTEXT", page, (Object)pdfDocument);
                        }
                        this.textXMLPerPageQuads(extractor, pageTree, pages[i] - 1, attrs, handler);
                    }
                }
                handler.endElement(WORDNS, WITHQUADSELEM, WITHQUADSELEM);
            } else {
                attrs.clear();
                handler.startElement(WORDNS, TEXTPERPAGEELEM, TEXTPERPAGEELEM, attrs);
                if (page == null) {
                    for (int i = 0; i < pageTree.size(); ++i) {
                        this.textXMLPerPage(extractor, pageTree, i, attrs, handler);
                    }
                } else {
                    int totalPagenumber = pageTree.getNumPages();
                    int[] pages = new int[totalPagenumber];
                    int pagecount = this.getPages(page, pages);
                    for (int i = 0; i < pagecount; ++i) {
                        if (pages[i] == 0) continue;
                        if (pages[i] > totalPagenumber) {
                            throw new PDFException.PDFDeleteInvalidPageException("EXTRACTTEXT", page, (Object)pdfDocument);
                        }
                        this.textXMLPerPage(extractor, pageTree, pages[i] - 1, attrs, handler);
                    }
                }
                handler.endElement(WORDNS, TEXTPERPAGEELEM, TEXTPERPAGEELEM);
            }
            handler.endElement(WORDNS, WORDSELEM, WORDSELEM);
            handler.endDocument();
            return ((Object)writer).toString();
        }
        catch (SAXException e) {
            throw new PDFDocException((Throwable)e, (Object)pdfDocument);
        }
        catch (TransformerException e) {
            throw new PDFDocException((Throwable)e, (Object)pdfDocument);
        }
    }

    private void textXMLPerPageQuads(Object extractor, PDFPageTree pageTree, int i, AttributesImpl attrs, TransformerHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, SAXException {
        WordsIterator wordIterator = extractor instanceof ReadingOrderTextExtractor ? ((ReadingOrderTextExtractor)extractor).getWordsIterator(pageTree.getPage(i), i) : ((TextExtractor)extractor).getWordsIterator(pageTree.getPage(i), i);
        boolean firstWord = true;
        while (wordIterator.hasNext()) {
            if (firstWord) {
                firstWord = false;
                attrs.clear();
                attrs.addAttribute(WORDNS, PAGENUMATTR, PAGENUMATTR, "Integer", Integer.toString(i + 1));
                handler.startElement(WORDNS, PAGEELEM, PAGEELEM, attrs);
            }
            Word word = wordIterator.next();
            attrs.clear();
            handler.startElement(WORDNS, WORDELEM, WORDELEM, attrs);
            char[] chars = word.toString().toCharArray();
            handler.characters(chars, 0, chars.length);
            List quads = word.getBoundingQuads();
            if (quads != null) {
                for (Object o : word.getBoundingQuads()) {
                    ASQuad q = (ASQuad)o;
                    attrs.clear();
                    handler.startElement(WORDNS, QUADELEM, QUADELEM, attrs);
                    attrs.addAttribute(WORDNS, XATTR, XATTR, "Double", Double.toString(q.p1().x()));
                    attrs.addAttribute(WORDNS, YATTR, YATTR, "Double", Double.toString(q.p1().y()));
                    handler.startElement(WORDNS, P1ELEM, P1ELEM, attrs);
                    handler.endElement(WORDNS, P1ELEM, P1ELEM);
                    attrs.clear();
                    attrs.addAttribute(WORDNS, XATTR, XATTR, "Double", Double.toString(q.p2().x()));
                    attrs.addAttribute(WORDNS, YATTR, YATTR, "Double", Double.toString(q.p2().y()));
                    handler.startElement(WORDNS, P2ELEM, P2ELEM, attrs);
                    handler.endElement(WORDNS, P2ELEM, P2ELEM);
                    attrs.clear();
                    attrs.addAttribute(WORDNS, XATTR, XATTR, "Double", Double.toString(q.p3().x()));
                    attrs.addAttribute(WORDNS, YATTR, YATTR, "Double", Double.toString(q.p3().y()));
                    handler.startElement(WORDNS, P3ELEM, P3ELEM, attrs);
                    handler.endElement(WORDNS, P3ELEM, P3ELEM);
                    attrs.clear();
                    attrs.addAttribute(WORDNS, XATTR, XATTR, "Double", Double.toString(q.p4().x()));
                    attrs.addAttribute(WORDNS, YATTR, YATTR, "Double", Double.toString(q.p4().y()));
                    handler.startElement(WORDNS, P4ELEM, P4ELEM, attrs);
                    handler.endElement(WORDNS, P4ELEM, P4ELEM);
                    handler.endElement(WORDNS, QUADELEM, QUADELEM);
                }
            }
            handler.endElement(WORDNS, WORDELEM, WORDELEM);
        }
        if (!firstWord) {
            handler.endElement(WORDNS, PAGEELEM, PAGEELEM);
        }
    }

    private void textXMLPerPage(Object extractor, PDFPageTree pageTree, int i, AttributesImpl attrs, TransformerHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, SAXException {
        WordsIterator wordIterator = extractor instanceof ReadingOrderTextExtractor ? ((ReadingOrderTextExtractor)extractor).getWordsIterator(pageTree.getPage(i), i) : ((TextExtractor)extractor).getWordsIterator(pageTree.getPage(i), i);
        boolean firstWord = true;
        while (wordIterator.hasNext()) {
            if (firstWord) {
                firstWord = false;
                attrs.clear();
                attrs.addAttribute(WORDNS, PAGENUMATTR, PAGENUMATTR, "Integer", Integer.toString(i + 1));
                handler.startElement(WORDNS, PAGEELEM, PAGEELEM, attrs);
            } else {
                handler.characters(" ".toCharArray(), 0, 1);
            }
            Word word = wordIterator.next();
            char[] chars = word.toString().toCharArray();
            handler.characters(chars, 0, chars.length);
        }
        if (!firstWord) {
            handler.endElement(WORDNS, PAGEELEM, PAGEELEM);
        }
    }

    public void extractImage(PDFDocument pdfDocument, String destination, String imagePrefix, String format, String page) throws PDFException, IOException {
        if (page == null) {
            PDFXObjectImageWithLocationMap pdfXObjectMap = ImageManager.getPDFXObjectMap((PDFDocument)pdfDocument);
            for (Object o : pdfXObjectMap.keySet()) {
                format = this.extractEachImage(o, pdfXObjectMap, format, destination, imagePrefix);
            }
        } else {
            PDFPageTree tempPages = pdfDocument.requirePages();
            int[] pages = new int[tempPages.getNumPages()];
            int pagecount = this.getPages(page, pages);
            int totalPagenumber = tempPages.getNumPages();
            for (int i = 0; i < pagecount; ++i) {
                if (pages[i] == 0) continue;
                if (pages[i] > totalPagenumber) {
                    throw new PDFException.PDFDeleteInvalidPageException("EXTRACTIMAGE", page, (Object)pdfDocument);
                }
                PDFPage sourcePage = tempPages.getPage(pages[i] - 1);
                PDFXObjectImageWithLocationMap pdfXObjectMap = ImageManager.getPDFXObjectMap((PDFPage)sourcePage);
                for (Object o : pdfXObjectMap.keySet()) {
                    format = this.extractEachImage(o, pdfXObjectMap, format, destination, imagePrefix + "page" + (i + 1));
                }
            }
        }
    }

    private String extractEachImage(Object o, PDFXObjectImageWithLocationMap pdfXObjectMap, String format, String destination, String imagePrefix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, IOException, PDFUnableToCompleteOperationException {
        ASName key = (ASName)o;
        PDFXObjectImageWithLocation imageWithLocation = pdfXObjectMap.get(key);
        if (imageWithLocation == null) {
            return null;
        }
        PDFXObjectImage xImage = imageWithLocation.getXImage();
        if (format == null) {
            int predict = xImage.getPredictor();
            switch (predict) {
                case 1: {
                    format = "jpg";
                    break;
                }
                case 2: {
                    format = "tiff";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    format = "png";
                    break;
                }
                default: {
                    format = "jpg";
                }
            }
        }
        ByteArrayByteWriter babw = new ByteArrayByteWriter();
        BufferedImageWrapper bImage = ImageManager.toBufferedImage((PDFXObjectImage)xImage, (ByteWriter)babw);
        this.saveImageToOutputFolder(bImage, key.asString(), destination, imagePrefix, format);
        bImage.close();
        return format;
    }

    private void saveImageToOutputFolder(BufferedImageWrapper image, String name, String destination, String imagePrefix, String format) throws IOException {
        BufferedImage bImage = image.getBufferedImage();
        File imageFile = VFSFileFactory.getFileObject((File)VFSFileFactory.getFileObject((String)destination), (String)(imagePrefix + name + "." + format));
        if (imageFile.exists()) {
            imageFile.delete();
        }
        imageFile.getParentFile().mkdirs();
        imageFile.createNewFile();
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = null;
        while (writers.hasNext() && !(writer = writers.next()).getClass().getName().startsWith("com.sun.imageio")) {
        }
        if (writer == null) {
            throw new PDFDocException();
        }
        OutputStream outputStream = VFSFileFactory.getOutputStream((File)imageFile);
        ImageOutputStream stream = ImageIO.createImageOutputStream(outputStream);
        writer.setOutput(stream);
        writer.write(bImage);
        stream.flush();
        writer.dispose();
        stream.close();
        outputStream.close();
    }

    public final void extractImages(final Object source, final String password, final String destination, final String imagePrefix, final String format, final String pages, final int scale, final boolean transparent, final boolean isHighResolution, final boolean hiRes, final int hScale, final int hLength, final int hBreadth, final boolean overridePage, final int jpgFlag, final boolean compressTiffs, final boolean stopOnError) throws PDFDocException {
        if (System.getSecurityManager() == null) {
            this._extractImages(source, password, destination, imagePrefix, format, pages, scale, transparent, isHighResolution, hiRes, hScale, hLength, hBreadth, overridePage, jpgFlag, compressTiffs, stopOnError);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PDFDocException {
                        PDFDocHandler.this._extractImages(source, password, destination, imagePrefix, format, pages, scale, transparent, isHighResolution, hiRes, hScale, hLength, hBreadth, overridePage, jpgFlag, compressTiffs, stopOnError);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (PDFDocException)e.getException();
            }
        }
    }

    private void _extractImages(Object source, String password, String destination, String imagePrefix, String format, String pages, int scale, boolean transparent, boolean isHighResolution, boolean hiRes, int hScale, int hLength, int hBreadth, boolean overridePage, int jpgFlag, boolean compressTiffs, boolean stopOnError) throws PDFDocException {
        block17: {
            File outputDirFile = VFSFileFactory.getFileObject((String)destination);
            File imageFile = null;
            try {
                boolean imgAsHiRes = false;
                HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                map.put(JPedalSettings.IGNORE_FORMS_ON_PRINT, new int[]{1061176672, 607471684});
                if (hScale > 0) {
                    map.put(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING, new Integer(100));
                    imgAsHiRes = true;
                }
                if (hLength > 0) {
                    imgAsHiRes = true;
                    map.put(JPedalSettings.EXTRACT_AT_PAGE_SIZE, new String[]{String.valueOf(hLength), String.valueOf(hBreadth)});
                }
                if (overridePage) {
                    map.put(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE, Boolean.FALSE);
                    imgAsHiRes = true;
                } else {
                    map.put(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE, Boolean.TRUE);
                }
                PdfDecoderServer decode_pdf = new PdfDecoderServer(true);
                PdfDecoder.modifyJPedalParameters(map);
                File srcPdfFile = null;
                if (source instanceof byte[]) {
                    this._extractSinglePDFImages(password, source, pages, outputDirFile, imagePrefix, format, imgAsHiRes, transparent, scale, compressTiffs, jpgFlag, isHighResolution, null, (PdfDecoderInt)decode_pdf);
                    break block17;
                }
                if (source instanceof String) {
                    srcPdfFile = VFSFileFactory.getFileObject((String)((String)source));
                    if (srcPdfFile.isFile()) {
                        this._extractSinglePDFImages(password, srcPdfFile.getPath(), pages, outputDirFile, imagePrefix, format, imgAsHiRes, transparent, scale, compressTiffs, jpgFlag, isHighResolution, null, (PdfDecoderInt)decode_pdf);
                    } else {
                        String[] files;
                        for (String str : files = srcPdfFile.list()) {
                            if (!str.toLowerCase().endsWith(".pdf")) continue;
                            try {
                                File listFile = VFSFileFactory.getFileObject((File)srcPdfFile, (String)str);
                                this._extractSinglePDFImages(password, listFile.getPath(), pages, outputDirFile, imagePrefix, format, imgAsHiRes, transparent, scale, compressTiffs, jpgFlag, isHighResolution, listFile, (PdfDecoderInt)decode_pdf);
                            }
                            catch (Exception e) {
                                if (!stopOnError) continue;
                                throw e;
                            }
                        }
                    }
                    break block17;
                }
                throw new PDFDocException();
            }
            catch (FileNotFoundException fne) {
                if (imageFile != null && DirFileUtils.isReadOnly(imageFile)) {
                    throw new PDFException.DirFileIsReadOnlyException(imageFile.getAbsolutePath(), "THUMBNAIL", "image name");
                }
                if (imageFile != null && !imageFile.canWrite()) {
                    throw new PDFException.PDFNoDirectoryException(imageFile.getAbsolutePath());
                }
                throw new PDFDocException((Throwable)fne);
            }
            catch (PDFDocException docEx) {
                throw docEx;
            }
            catch (Exception jpedalEx) {
                throw new PDFDocException((Throwable)jpedalEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _extractSinglePDFImages(String password, Object source, String pages, File outputDirFile, String imagePrefix, String format, boolean imgAsHiRes, boolean transparent, int scale, boolean compressTiffs, int jpgFlag, boolean isHighResolution, File fileName, PdfDecoderInt decode_pdf) throws PdfException, IOException {
        FileOutputStream os = null;
        try {
            if (source instanceof byte[]) {
                decode_pdf.openPdfArray((byte[])source);
            } else if (source instanceof String) {
                decode_pdf.openPdfFile((String)source);
            }
            decode_pdf.setExtractionMode(0, 1.33f);
            JPedalFontRegistry.init((Object)decode_pdf);
            if (password != null) {
                decode_pdf.setEncryptionPassword(password);
            }
            if (!(!decode_pdf.isEncrypted() || decode_pdf.isFileViewable() && decode_pdf.isExtractionAllowed())) {
                throw new PDFException.PDFUnAuthorisedOperationException("THUMBNAIL");
            }
            int pageCount = decode_pdf.getPageCount();
            int[] docPageArray = new int[pageCount];
            int pageCountToThumbnail = this.getPages(pages, docPageArray);
            for (int idx = 0; idx < pageCountToThumbnail; ++idx) {
                BufferedImage imageToSave;
                int page = docPageArray[idx];
                if (page == 0 || page > pageCount) {
                    throw new PDFException.PDFDeleteInvalidPageException("THUMBNAIL", pages, null);
                }
                String prefix = fileName == null ? imagePrefix : imagePrefix + fileName.getName().substring(0, fileName.getName().length() - 4);
                File imageFile = VFSFileFactory.getFileObject((File)outputDirFile, (String)(prefix + "_page_" + page + "." + format));
                if (imgAsHiRes) {
                    imageToSave = decode_pdf.getPageAsHiRes(page, transparent);
                } else if (transparent) {
                    imageToSave = decode_pdf.getPageAsTransparentImage(page);
                    if (format.toLowerCase().startsWith("jp")) {
                        BufferedImage rawVersion = imageToSave;
                        int w = rawVersion.getWidth();
                        int h = rawVersion.getHeight();
                        imageToSave = new BufferedImage(w, h, 1);
                        Graphics2D g2 = imageToSave.createGraphics();
                        g2.setPaint(Color.WHITE);
                        g2.fillRect(0, 0, w, h);
                        g2.drawImage((Image)rawVersion, 0, 0, null);
                    }
                } else {
                    imageToSave = decode_pdf.getPageAsImage(page);
                }
                boolean failed = false;
                if (imageToSave != null) {
                    boolean isGrayOnly;
                    Iterator colorspacesUsed = decode_pdf.getPageInfo(1);
                    boolean bl = isGrayOnly = colorspacesUsed != null;
                    while (colorspacesUsed != null && colorspacesUsed.hasNext()) {
                        int nextID = (Integer)colorspacesUsed.next();
                        if (nextID == 1568372915 || nextID == 391471749) continue;
                        isGrayOnly = false;
                    }
                    if (isGrayOnly) {
                        BufferedImage image_to_save2 = new BufferedImage(imageToSave.getWidth(), imageToSave.getHeight(), 10);
                        image_to_save2.getGraphics().drawImage(imageToSave, 0, 0, null);
                        imageToSave = image_to_save2;
                    }
                    if (scale != 100) {
                        int newWidth = imageToSave.getWidth() * scale / 100;
                        Image scaledImage = imageToSave.getScaledInstance(newWidth, -1, 4);
                        imageToSave = format.toLowerCase().startsWith("jp") ? new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1) : new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                        Graphics2D g2 = imageToSave.createGraphics();
                        g2.drawImage(scaledImage, 0, 0, null);
                    }
                    if (compressTiffs) {
                        TIFFEncodeParam params = null;
                        params = new TIFFEncodeParam();
                        params.setCompression(32946);
                        os = new FileOutputStream(imageFile);
                        JAI.create((String)"encode", (RenderedImage)imageToSave, (Object)os, (Object)"TIFF", (Object)params);
                    } else if (jpgFlag > 0 && format.startsWith("jp")) {
                        os = new FileOutputStream(imageFile);
                        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
                        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
                        imageWriter.setOutput(ios);
                        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(imageToSave), null);
                        Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
                        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                        jfif.setAttribute("Xdensity", Integer.toString(jpgFlag));
                        jfif.setAttribute("Ydensity", Integer.toString(jpgFlag));
                        imageMetaData.setFromTree("javax_imageio_jpeg_image_1.0", tree);
                        imageWriter.write(imageMetaData, new IIOImage(imageToSave, null, null), null);
                        ios.close();
                        imageWriter.dispose();
                    } else {
                        this.saveImage(format, imageFile, imageToSave);
                    }
                }
                decode_pdf.flushObjectValues(true);
                if (imageToSave != null && !failed) continue;
                if (failed) {
                    if (DirFileUtils.isReadOnly((File)imageFile)) {
                        throw new PDFException.DirFileIsReadOnlyException(imageFile.getAbsolutePath(), "THUMBNAIL", "image name");
                    }
                    if (imageFile != null && !imageFile.canWrite()) {
                        throw new PDFException.PDFNoDirectoryException(imageFile.getAbsolutePath());
                    }
                }
                throw new PDFException.PDFExportImageException(fileName);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (decode_pdf != null) {
                decode_pdf.closePdfFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(String format, File imageFile, BufferedImage imageToSave) throws IOException {
        ImageInputStream stream = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = null;
            while (writers.hasNext() && !(writer = writers.next()).getClass().getName().startsWith("com.sun.imageio")) {
            }
            if (writer == null) {
                throw new PDFDocException();
            }
            stream = ImageIO.createImageOutputStream(imageFile);
            writer.setOutput(stream);
            writer.write(imageToSave);
            writer.dispose();
        }
        finally {
            if (stream != null) {
                try {
                    stream.flush();
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPDFObject(Object obj) {
        if (obj instanceof PDFDocWrapper) {
            return true;
        }
        boolean validPDF = false;
        if (obj instanceof byte[]) {
            PDFDocument pdfDocument = null;
            try {
                InputStreamByteReader byteReader = new InputStreamByteReader((InputStream)new ByteArrayInputStream((byte[])obj));
                pdfDocument = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFDocHandler.createCustomFilterOpenOptions());
                validPDF = true;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return validPDF;
    }

    public void setPropertiesFor508Compliance(PDFDocument pdfDocument, String language) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFViewerPreferences pref = pdfDocument.getViewerPreferences();
        if (pref == null) {
            pref = PDFViewerPreferences.newInstance((PDFDocument)pdfDocument);
            pdfDocument.setViewerPreferences(pref);
        }
        pref.setDisplayDocTitle(true);
        PDFCatalog cat = pdfDocument.requireCatalog();
        cat.setLang(language);
        PDFPageTree tempPages = pdfDocument.requirePages();
        for (PDFPage pdfPage : tempPages) {
            pdfPage.setTabOrder(PDFTabOrder.STRUCTURE);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        markingOperators = new HashSet(15);
        markingOperators.add(ASName.k_S);
        markingOperators.add(ASName.k_s);
        markingOperators.add(ASName.k_F);
        markingOperators.add(ASName.k_f);
        markingOperators.add(ASName.k_fStar);
        markingOperators.add(ASName.k_B);
        markingOperators.add(ASName.k_b);
        markingOperators.add(ASName.k_BStar);
        markingOperators.add(ASName.k_bStar);
        markingOperators.add(ASName.k_TJ);
        markingOperators.add(ASName.k_Tj);
        markingOperators.add(ASName.k_SingleQuote);
        markingOperators.add(ASName.k_DoubleQuote);
        markingOperators.add(ASName.k_sh);
        markingOperators.add(ASName.k_Do);
        matchSequence = new ASName[]{ASName.k_rg, ASName.k_m, ASName.k_l, ASName.k_l, ASName.k_l, ASName.k_l, ASName.k_h, ASName.k_f, ASName.k_rg};
    }
}

