/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.StringUtils;

public final class EnumValue
extends Attribute {
    private final EnumAttr mValue;
    private final int meAttr;
    private static final int[][] mAmbiguousTypes = new int[][]{{XFA.TYPETAG, -2145648640}, {XFA.TYPETAG, -2144796672}, {XFA.TYPETAG, -2144665600}, {XFA.TYPETAG, -2140930048}, {XFA.TYPETAG, -2141716480}, {XFA.OPERATIONTAG, -2140995584}, {XFA.OPERATIONTAG, -2145124352}, {XFA.OVERRIDETAG, -2144862208}, {XFA.OVERRIDETAG, 0x40040000}, {XFA.TOTAG, -2145517568}, {XFA.TOTAG, -2144927744}, {XFA.FORMATTAG, -2142502912}, {XFA.FORMATTAG, -2138112000}, {XFA.RELATIONTAG, -2144600064}, {XFA.RELATIONTAG, -2140209152}, {XFA.NAMETAG, 0x500000}, {XFA.NAMETAG, -2142175232}, {XFA.NAMETAG, -2142109696}, {XFA.NAMETAG, -2142044160}, {XFA.NAMETAG, 0x910000}, {XFA.NAMETAG, -2141978624}};
    private static final int[][] mConfigTypes = new int[][]{{XFA.ACCESSIBLECONTENTTAG, 0x40040000}, {XFA.ADDSILENTPRINTTAG, 0x40040000}, {XFA.ADDVIEWERPREFERENCESTAG, 0x40040000}, {XFA.ADJUSTDATATAG, 0x40040000}, {XFA.ATTRIBUTESTAG, 0x40030000}, {XFA.CHANGETAG, 0x40040000}, {XFA.COMPRESSLOGICALSTRUCTURETAG, 0x40040000}, {XFA.COMPRESSOBJECTSTREAMTAG, 0x40040000}, {XFA.CONFORMANCETAG, 1082261504}, {XFA.CONTENTCOPYTAG, 0x40040000}, {XFA.DESTINATIONTAG, 0x40410000}, {XFA.DOCUMENTASSEMBLYTAG, 0x40040000}, {XFA.DUPLEXOPTIONTAG, 1081409536}, {XFA.DYNAMICRENDERTAG, 0x40660000}, {XFA.EMBEDRENDEREDOUTPUTTAG, 0x40040000}, {XFA.EMBEDTAG, 0x40040000}, {XFA.ENABLETAG, 0x40040000}, {XFA.ENCRYPTIONLEVELTAG, 0x400A0000}, {XFA.ENCRYPTTAG, 0x40040000}, {XFA.FLIPLABELTAG, 0x40040000}, {XFA.FORMFIELDFILLINGTAG, 0x40040000}, {XFA.IFEMPTYTAG, 1075314688}, {XFA.INTERACTIVETAG, 0x40040000}, {XFA.INCREMENTALLOADTAG, 0x40470000}, {XFA.JOGTAG, 1081737216}, {XFA.LAYOUTTAG, 1079771136}, {XFA.LINEARIZEDTAG, 0x40040000}, {XFA.LOCKTAG, 0x40040000}, {XFA.MODETAG, 1075904512}, {XFA.OVERPRINTTAG, 1082327040}, {XFA.PAGINATIONTAG, 1081671680}, {XFA.PAGINATIONOVERRIDETAG, 1082589184}, {XFA.PLAINTEXTMETADATATAG, 0x40040000}, {XFA.PRESENCETAG, 1076494336}, {XFA.PRINTTAG, 0x40040000}, {XFA.RENDERPOLICYTAG, 1080557568}, {XFA.RUNSCRIPTSTAG, 1080754176}, {XFA.SCRIPTMODELTAG, 1076690944}, {XFA.SEVERITYTAG, 1076822016}, {XFA.SUBMITFORMATTAG, 1077346304}, {XFA.SUPPRESSBANNERTAG, 0x40040000}, {XFA.TAGGEDMODETAG, 1080688640}, {XFA.TAGGEDTAG, 0x40040000}, {XFA.THRESHOLDTAG, 0x40200000}, {XFA.TOTAG, -2144927744}, {XFA.TOTAG, -2145517568}, {XFA.TYPETAG, 0x4F0000}, {XFA.VALIDATETAG, 0x40040000}, {XFA.WHITESPACETAG, 1077870592}, {XFA.VALIDATIONMESSAGINGTAG, 0x40880000}, {XFA.PRINTSCALINGTAG, 1082785792}, {XFA.PICKTRAYBYPDFSIZETAG, 0x40040000}, {XFA.ADBE_JSDEBUGGERTAG, 0x40900000}, {XFA.ADBE_JSCONSOLETAG, 0x40900000}};
    private static final EnumValue[][] mAllEnumAttrs = new EnumValue[XFA.XFA_ATTR_COUNT][];
    private static final EnumValue[][] mAmbiguousAttrs = new EnumValue[mAmbiguousTypes.length][];
    private static final EnumValue[][] mConfigAttrs = new EnumValue[mConfigTypes.length][];

    private EnumValue(EnumType enumType, int eAttrTag, String NS, String localName, String qName, String value) {
        super(NS, localName, qName, value, false);
        this.mValue = EnumAttr.getEnum(enumType, this.getAttrValue());
        this.meAttr = eAttrTag;
    }

    public EnumAttr getAttr() {
        return this.mValue;
    }

    public int getInt() {
        return this.mValue.getInt();
    }

    public EnumType getType() {
        return this.mValue.getType();
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(null, null, null, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        if (internSymbols) {
            value = value.intern();
        }
        return EnumValue.getEnum(this.mValue.getType(), this.meAttr, value);
    }

    public int getAttrTag() {
        return this.meAttr;
    }

    private static EnumValue getEnum(EnumType enumType, int eAttrTag, String value) {
        EnumAttr a = EnumAttr.getEnum(enumType, value);
        return EnumValue.getEnum(eAttrTag, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EnumValue getEnum(int eAttrTag, EnumAttr value) {
        int offset;
        EnumValue v;
        EnumValue[][] enumValueArray;
        EnumValue[] vals;
        int index;
        EnumType enumType;
        block25: {
            int eType;
            block26: {
                block24: {
                    block23: {
                        enumType = value.getType();
                        eType = enumType.getInt();
                        index = -1;
                        vals = null;
                        if (!enumType.usedAmbiguously()) break block23;
                        break block24;
                    }
                    if (!enumType.usedElementarily()) break block25;
                    break block26;
                }
                for (index = 0; index < mAmbiguousTypes.length && (mAmbiguousTypes[index][0] != eAttrTag || mAmbiguousTypes[index][1] != eType); ++index) {
                }
                break block25;
            }
            for (index = 0; index < mConfigTypes.length && (mConfigTypes[index][0] != eAttrTag || mConfigTypes[index][1] != eType); ++index) {
            }
            if (index == mConfigTypes.length) {
                index = -1;
            }
        }
        if (index == -1) {
            assert (eAttrTag > XFA.XFA_ELEMENTS + 2);
            vals = mAllEnumAttrs[eAttrTag - (XFA.XFA_ELEMENTS + 2)];
            if (vals == null) {
                enumValueArray = mAllEnumAttrs;
                // MONITORENTER : mAllEnumAttrs
                vals = mAllEnumAttrs[eAttrTag - (XFA.XFA_ELEMENTS + 2)];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mAllEnumAttrs[eAttrTag - (XFA.XFA_ELEMENTS + 2)] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        } else if (enumType.usedAmbiguously()) {
            vals = mAmbiguousAttrs[index];
            if (vals == null) {
                enumValueArray = mAmbiguousAttrs;
                // MONITORENTER : mAmbiguousAttrs
                vals = mAmbiguousAttrs[index];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mAmbiguousAttrs[index] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        } else {
            vals = mConfigAttrs[index];
            if (vals == null) {
                enumValueArray = mConfigAttrs;
                // MONITORENTER : mConfigAttrs
                vals = mConfigAttrs[index];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mConfigAttrs[index] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        }
        if ((v = vals[offset = value.getInt() & 0xFFFF]) != null) return v;
        EnumValue[] enumValueArray2 = vals;
        // MONITORENTER : vals
        v = vals[offset];
        if (v == null) {
            String name = XFA.getString(eAttrTag);
            vals[offset] = v = new EnumValue(enumType, eAttrTag, null, name, name, value.toString());
        }
        // MONITOREXIT : enumValueArray2
        return v;
    }

    public static EnumValue getEnum(int eAttrTag, int value) {
        return EnumValue.getEnum(eAttrTag, EnumAttr.getEnum(value));
    }
}

