/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.document.listener.GroupDocumentListener;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.MetadataOptions;
import com.adobe.internal.pdftoolkit.services.xmp.PDFDictionaryMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.PDFDictionaryMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.PDFFontMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.PDFICCProfileMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.PDFImageMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.PDFPageMetadataImpl;
import com.adobe.internal.pdftoolkit.services.xmp.PDFType1FormMetadataImpl;
import com.adobe.internal.xmp.options.ParseOptions;

public final class XMPService {
    protected static final Object LISTENER_KEY = XMPServiceListener.class;
    public static final ParseOptions XMPCORE_PARSE_OPTIONS = new ParseOptions();

    private XMPService() {
    }

    private static XMPServiceListener getServiceListener(PDFDocument pdfDocument) {
        DocumentListenerRegistry registry = pdfDocument.getListenerRegistry();
        XMPServiceListener serviceListener = (XMPServiceListener)registry.getListener(LISTENER_KEY);
        if (serviceListener == null) {
            serviceListener = new XMPServiceListener(pdfDocument);
            registry.registerListener(LISTENER_KEY, serviceListener);
        }
        return serviceListener;
    }

    public static MetadataOptions getDefaultOptions(PDFDocument pdfDocument) {
        return XMPService.getServiceListener(pdfDocument).getDefaultOptions();
    }

    public static void setDefaultOoptions(PDFDocument pdfDocument, MetadataOptions options) {
        XMPService.getServiceListener(pdfDocument).setDefaultOptions(options);
    }

    public static DocumentMetadata getDocumentMetadata(PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        return XMPService.getDocumentMetadata(pdfDocument, null);
    }

    public static DocumentMetadata getDocumentMetadata(PDFDocument pdfDocument, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        DocumentMetadataImpl metadata = (DocumentMetadataImpl)serviceListener.getListener(DocumentMetadataImpl.LISTENER_KEY);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new DocumentMetadataImpl(serviceListener, pdfDocument, options);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    public static PDFDictionaryMetadata getPDFDictionaryMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        if (cosDictionary instanceof PDFCatalog) {
            return XMPService.getDocumentMetadata(cosDictionary.getPDFDocument(), options);
        }
        if (cosDictionary instanceof PDFPage) {
            return XMPService.getPDFPageMetadata(cosDictionary, options);
        }
        if (cosDictionary instanceof PDFFontFile) {
            return XMPService.getPDFFontMetadata(cosDictionary, options);
        }
        if (cosDictionary instanceof PDFXObjectForm) {
            return XMPService.getPDFType1FormMetadata(cosDictionary, options);
        }
        if (cosDictionary instanceof PDFICCProfile) {
            return XMPService.getPDFICCProfileMetadata(cosDictionary, options);
        }
        if (cosDictionary instanceof PDFXObjectImage) {
            return XMPService.getPDFImageMetadata(cosDictionary, options);
        }
        return null;
    }

    private static PDFDictionaryMetadata getPDFPageMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFCosDictionary key;
        PDFDocument pdfDocument = cosDictionary.getPDFDocument();
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        PDFDictionaryMetadataImpl metadata = (PDFDictionaryMetadataImpl)serviceListener.getListener(key = cosDictionary);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new PDFPageMetadataImpl(serviceListener, pdfDocument, options, cosDictionary);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    private static PDFDictionaryMetadata getPDFFontMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFCosDictionary key;
        PDFDocument pdfDocument = cosDictionary.getPDFDocument();
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        PDFDictionaryMetadataImpl metadata = (PDFDictionaryMetadataImpl)serviceListener.getListener(key = cosDictionary);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new PDFFontMetadataImpl(serviceListener, pdfDocument, options, cosDictionary);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    private static PDFDictionaryMetadata getPDFType1FormMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFCosDictionary key;
        PDFDocument pdfDocument = cosDictionary.getPDFDocument();
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        PDFType1FormMetadataImpl metadata = (PDFType1FormMetadataImpl)serviceListener.getListener(key = cosDictionary);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new PDFType1FormMetadataImpl(serviceListener, pdfDocument, options, cosDictionary);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    private static PDFDictionaryMetadata getPDFICCProfileMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFCosDictionary key;
        PDFDocument pdfDocument = cosDictionary.getPDFDocument();
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        PDFICCProfileMetadataImpl metadata = (PDFICCProfileMetadataImpl)serviceListener.getListener(key = cosDictionary);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new PDFICCProfileMetadataImpl(serviceListener, pdfDocument, options, cosDictionary);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    private static PDFDictionaryMetadata getPDFImageMetadata(PDFCosDictionary cosDictionary, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFCosDictionary key;
        PDFDocument pdfDocument = cosDictionary.getPDFDocument();
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        PDFImageMetadataImpl metadata = (PDFImageMetadataImpl)serviceListener.getListener(key = cosDictionary);
        if (metadata == null) {
            if (options == null) {
                options = serviceListener.getDefaultOptions();
            }
            metadata = new PDFImageMetadataImpl(serviceListener, pdfDocument, options, cosDictionary);
        } else if (options != null) {
            metadata.setOptions(options);
        }
        return metadata;
    }

    public static boolean releaseDocumentMetadata(PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        XMPServiceListener serviceListener = XMPService.getServiceListener(pdfDocument);
        DocumentListenerRegistry registry = pdfDocument.getListenerRegistry();
        return serviceListener.deregisterListener(DocumentMetadataImpl.LISTENER_KEY) && registry.deregisterListener(LISTENER_KEY);
    }

    @Deprecated
    public static void resetXMPSchemaRegistry() {
    }

    static {
        XMPCORE_PARSE_OPTIONS.setAcceptLatin1(false);
        XMPCORE_PARSE_OPTIONS.setFixControlChars(false);
        XMPCORE_PARSE_OPTIONS.setOmitNormalization(true);
    }

    protected static final class XMPServiceListener
    extends GroupDocumentListener {
        private MetadataOptions defaultOptions = MetadataOptions.MetadataOptionsBuilder.newInstance().build();

        protected XMPServiceListener(PDFDocument pdfDocument) {
            super(pdfDocument, LISTENER_KEY);
        }

        protected MetadataOptions getDefaultOptions() {
            return this.defaultOptions;
        }

        protected void setDefaultOptions(MetadataOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
        }
    }
}

