/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationLine
extends XFDFAnnotation {
    static final String ATTR_START = "start";
    static final String ATTR_END = "end";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";
    static final String ELEM_LINE = "line";
    static final String ELEM_LEADEREXTEND = "leaderExtend";
    static final String ELEM_LEADERLENGTH = "leaderLength";
    static final String ELEM_LEADERLENGTHOFFSET = "leaderLengthOffset";
    static final String ATTR_CAPTIONH = "caption-offset-h";
    static final String ATTR_CAPTIONV = "caption-offset-v";
    static final String ATTR_CAPTIONSTYLE = "caption-style";
    static final String ATTR_MEASURE = "measure";
    static final String ATTR_TYPE = "type";
    static final String ATTR_SUBTYPE = "subtype";

    XFDFAnnotationLine(PDFAnnotationLine pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationLine(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        double[] co;
        Object[] lineCoords;
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, false);
        this.addCaptionXFDFAttribute(annotsAtts);
        if (((PDFAnnotationLine)this.pdfAnnot).hasLineCoords() && (lineCoords = ((PDFAnnotationLine)this.pdfAnnot).getLineCoords()).length == 4) {
            StringBuilder coordStr = new StringBuilder();
            coordStr.append(lineCoords[0]);
            coordStr.append(",");
            coordStr.append(lineCoords[1]);
            annotsAtts.addAttribute("", ATTR_START, ATTR_START, "CDATA", coordStr.toString());
            coordStr.setLength(0);
            coordStr.append(lineCoords[2]);
            coordStr.append(",");
            coordStr.append(lineCoords[3]);
            annotsAtts.addAttribute("", ATTR_END, ATTR_END, "CDATA", coordStr.toString());
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasLineEnds() && (lineCoords = (Object[])((PDFAnnotationLine)this.pdfAnnot).getLineEnds()).length == 2) {
            annotsAtts.addAttribute("", ATTR_HEAD, ATTR_HEAD, "CDATA", lineCoords[0].toString());
            annotsAtts.addAttribute("", ATTR_TAIL, ATTR_TAIL, "CDATA", lineCoords[1].toString());
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasLeaderLineExtend()) {
            double lineExtend = ((PDFAnnotationLine)this.pdfAnnot).getLeaderLineExtend();
            annotsAtts.addAttribute("", ELEM_LEADEREXTEND, ELEM_LEADEREXTEND, "CDATA", String.valueOf(lineExtend));
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasLeaderLineOffset()) {
            double lineOffset = ((PDFAnnotationLine)this.pdfAnnot).getLeaderLineOffset();
            annotsAtts.addAttribute("", ELEM_LEADERLENGTHOFFSET, ELEM_LEADERLENGTHOFFSET, "CDATA", String.valueOf(lineOffset));
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasLeaderLine()) {
            double leaderLength = ((PDFAnnotationLine)this.pdfAnnot).getLeaderLength();
            annotsAtts.addAttribute("", ELEM_LEADERLENGTH, ELEM_LEADERLENGTH, "CDATA", String.valueOf(leaderLength));
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasCaptionOffset() && (co = ((PDFAnnotationLine)this.pdfAnnot).getCaptionOffset()).length == 2) {
            annotsAtts.addAttribute("", ATTR_CAPTIONH, ATTR_CAPTIONH, "CDATA", String.valueOf(co[0]));
            annotsAtts.addAttribute("", ATTR_CAPTIONV, ATTR_CAPTIONV, "CDATA", String.valueOf(co[1]));
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasCaptionStyle()) {
            String captionStyle = ((PDFAnnotationLine)this.pdfAnnot).getCaptionStyle();
            annotsAtts.addAttribute("", ATTR_CAPTIONSTYLE, ATTR_CAPTIONSTYLE, "CDATA", captionStyle);
        }
        this.addInteriorColorXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_LINE, ELEM_LINE, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_LINE, ELEM_LINE);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    void addMeasureXFDFAttributes(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMeasure measure = ((PDFAnnotationLine)this.pdfAnnot).getMeasure();
        if (measure != null) {
            if (measure.hasType()) {
                attributes.addAttribute("", ATTR_TYPE, ATTR_TYPE, "CDATA", ATTR_MEASURE);
            }
            if (measure.hasSubType()) {
                attributes.addAttribute("", ATTR_SUBTYPE, ATTR_SUBTYPE, "CDATA", measure.getSubType().toString());
            }
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationLine lineAnnot = PDFAnnotationLine.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(lineAnnot, elemAttrs);
        if (gotPage >= 0) {
            int rot;
            this.fillMarkupAttributes(lineAnnot, elemAttrs);
            this.fillBorderStyleAttributes(lineAnnot, elemAttrs);
            this.fillInteriorColorAttribute(lineAnnot, elemAttrs);
            this.fillCaptionAttribute(lineAnnot, elemAttrs);
            this.fillIntentAttribute(lineAnnot, elemAttrs);
            int attrInd = XFDFAnnotationLine.findAttribute(ATTR_START, elemAttrs);
            if (attrInd >= 0) {
                ArrayList<Double> endCoord;
                ArrayList<Double> coord = new ArrayList<Double>(4);
                ArrayList<Double> startCoord = PDFUtil.parseNumbers(elemAttrs.getValue(attrInd), ",");
                if (startCoord.size() == 2) {
                    coord.add(startCoord.get(0));
                    coord.add(startCoord.get(1));
                }
                if ((attrInd = XFDFAnnotationLine.findAttribute(ATTR_END, elemAttrs)) >= 0 && (endCoord = PDFUtil.parseNumbers(elemAttrs.getValue(attrInd), ",")).size() == 2) {
                    coord.add(endCoord.get(0));
                    coord.add(endCoord.get(1));
                    lineAnnot.setLineCoords(coord);
                }
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ATTR_HEAD, elemAttrs)) >= 0) {
                PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[2];
                lineEnds[0] = PDFAnnotationLine.LineEnding.getInstance(elemAttrs.getValue(attrInd));
                attrInd = XFDFAnnotationLine.findAttribute(ATTR_TAIL, elemAttrs);
                if (attrInd >= 0) {
                    lineEnds[1] = PDFAnnotationLine.LineEnding.getInstance(elemAttrs.getValue(attrInd));
                    lineAnnot.setLineEnds(lineEnds);
                }
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ATTR_CAPTIONH, elemAttrs)) >= 0) {
                double[] co = new double[2];
                co[0] = new Double(elemAttrs.getValue(attrInd));
                attrInd = XFDFAnnotationLine.findAttribute(ATTR_CAPTIONV, elemAttrs);
                if (attrInd >= 0) {
                    co[1] = new Double(elemAttrs.getValue(attrInd));
                    lineAnnot.setCaptionOffset(co);
                }
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ELEM_LEADEREXTEND, elemAttrs)) >= 0) {
                double leaderExtend = Double.parseDouble(elemAttrs.getValue(attrInd));
                lineAnnot.setLeaderLineExtend(leaderExtend);
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ELEM_LEADERLENGTH, elemAttrs)) >= 0) {
                double leaderExtend = Double.parseDouble(elemAttrs.getValue(attrInd));
                lineAnnot.setLeaderLength(leaderExtend);
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ELEM_LEADERLENGTHOFFSET, elemAttrs)) >= 0) {
                double leaderExtend = Double.parseDouble(elemAttrs.getValue(attrInd));
                lineAnnot.setLeaderLineOffset(leaderExtend);
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ATTR_CAPTIONSTYLE, elemAttrs)) >= 0) {
                String captionStyle = elemAttrs.getValue(attrInd);
                lineAnnot.setCaptionStyle(captionStyle);
            }
            if ((attrInd = XFDFAnnotationLine.findAttribute(ATTR_CAPTIONSTYLE, elemAttrs)) >= 0) {
                String captionStyle = elemAttrs.getValue(attrInd);
                lineAnnot.setCaptionStyle(captionStyle);
            }
            if ((rot = XFDFAnnotationLine.findAttribute("rotation", elemAttrs)) != -1) {
                lineAnnot.setRotation(Integer.parseInt(elemAttrs.getValue(rot)));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    lineAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(lineAnnot, gotPage)) {
                this.pdfAnnot = lineAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

