/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Point;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import java.awt.geom.GeneralPath;

class GlyphOutlineConsumer
implements OutlineConsumer {
    private GeneralPath glyphPath = new GeneralPath();
    private Matrix matrix;

    GlyphOutlineConsumer(ASMatrix matrix) {
        this.matrix = new Matrix(matrix.geta(), matrix.getb(), matrix.getc(), matrix.getd(), matrix.getx(), matrix.gety());
    }

    GeneralPath getGlyphPath() {
        return this.glyphPath;
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3) {
        Point p2 = new Point(x2, y2);
        this.matrix.applyToPoint(p2);
        Point p3 = new Point(x3, y3);
        this.matrix.applyToPoint(p3);
        this.glyphPath.quadTo((float)p2.x, (float)p2.y, (float)p3.x, (float)p3.y);
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        Point p2 = new Point(x2, y2);
        this.matrix.applyToPoint(p2);
        Point p3 = new Point(x3, y3);
        this.matrix.applyToPoint(p3);
        Point p4 = new Point(x4, y4);
        this.matrix.applyToPoint(p4);
        this.glyphPath.curveTo((float)p2.x, (float)p2.y, (float)p3.x, (float)p3.y, (float)p4.x, (float)p4.y);
    }

    @Override
    public void endchar() {
    }

    @Override
    public void lineto(double x, double y) {
        Point p = new Point(x, y);
        this.matrix.applyToPoint(p);
        this.glyphPath.lineTo((float)p.x, (float)p.y);
    }

    @Override
    public void moveto(double x, double y) {
        Point p = new Point(x, y);
        this.matrix.applyToPoint(p);
        this.glyphPath.moveTo((float)p.x, (float)p.y);
    }

    @Override
    public void setMatrix(Matrix newMatrix) {
        this.matrix = newMatrix.isInverse(this.matrix) ? Matrix.IDENTITY_MATRIX : newMatrix.multiply(this.matrix);
    }
}

