/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import java.util.HashSet;

class StructureTypeNameCollector {
    private PDFStructureRoot structureRoot;

    public StructureTypeNameCollector(PDFStructureRoot structureRoot) {
        this.structureRoot = structureRoot;
    }

    HashSet<ASName> getStuctureTypeNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<ASName> structTypes = new HashSet<ASName>();
        PDFStructureContentInterface rootContent = this.structureRoot.getContent();
        if (rootContent != null) {
            this.collectStructureNameTypes(rootContent, structTypes);
        }
        return structTypes;
    }

    private void collectStructureNameTypes(PDFStructureContentInterface content, HashSet<ASName> structTypes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (content == null) {
            return;
        }
        if (content instanceof PDFStructureElement) {
            ASName nameType = ((PDFStructureElement)content).getStructureNameType();
            structTypes.add(nameType);
            this.collectStructureNameTypes(((PDFStructureElement)content).getContent(), structTypes);
        } else if (content instanceof PDFStructureContentArray) {
            PDFStructureContentIterator iter = content.contentIterator();
            while (iter.hasNext()) {
                PDFStructureContentInterface curContent = iter.next();
                this.collectStructureNameTypes(curContent, structTypes);
            }
        }
    }
}

