/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPField;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPValueType;
import java.util.HashMap;
import java.util.List;

abstract class XMPMultipleFieldType
implements XMPValueType {
    XMPMultipleFieldType() {
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m) {
        if (m.getNodes() == null) {
            return true;
        }
        if (m.getNodes().size() == 1 && m.getNodes().get(0).getName() != null && m.getNodes().get(0).getName().equalsIgnoreCase("description") && m.getNodes().get(0).getPrefix() != null && m.getNodes().get(0).getPrefix().equalsIgnoreCase("rdf")) {
            return this.isValid(m.getNodes().get(0));
        }
        HashMap<String, XMPField> fieldsMap = this.getFieldsMap();
        for (MetadataUsageTreeNode node : m.getNodes()) {
            XMPField field = fieldsMap.get(node.getName());
            if (field != null) {
                String nsURI = this.getNameSpaceURI();
                if (nsURI != null && nsURI.length() > 0 && !nsURI.equals(node.getNameSpaceURI())) {
                    return false;
                }
                XMPValueType val = field.getValueType();
                if (field.getArrayType() != node.getArrayType()) {
                    return false;
                }
                if (node.isNodeArray()) {
                    List<MetadataUsageTreeNode> fieldNodes = node.getNodes();
                    if (fieldNodes == null) {
                        return false;
                    }
                    for (MetadataUsageTreeNode fieldNode : fieldNodes) {
                        if (val.isValid(fieldNode)) continue;
                        return false;
                    }
                    continue;
                }
                if (val.isValid(node)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        return this.isValid(m);
    }

    abstract HashMap<String, XMPField> getFieldsMap();

    protected String getNameSpaceURI() {
        return "";
    }
}

