/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFValueContainer;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetExtGState;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAExtGStateErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SharedConstraints;
import java.util.Iterator;
import java.util.Set;

class ExtGStateProcessor {
    ExtGStateProcessor() {
    }

    static boolean process(PDFExtGStateMap extGStateMap, Set referencedExtGStateNames, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (extGStateMap == null || extGStateMap.isEmpty()) {
            return true;
        }
        if (validationOptions.validateUnusedResourcesEnabled()) {
            for (ASName name : extGStateMap.keySet()) {
                PDFExtGState extGState;
                if (ExtGStateProcessor.process(name, extGState = (PDFExtGState)extGStateMap.get(name), conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                return false;
            }
        } else {
            if (referencedExtGStateNames == null || referencedExtGStateNames.isEmpty()) {
                return true;
            }
            for (ASName name : referencedExtGStateNames) {
                PDFExtGState extGState;
                if (ExtGStateProcessor.process(name, extGState = (PDFExtGState)extGStateMap.get(name), conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean process(ASName name, PDFExtGState extGState, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (extGState == null) {
            return true;
        }
        PDFAErrorSetExtGState errorCodes = new PDFAErrorSetExtGState();
        try {
            double opacity;
            ASName ri;
            if (extGState.getCosDictionary().containsKey(ASName.k_TR)) {
                if (conversionHandler != null && conversionOptions.getRemoveTransferFunctions()) {
                    extGState.removeValue(ASName.k_TR);
                    if (!conversionHandler.transferFunctionRemovedOrReset(extGState, ASName.k_TR)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(PDFAExtGStateErrorCode.transferFunctionNotAllowed);
                }
            }
            if (extGState.getCosDictionary().containsKey(ASName.k_TR2)) {
                CosObject tr2 = extGState.getDictionaryCosObjectValue(ASName.k_TR2);
                if (tr2.getType() == 3) {
                    ASName tr2Value = extGState.getDictionaryNameValue(ASName.k_TR2);
                    if (!tr2Value.equals(ASName.k_Default)) {
                        if (conversionHandler != null && conversionOptions.getRemoveTransferFunctions()) {
                            extGState.removeValue(ASName.k_TR2);
                            if (!conversionHandler.transferFunctionRemovedOrReset(extGState, ASName.k_TR2)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAExtGStateErrorCode.transferFunction2ValueNotAllowed);
                        }
                    }
                } else {
                    errorCodes.addErrorCode(PDFAExtGStateErrorCode.transferFunction2ValueNotAllowed);
                }
            }
            if (extGState.hasRenderingIntent() && !SharedConstraints.allowedRenderingIntents.contains(ri = extGState.getRenderingIntent())) {
                if (conversionHandler != null && conversionOptions.getOverrideRenderingIntent() != null) {
                    PDFRenderingIntent newIntent = conversionOptions.getOverrideRenderingIntent();
                    extGState.setRenderingIntent(newIntent);
                    if (!conversionHandler.renderingIntentOverridden(ri, newIntent.getValue())) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(PDFAExtGStateErrorCode.renderingIntentValueNotAllowed);
                }
            }
            if (extGState.hasSoftMask()) {
                CosObject cosSMask = extGState.getCosDictionary().get(ASName.k_SMask);
                if (cosSMask.getType() == 3) {
                    ASName smask = ((CosName)cosSMask).nameValue();
                    if (!smask.equals(ASName.k_None)) {
                        errorCodes.addErrorCode(PDFAExtGStateErrorCode.softMaskValueNotAllowed);
                    }
                } else {
                    errorCodes.addErrorCode(PDFAExtGStateErrorCode.softMaskValueNotAllowed);
                }
            }
            if (extGState.hasBlendMode()) {
                CosObject obj = extGState.getCosDictionary().get(ASName.k_BM);
                if (obj.getType() == 3) {
                    ASName bm = obj.nameValue();
                    if (bm != ASName.k_Normal && bm != ASName.create("Compatible")) {
                        errorCodes.addErrorCode(PDFAExtGStateErrorCode.blendModeNotAllowed);
                    }
                } else if (obj.getType() == 5) {
                    CosArray array = (CosArray)obj;
                    Iterator<CosObject> iter = array.iterator();
                    while (iter.hasNext()) {
                        ASName bm = (ASName)((Object)iter.next());
                        if (bm == ASName.k_Normal || bm == ASName.create("Compatible")) continue;
                        errorCodes.addErrorCode(PDFAExtGStateErrorCode.blendModeNotAllowed);
                        break;
                    }
                } else {
                    errorCodes.addErrorCode(PDFAExtGStateErrorCode.blendModeTypeInvalid);
                }
            }
            if (extGState.hasOpacityStroke() && (opacity = extGState.getOpacityStroke()) != 1.0) {
                errorCodes.addErrorCode(PDFAExtGStateErrorCode.strokeOpacityValueNotAllowed);
            }
            if (extGState.hasOpacityFill() && (opacity = extGState.getOpacityFill()) != 1.0) {
                errorCodes.addErrorCode(PDFAExtGStateErrorCode.fillOpacityValueNotAllowed);
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAExtGStateErrorCode.pdfGeneralFailure);
        }
        return !errorCodes.hasErrors() || validationHandler.extGStateError(extGState, errorCodes);
    }

    static boolean hasTransparency(PDFExtGStateMap extGStateMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        for (ASName name : extGStateMap.keySet()) {
            PDFExtGState extGState = (PDFExtGState)extGStateMap.get(name);
            if (extGState == null || !ExtGStateProcessor.hasTransparency(extGState)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTransparency(PDFExtGState extGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double opacity;
        ASName smaskName;
        PDFValueContainer<PDFValueContainer.Type, Object> cosSMask;
        if (extGState.hasSoftMask() && ((cosSMask = extGState.getSoftMask()).getType() == PDFValueContainer.Type.Name ? (smaskName = (ASName)cosSMask.getValue()) != null && !smaskName.equals(ASName.k_None) : cosSMask.getType() == PDFValueContainer.Type.SoftMask)) {
            return true;
        }
        if (extGState.hasBlendMode()) {
            CosObject obj = extGState.getCosDictionary().get(ASName.k_BM);
            if (obj.getType() == 3) {
                ASName bm = obj.nameValue();
                if (bm != ASName.k_Normal && bm != ASName.create("Compatible")) {
                    return true;
                }
            } else if (obj.getType() == 5) {
                CosArray array = (CosArray)obj;
                Iterator<CosObject> iter = array.iterator();
                while (iter.hasNext()) {
                    ASName bm = (ASName)((Object)iter.next());
                    if (bm == ASName.k_Normal || bm == ASName.create("Compatible")) continue;
                    return true;
                }
            }
        }
        if (extGState.hasOpacityStroke() && (opacity = extGState.getOpacityStroke()) != 1.0) {
            return true;
        }
        return extGState.hasOpacityFill() && (opacity = extGState.getOpacityFill()) != 1.0;
    }
}

