/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TrueTypeCmapSelector;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type0FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type1FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReferencedFontInfoProcessor {
    ReferencedFontInfoProcessor() {
    }

    static HashSet<Integer> getReferencedCharCodes(PDFFont font, List showStringList) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null || showStringList == null) {
            return null;
        }
        HashSet<Integer> referencedCharCodes = new HashSet<Integer>();
        for (ASString showString : showStringList) {
            if (showString == null) continue;
            List charCodes = font.getCharCodes(showString.getBytes(), false);
            for (List charCodeInfo : charCodes) {
                byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                if (charCodeBytes == null) continue;
                int charCode = 0;
                for (int i = 0; i < charCodeBytes.length; ++i) {
                    if (i > 0) {
                        charCode <<= 8;
                    }
                    charCode |= charCodeBytes[i] & 0xFF;
                }
                Integer charCodeInt = charCode;
                if (referencedCharCodes.contains(charCodeInt)) continue;
                referencedCharCodes.add(charCodeInt);
            }
        }
        return referencedCharCodes;
    }

    static PDFAErrorCode getReferencedCPsPostNames(PDFFontSimple font, UnembeddedFontInfo ufInfo, Set<Integer> codePoints, Set postNames) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null || ufInfo == null) {
            return PDFAFontErrorCode.fontEmbeddingFailure;
        }
        try {
            Font afeFont = font.getAFEFont();
            if (afeFont == null) {
                return PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet;
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return PDFAFontErrorCode.fontDataCorrupt;
            }
            FontData fontData = font.getAFEFontData();
            if (fontData == null) {
                return PDFAFontErrorCode.fontDataCorrupt;
            }
            PDFFontDescriptor oldFontDesc = font.getFontDescriptor();
            boolean isSymbolic = oldFontDesc != null ? (oldFontDesc.getFlags() & 4) != 0 : false;
            int platformID = -1;
            int platformSpecificID = -1;
            if (fontData instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() == null) {
                Set<Integer> charCodeSet;
                OpenTypeFont otFont = (OpenTypeFont)fontData;
                Cmap cmapTable = otFont.cmap;
                if (cmapTable != null) {
                    TrueTypeCmapSelector selector = new TrueTypeCmapSelector();
                    cmapTable.enumerateCmaps(selector);
                    if (isSymbolic && selector.threeZeroExists()) {
                        platformID = 3;
                        platformSpecificID = 0;
                    } else if (!isSymbolic && selector.threeOneExists()) {
                        platformID = 3;
                        platformSpecificID = 1;
                    } else if (selector.oneZeroExists()) {
                        platformID = 1;
                        platformSpecificID = 0;
                    } else if (selector.getCmapCount() > 0) {
                        platformID = selector.getfirstPlatformID();
                        platformSpecificID = selector.getfirstPlatformSpecificID();
                    } else if (isSymbolic) {
                        ufInfo.setCharCodes(null);
                        return PDFAFontErrorCode.fontEmbeddingFailure;
                    }
                    ufInfo.setPlatformID(platformID);
                    ufInfo.setPlatformSpecificID(platformSpecificID);
                }
                if ((charCodeSet = ufInfo.getCharCodes()) == null) {
                    return PDFAFontErrorCode.fontEmbeddingFailure;
                }
                Iterator<Integer> iter = charCodeSet.iterator();
                PDFSimpleFontEncoding encoding = font.getEncoding();
                while (iter.hasNext()) {
                    Integer charCodeInt = iter.next();
                    int charCode = charCodeInt;
                    int cp = font.charCode2CodePoint(charCode);
                    if (cp != 0) {
                        codePoints.add(cp);
                        continue;
                    }
                    if (isSymbolic) {
                        ufInfo.setCharCodes(null);
                        return PDFAFontErrorCode.fontEmbeddingFailure;
                    }
                    if (encoding == null) continue;
                    String glyphName = encoding.getGlyphName(charCode);
                    postNames.add(glyphName);
                }
            }
        }
        catch (FontEngineException e) {
            return PDFAFontErrorCode.fontDataCorrupt;
        }
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFAErrorCode getReferencedCharNames(PDFFontSimple font, UnembeddedFontInfo ufInfo, Set glyphNames) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null || ufInfo == null) {
            return PDFAFontErrorCode.fontEmbeddingFailure;
        }
        Set<Integer> charCodeSet = ufInfo.getCharCodes();
        if (charCodeSet == null) {
            return PDFAFontErrorCode.fontEmbeddingFailure;
        }
        Iterator<Integer> iter = charCodeSet.iterator();
        LinkedHashMap<Integer, String> charNamesMap = new LinkedHashMap<Integer, String>();
        while (iter.hasNext()) {
            int gid;
            Integer charCodeInt = iter.next();
            int charCode = charCodeInt;
            String glyphName = null;
            try {
                glyphName = font.charCode2glyphName(charCode);
            }
            catch (PDFFontException e) {
                return PDFAFontErrorCode.fontEmbeddingFailure;
            }
            if (glyphName == null || glyphName.equals(".notdef")) {
                return PDFAFontErrorCode.fontEmbeddingFailedGlyphError;
            }
            FontData fontData = font.getAFEFontData();
            if (fontData != null && fontData instanceof Type1Font && (gid = ((Type1Font)fontData).charCode2gid(charCode)) <= 0) {
                return PDFAFontErrorCode.fontEmbeddingFailedGlyphError;
            }
            charNamesMap.put(charCodeInt, glyphName);
            if (glyphNames == null) continue;
            glyphNames.add(glyphName);
        }
        ufInfo.setCharNamesMap(charNamesMap);
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFAErrorCode getReferencedCIDsGIDs(PDFFontType0 font, UnembeddedFontInfo ufInfo, Map<Integer, int[]> cidGidMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null || ufInfo == null) {
            return PDFAFontErrorCode.fontEmbeddingFailure;
        }
        Set<Integer> charCodeSet = ufInfo.getCharCodes();
        if (charCodeSet == null || charCodeSet.isEmpty()) {
            return PDFAFontErrorCode.fontEmbeddingFailure;
        }
        Iterator<Integer> iter = charCodeSet.iterator();
        try {
            while (iter.hasNext()) {
                int[] cidgid = new int[2];
                Integer charCodeInt = iter.next();
                int charCode = charCodeInt;
                cidgid[0] = font.getEncoding().getCID(charCode);
                cidgid[1] = font.charCode2gid(charCode);
                if (cidGidMap.get(charCodeInt) != null) {
                    int[] existingCidGid = cidGidMap.get(charCodeInt);
                    if (existingCidGid[0] == cidgid[0] && existingCidGid[1] == cidgid[1]) continue;
                    return PDFAFontErrorCode.fontEmbeddingFailedGlyphError;
                }
                Set<Integer> mapValues = cidGidMap.keySet();
                Iterator<Integer> mapIter = mapValues.iterator();
                while (mapIter.hasNext()) {
                    int[] existingCidGid = cidGidMap.get(mapIter.next());
                    if (existingCidGid[0] != cidgid[0] || existingCidGid[1] == cidgid[1]) continue;
                    return PDFAFontErrorCode.fontEmbeddingFailedGlyphError;
                }
                cidGidMap.put(charCodeInt, cidgid);
            }
        }
        catch (PDFFontException e) {
            return PDFAFontErrorCode.fontDataCorrupt;
        }
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFAErrorSetFont getReferencedGlyphErrors(PDFFont pdffont, HashSet<Integer> referencedCharCodes, PDFAConversionHandler conversionHandler, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (referencedCharCodes == null || pdffont == null) {
            return null;
        }
        if (pdffont instanceof PDFFontType3) {
            return null;
        }
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        boolean widthMismatch = false;
        boolean missingGlyph = false;
        Font font = null;
        FontData fontData = null;
        try {
            font = pdffont.getAFEFont();
            if (font != null) {
                fontData = ((FontImpl)font).getFontData();
            }
        }
        catch (FontEngineException e3) {
            e3.printStackTrace();
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        catch (PDFIOException e3) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        if (font == null || fontData == null) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
            return errorCodes;
        }
        try {
            if (PDFFontUtils.isSubsetFont(pdffont)) {
                if (pdffont.getSubtype() == ASName.k_Type1) {
                    Type1FontProcessor.addReferencedCharsetErrors(referencedCharCodes, errorCodes, (PDFFontSimple)pdffont);
                    if (conversionHandler != null && FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCharSet) && FontProcessorUtils.embedCharSet((PDFFontSimple)pdffont, null)) {
                        if (!conversionHandler.charSetUpdatedInType1Font(pdffont)) {
                            return null;
                        }
                        FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCharSet);
                    }
                } else if (pdffont instanceof PDFFontType0) {
                    HashSet<Integer> referencedCidset = new HashSet<Integer>();
                    PDFFontType0 type0Font = (PDFFontType0)pdffont;
                    Type0FontProcessor.addReferencedCIDSetErrors(conversionHandler, referencedCharCodes, errorCodes, type0Font, referencedCidset);
                    if (conversionHandler != null && FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCIDSet)) {
                        referencedCidset = fontContext.addCidSetToFont(type0Font.getDescendantFont(), referencedCidset);
                        int[] cidarray = new int[referencedCidset.size()];
                        int index = 0;
                        for (int cid : referencedCidset) {
                            cidarray[index++] = cid;
                        }
                        if (FontProcessorUtils.embedCIDSet(type0Font, null, null, cidarray)) {
                            if (!conversionHandler.CIDSetUpdatedInType0Font(type0Font)) {
                                return null;
                            }
                            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCIDSet);
                        }
                    }
                }
            }
            for (Integer charCodeInt : referencedCharCodes) {
                double afeGlyphWidth;
                PDFFontType0 type0Font;
                int charCode = charCodeInt;
                int gid = pdffont.charCode2gid(charCode);
                PDFFontSimple simpleFont = pdffont instanceof PDFFontSimple ? (PDFFontSimple)pdffont : null;
                PDFFontType0 pDFFontType0 = type0Font = pdffont instanceof PDFFontType0 ? (PDFFontType0)pdffont : null;
                if (type0Font != null && PDFFontUtils.isCMapIdentity(type0Font.getEncoding())) {
                    missingGlyph = gid < 0;
                } else {
                    boolean isGlyphNotDef = false;
                    if (pdffont instanceof PDFFontSimple) {
                        if (simpleFont.getEncoding() != null) {
                            String glyphName = simpleFont.charCode2glyphName(charCode);
                            isGlyphNotDef = ".notdef".equals(glyphName);
                            if (isGlyphNotDef) {
                                missingGlyph = gid < 0;
                            } else {
                                boolean bl = missingGlyph = gid <= 0;
                            }
                        }
                        if (gid <= 0 && simpleFont.getSubtype() == ASName.k_TrueType && simpleFont.getEncoding() != null && simpleFont.getEncoding().isWinAnsiEncoding() && charCode < 32) {
                            missingGlyph = true;
                            errorCodes.addErrorCode(PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph);
                        }
                    } else if (pdffont instanceof PDFFontType0) {
                        if (gid == 0) {
                            PDFType0FontEncoding encoding;
                            int cid;
                            PDFCIDFont descendantFont;
                            missingGlyph = true;
                            if (fontData instanceof OpenTypeFont && (descendantFont = type0Font.getDescendantFont()).getSubType() == ASName.k_CIDFontType2 && descendantFont.getFontDescriptor() != null && descendantFont.getFontDescriptor().containsEmbeddedFont() && descendantFont.cid2gid(cid = (encoding = type0Font.getEncoding()).getCID(charCode)) == 0) {
                                missingGlyph = false;
                            }
                        } else {
                            boolean bl = missingGlyph = gid < 0;
                        }
                    }
                }
                if (missingGlyph) {
                    if (!FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph)) {
                        errorCodes.addErrorCode(PDFAFontErrorCode.embeddedFontMissingGlyphs);
                    }
                    if (!missingGlyph || !widthMismatch) continue;
                    return errorCodes;
                }
                double pdfGlyphWidth = 0.0;
                if (simpleFont != null) {
                    pdfGlyphWidth = simpleFont.getGlyphWidthDefaultMissingWidth(charCode);
                }
                if (type0Font != null) {
                    pdfGlyphWidth = type0Font.getGlyphWidth(charCode);
                }
                if (!(Math.abs(pdfGlyphWidth - (afeGlyphWidth = font.getPDFFontDescription().getAdvance(gid))) > 1.0)) continue;
                errorCodes.addErrorCode(PDFAFontErrorCode.mismatchedWidthsInfo);
                widthMismatch = true;
                if (!missingGlyph || !widthMismatch) continue;
                return errorCodes;
            }
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        catch (PDFFontException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
        }
        return errorCodes;
    }
}

