/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.PKCS7SignerInfo;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;

public final class PKCS7SignerInfoParser {
    int signerinfoVersion;
    X500Name issuer = null;
    byte[] serialNumber = null;
    byte[] digestOID = null;
    X501Attributes authentAttrs = null;
    byte[] digestEncryptionOID = null;
    X501Attributes unauthentAttrs = null;
    byte[] digest = null;
    byte[] authenAttrsOrgBer = null;
    int special = 0;
    private static final int AUTHENT_ATTR_SPECIAL = 0x810000;
    private static final int UNAUTHENT_ATTR_SPECIAL = 0x810001;
    private String digestAlgName;
    PKCS7SignerInfo signerInfo = new PKCS7SignerInfo();

    public PKCS7SignerInfoParser(byte[] dataToParse, int offset) throws Exception {
        this.parse(dataToParse, offset);
    }

    public void parse(byte[] dataToParse, int offset) throws Exception {
        try {
            if (dataToParse == null) {
                return;
            }
            SequenceContainer aSeq = new SequenceContainer(this.special);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0);
            EncodedContainer issuerAndserial = new EncodedContainer(12288);
            EncodedContainer digestID = new EncodedContainer(12288);
            EncodedContainer authAttrs = new EncodedContainer(8466688);
            EncodedContainer digestEncryptID = new EncodedContainer(12288);
            OctetStringContainer encryptDigest = new OctetStringContainer(0);
            EncodedContainer unauthAttrs = new EncodedContainer(8466689);
            ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, authAttrs, digestEncryptID, encryptDigest, unauthAttrs, anEnd};
            ASN1.berDecode((byte[])dataToParse, (int)offset, (ASN1Container[])infoStringDef);
            this.signerinfoVersion = vers.getValueAsInt();
            this.signerInfo.setVersion(this.signerinfoVersion);
            SequenceContainer bSeq = new SequenceContainer(this.special);
            EncodedContainer iss = new EncodedContainer(12288);
            IntegerContainer serial = new IntegerContainer(0);
            ASN1Container[] issAndSerialDef = new ASN1Container[]{bSeq, iss, serial, anEnd};
            ASN1.berDecode((byte[])issuerAndserial.data, (int)issuerAndserial.dataOffset, (ASN1Container[])issAndSerialDef);
            this.issuer = new X500Name(iss.data, iss.dataOffset, 0);
            this.signerInfo.setIssuer(this.issuer);
            if (serial.dataLen == 0) {
                throw new Exception("Cannot decode the BER of the SignerInfo: Serial Number is null.");
            }
            this.serialNumber = new byte[serial.dataLen];
            System.arraycopy(serial.data, serial.dataOffset, this.serialNumber, 0, serial.dataLen);
            this.signerInfo.setSerialNumber(this.serialNumber);
            if (digestID.dataLen == 0) {
                throw new Exception("Cannot decode the BER of the SignerInfo: Digest algorithm is missing.");
            }
            SequenceContainer cSeq = new SequenceContainer(this.special);
            OIDContainer dOID = new OIDContainer(this.special, 11);
            EncodedContainer isNull = new EncodedContainer(65536);
            ASN1Container[] digestSeqDef = new ASN1Container[]{cSeq, dOID, isNull, anEnd};
            ASN1.berDecode((byte[])digestID.data, (int)digestID.dataOffset, (ASN1Container[])digestSeqDef);
            this.digestAlgName = dOID.transformation;
            this.digestOID = new byte[dOID.dataLen];
            System.arraycopy(dOID.data, dOID.dataOffset, this.digestOID, 0, dOID.dataLen);
            this.signerInfo.setDigestOID(this.digestOID);
            if (authAttrs.dataPresent) {
                this.authenAttrsOrgBer = new byte[authAttrs.dataLen];
                System.arraycopy(authAttrs.data, authAttrs.dataOffset, this.authenAttrsOrgBer, 0, authAttrs.dataLen);
                this.authenAttrsOrgBer[0] = 49;
                this.authentAttrs = new X501Attributes(authAttrs.data, authAttrs.dataOffset, 0x810000);
            }
            this.signerInfo.setAuthenAttrsOrgBer(this.authenAttrsOrgBer);
            this.signerInfo.setAuthentAttrs(this.authentAttrs);
            if (digestEncryptID.dataLen == 0) {
                throw new Exception("Cannot decode the BER of the SignerInfo: Encryption algorithm is missing.");
            }
            this.digestEncryptionOID = new byte[digestEncryptID.dataLen];
            System.arraycopy(digestEncryptID.data, digestEncryptID.dataOffset, this.digestEncryptionOID, 0, digestEncryptID.dataLen);
            this.signerInfo.setDigestEncryptionOID(this.digestEncryptionOID);
            if (encryptDigest.dataLen == 0) {
                throw new Exception("Cannot decode the BER of the SignerInfo: Encrypted digest is missing.");
            }
            this.digest = new byte[encryptDigest.dataLen];
            System.arraycopy(encryptDigest.data, encryptDigest.dataOffset, this.digest, 0, encryptDigest.dataLen);
            this.signerInfo.setEncryptedDigest(this.digest);
            if (unauthAttrs.dataPresent) {
                this.unauthentAttrs = new X501Attributes(unauthAttrs.data, unauthAttrs.dataOffset, 0x810001);
            }
            this.signerInfo.setUnauthentAttrs(this.unauthentAttrs);
            this.signerInfo.setDigestAlgName(this.extractDigestAlgName(this.digestOID, this.digestAlgName));
        }
        catch (ASN_Exception asnException) {
            throw new PDFSignatureException("Cannot decode the BER of the SignerInfo: " + asnException.getMessage(), asnException);
        }
        catch (AttributeException attrException) {
            throw new PDFSignatureException("Cannot decode the BER of the SignerInfo: " + attrException.getMessage(), attrException);
        }
        catch (NameException nameException) {
            throw new PDFSignatureException("Cannot decode the BER of the SignerInfo: " + nameException.getMessage(), nameException);
        }
    }

    String extractDigestAlgName(byte[] digestOID, String algorithmName) throws Exception {
        if (digestOID == null) {
            return null;
        }
        if (algorithmName != null) {
            return algorithmName;
        }
        String transformationName = OIDList.getTrans((byte[])digestOID, (int)0, (int)digestOID.length, (int)11);
        if (transformationName == null) {
            transformationName = OIDList.getTrans((byte[])digestOID, (int)0, (int)digestOID.length, (int)1);
        }
        if (transformationName == null) {
            throw new Exception("The digest oid in the SignerInfo" + new String(digestOID) + " is neither a supported Digest OID or a PPKMS combination oid");
        }
        return transformationName.split("/")[0];
    }

    public PKCS7SignerInfo getSignerInfo() {
        return this.signerInfo;
    }

    public void setSignerInfo(PKCS7SignerInfo signerInfo) {
        this.signerInfo = signerInfo;
    }
}

