/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSet;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSetSIS;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSetSPS;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSetUnknown;

public class PDFSpiderContentSetFactory {
    public static PDFSpiderContentSet getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosUtils.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected, instead found " + cosObject.getClass() + ", Object number:" + cosObject.getObjNum());
        }
        ASName nameSubtype = ((CosDictionary)cosObject).getName(ASName.k_Subtype);
        if (nameSubtype == null) {
            throw new PDFInvalidDocumentException("Subtype entry in SpiderContentSet can't be null, Object number: " + cosObject.getObjNum());
        }
        if (nameSubtype == ASName.k_SPS) {
            return PDFSpiderContentSetSPS.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_SIS) {
            return PDFSpiderContentSetSIS.getInstance(cosObject);
        }
        return PDFSpiderContentSetUnknown.getInstance(cosObject);
    }
}

