/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageMode;
import java.util.ArrayList;

public class PDFBookmark
extends PDFBookmarkNode {
    private PDFBookmark(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFBookmark getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBookmark pdfObject = (PDFBookmark)PDFCosObject.getCachedInstance(cosObject, PDFBookmark.class);
        if (pdfObject == null) {
            pdfObject = new PDFBookmark(cosObject);
        }
        return pdfObject;
    }

    public static PDFBookmark newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFBookmark(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFBookmark newInstance(PDFDocument pdfDocument, String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark bookmark = PDFBookmark.newSkeletonInstance(pdfDocument);
        bookmark.setTitle(title);
        return bookmark;
    }

    public static PDFBookmark newInstance(PDFDocument pdfDocument, String title, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark bookmark = PDFBookmark.newSkeletonInstance(pdfDocument);
        bookmark.setTitle(title, unicode);
        return bookmark;
    }

    public boolean hasTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Title);
    }

    public void setTitle(String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Title, title);
    }

    public void setTitle(String title, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Title, title, unicode);
    }

    public String getTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Title);
    }

    public void setDestination(PDFDestination destination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Dest, destination);
    }

    public void setAction(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_Dest)) {
            this.setDictionaryValue(ASName.k_A, action);
        }
    }

    public boolean hasColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }

    public double[] getColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_C)) {
            return null;
        }
        return this.getDictionaryArrayValue(ASName.k_C).getArrayDouble();
    }

    public void setColor(float red, float green, float blue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setColor((double)red, (double)green, (double)blue);
    }

    public void setColor(double red, double green, double blue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        red = Math.max(0.0, Math.min(1.0, red));
        green = Math.max(0.0, Math.min(1.0, green));
        blue = Math.max(0.0, Math.min(1.0, blue));
        this.setDictionaryArrayValue(ASName.k_C, PDFCosObject.makeCosArray(this.getPDFDocument(), 0, new double[]{red, green, blue}, 0, 2));
    }

    public boolean hasStyles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public int getStyles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_F);
    }

    public void setStyles(int f) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_F, f);
    }

    public void setParent(PDFBookmarkNode bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Parent, bookmark);
    }

    public void setPrevious(PDFBookmark bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Prev, bookmark);
    }

    public void setNext(PDFBookmark bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Next, bookmark);
    }

    public PDFBookmark getPrevious() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBookmark.getInstance(this.getDictionaryCosObjectValue(ASName.k_Prev));
    }

    public PDFBookmark getNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBookmark.getInstance(this.getDictionaryCosObjectValue(ASName.k_Next));
    }

    public ArrayList<PDFBookmark> getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFBookmark> list = new ArrayList<PDFBookmark>();
        PDFBookmark kid = this.getFirstKid();
        if (kid != null) {
            list.add(kid);
            list = this.getNextKid(kid, list);
        } else {
            list = this.getNextKid(this, list);
        }
        return list;
    }

    private ArrayList<PDFBookmark> getNextKid(PDFBookmark kid, ArrayList<PDFBookmark> list) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        while (kid.getNext() != null) {
            list.add(kid.getNext());
            kid = kid.getNext();
        }
        return list;
    }

    public PDFBookmarkNode getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmarkRoot root = this.getPDFDocument().requireCatalog().getBookmarkRoot();
        CosObject parent = this.getDictionaryCosObjectValue(ASName.k_Parent);
        if (parent == root.getCosObject()) {
            return PDFBookmarkRoot.getInstance(parent);
        }
        return PDFBookmark.getInstance(parent);
    }

    public PDFBookmark newLastKid(String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark bookmark = PDFBookmark.newInstance(this.getPDFDocument(), title);
        PDFBookmarkUtils.appendLastKid(bookmark, this);
        PDFBookmarkUtils.appendLastKid(bookmark, this);
        return bookmark;
    }

    public PDFDestination getDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestination.getInstance(this.getDictionaryCosObjectValue(ASName.k_Dest));
    }

    public PDFAction getAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_A));
    }

    public PDFBookmarkNode delete() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark prev = this.getPrevious();
        PDFBookmark next = this.getNext();
        PDFBookmarkNode parent = this.getParent();
        if (prev == null) {
            if (next == null) {
                if (parent instanceof PDFBookmarkRoot) {
                    PDFCatalog catalog = parent.getPDFDocument().requireCatalog();
                    catalog.removeValue(ASName.k_Outlines);
                    PDFPageMode pageMode = catalog.getPageMode();
                    if (pageMode == PDFPageMode.WithBookmarks) {
                        catalog.setPageMode(PDFPageMode.PagesOnly);
                    }
                    return null;
                }
                parent.removeValue(ASName.k_First);
                parent.removeValue(ASName.k_Last);
                return parent;
            }
            parent.setFirst(next);
        } else {
            prev.setNext(next);
        }
        if (next == null) {
            if (prev != null) {
                parent.setLast(prev);
            }
        } else {
            next.setPrevious(prev);
        }
        return prev != null ? prev : next;
    }

    public PDFStructureElement getStructureElement() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureElement.getInstance(this.getDictionaryCosObjectValue(ASName.k_SE));
    }

    public void setStructureElement(PDFStructureElement element) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_SE, element);
    }

    @Override
    public int getCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getDictionaryIntValue(ASName.k_Count) != null) {
            return this.getDictionaryIntValue(ASName.k_Count);
        }
        PDFBookmark kid = this.getFirstKid();
        if (kid != null) {
            throw new PDFInvalidDocumentException("Count Entry is missing at this node where it's required");
        }
        return 0;
    }

    public boolean hasAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAction() != null;
    }

    public boolean hasDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDestination() != null;
    }

    @Override
    public boolean hasCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Count);
    }

    public boolean hasStructureElement() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getStructureElement() != null;
    }

    @Override
    public PDFBookmark findDepthFirst(String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark b;
        if (title.equals(this.getTitle())) {
            return this;
        }
        for (b = this.getFirstKid(); b != null; b = b.getNext()) {
            PDFBookmark b2 = b.findDepthFirst(title);
            if (b2 == null) continue;
            return b2;
        }
        b = this.getNext();
        if (b != null) {
            return b.findDepthFirst(title);
        }
        return null;
    }
}

