/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorSpace;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import java.awt.color.ICC_ColorSpace;
import java.util.ArrayList;

public abstract class PDFColorSpace
extends PDFCosObject
implements ColorSpace {
    public static final ASName k_WhitePoint = ASName.create("WhitePoint");
    private boolean BlackIs1;
    private boolean isImageInverted;

    protected PDFColorSpace(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpace createColorSpace(PDFDocument doc, java.awt.color.ColorSpace cs) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFColorSpace retval = null;
        if (cs.isCS_sRGB()) {
            retval = PDFColorSpaceDeviceRGB.getInstance(PDFCosObject.newCosName(doc, ASName.k_DeviceRGB));
        } else if (cs instanceof ICC_ColorSpace) {
            ICC_ColorSpace ics = (ICC_ColorSpace)cs;
            ArrayList<Float> ranges = new ArrayList<Float>();
            for (int i = 0; i < cs.getNumComponents(); ++i) {
                ranges.add(new Float(ics.getMinValue(i)));
                ranges.add(new Float(ics.getMaxValue(i)));
            }
            PDFColorSpaceICCBased pdCS = PDFColorSpaceICCBased.newInstance(doc, ics.getProfile());
            retval = pdCS;
        } else {
            throw new PDFIOException("Not yet implemented:" + cs);
        }
        return retval;
    }

    public boolean isBlackIs1() {
        return this.BlackIs1;
    }

    public void setBlackIs1(boolean blackIs1) {
        this.BlackIs1 = blackIs1;
    }

    public boolean isImageInverted() {
        return this.isImageInverted;
    }

    public void setImageInverted(boolean isImageInverted) {
        this.isImageInverted = isImageInverted;
    }

    protected CosArray createCIEWhitePointArray(PDFDocument pdfDocument, double x, double z) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray xyzSpaceObj = PDFCosObject.newCosArray(pdfDocument);
        xyzSpaceObj.addDouble(0, x);
        xyzSpaceObj.addDouble(1, 1.0);
        xyzSpaceObj.addDouble(2, z);
        return xyzSpaceObj;
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        if (inputColorValues == null) {
            try {
                return this.getDefaultColor();
            }
            catch (PDFIOException e) {
                throw new PDFRuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new PDFRuntimeException(e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFRuntimeException(e);
            }
        }
        return inputColorValues;
    }

    public abstract double[] getDefaultColor() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException;
}

