/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosSaveParams;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;

public abstract class PDFSaveOptions {
    public static final int OBJECT_COMPRESSION_PRESERVE = 0;
    public static final int OBJECT_COMPRESSION_NONE = 1;
    public static final int OBJECT_COMPRESSION_ALL = 2;
    public static final int OBJECT_COMPRESSION_STRUCTURE = 3;
    protected CosSaveParams mCosSaveParams;

    protected PDFSaveOptions() {
    }

    public boolean containsVersion() {
        return this.mCosSaveParams.getVersion() != null;
    }

    public PDFVersion getVersion() {
        if (this.containsVersion()) {
            return PDFVersion.getInstance(this.mCosSaveParams.getVersion(), this.mCosSaveParams.getExtensions());
        }
        return null;
    }

    public void setVersion(PDFVersion version) {
        this.mCosSaveParams.setVersion(version.getVersionValue());
        this.mCosSaveParams.setExtensions(version.getExtensions());
    }

    public SecurityLock getSecurityLock() {
        return null;
    }

    public void setCloseAfterSave(boolean closeAfterSave) {
        this.mCosSaveParams.setCloseAfterSave(closeAfterSave);
    }

    public boolean getCloseAfterSave() {
        return this.mCosSaveParams.getCloseAfterSave();
    }

    public void setForceCompress(boolean forceCompress) {
        this.mCosSaveParams.setForceCompress(forceCompress);
    }

    public boolean getForceCompress() {
        return this.mCosSaveParams.getForceCompress();
    }

    public void setHeaderToken(String headerToken) throws PDFInvalidParameterException {
        this.mCosSaveParams.setHeaderToken(headerToken);
    }

    public String getHeaderToken() {
        return this.mCosSaveParams.getHeaderToken();
    }

    public void setSaveToCopy(boolean saveToCopy) {
        this.mCosSaveParams.setSaveToCopy(saveToCopy);
    }

    public boolean getSaveToCopy() {
        return this.mCosSaveParams.getSaveToCopy();
    }

    public void setObjectCompressionMode(int objectCompressionMode) throws PDFInvalidParameterException {
        if (objectCompressionMode == 1) {
            this.mCosSaveParams.setXrefStyle(1);
        } else if (objectCompressionMode == 2) {
            this.mCosSaveParams.setXrefStyle(2);
        } else if (objectCompressionMode == 3) {
            this.mCosSaveParams.setXrefStyle(3);
        } else {
            this.mCosSaveParams.setXrefStyle(0);
        }
    }

    public int getObjectCompressionMode() {
        int xrefStyle = this.mCosSaveParams.getXrefStyle();
        if (xrefStyle == 1) {
            return 1;
        }
        if (xrefStyle == 2) {
            return 2;
        }
        if (xrefStyle == 3) {
            return 3;
        }
        return 0;
    }
}

