/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosOpenOptions;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFAppBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildProp;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFilterBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFPubSecBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSigQBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;

public class PDFSignature
extends PDFCosDictionary {
    public static final ASName k_Changes = ASName.create("Changes");
    public static final ASName k_DocMDP = ASName.create("DocMDP");
    public static final ASName k_UR = ASName.create("UR");
    public static final ASName k_UB1 = ASName.create("UB1");
    public static final ASName k_UR3 = ASName.create("UR3");
    public static final ASName k_FieldMDP = ASName.create("FieldMDP");
    public static final ASName k_Identity = ASName.create("Identity");
    public static final ASName k_Reference = ASName.create("Reference");
    public static final ASName k_MD5 = ASName.create("MD5");
    public static final ASName k_SHA1 = ASName.create("SHA1");
    public static final ASName k_SHA256 = ASName.create("SHA256");
    public static final ASName k_SHA384 = ASName.create("SHA384");
    public static final ASName k_SHA512 = ASName.create("SHA512");
    public static final ASName k_RIPEMD160 = ASName.create("RIPEMD160");
    public static final ASName k_Adobe_PPKLite = ASName.create("Adobe.PPKLite");
    public static final ASName k_Adobe_PPKMS = ASName.create("Adobe.PPKMS");
    public static final ASName k_adbe_x509_rsa_sha1 = ASName.create("adbe.x509.rsa_sha1");
    public static final ASName k_adbe_pkcs7_sha1 = ASName.create("adbe.pkcs7.sha1");
    public static final ASName k_adbe_pkcs7_detached = ASName.create("adbe.pkcs7.detached");
    public static final ASName k_ETSI_RFC3161 = ASName.create("ETSI.RFC3161");
    public static final ASName k_ETSI_CADES_detached = ASName.create("ETSI.CAdES.detached");
    public static final ASName k_Prop_AuthTime = ASName.create("Prop_AuthTime");
    public static final String RSACipher = "RSA";
    public static final String DSASigAlgorithm = "DSA";
    public static final String RipeMDOID = "1.3.36.3.3.1.2";
    public static final String ECCipher = "EC";

    protected PDFSignature(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSignature getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSignature pdfObject = (PDFSignature)PDFCosObject.getCachedInstance(cosObject, PDFSignature.class);
        if (pdfObject == null) {
            pdfObject = new PDFSignature(cosObject);
        }
        return pdfObject;
    }

    public static PDFSignature newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignature.newInstance(pdfDocument, PDFSignatureFilter.AdobePPKLite.toString(), PDFSignatureSubFilter.PKCS7Detached.toString());
    }

    public static PDFSignature newInstance(PDFDocument pdfDocument, PDFSignatureSubFilter subFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignature.newInstance(pdfDocument, null, subFilter);
    }

    public static PDFSignature newInstance(PDFDocument pdfDocument, PDFSignatureFilter filter, PDFSignatureSubFilter subFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (filter == null) {
            filter = PDFSignatureFilter.AdobePPKLite;
        }
        if (subFilter == null) {
            subFilter = PDFSignatureSubFilter.PKCS7Detached;
        }
        return PDFSignature.newInstance(pdfDocument, filter.toString(), subFilter.toString());
    }

    static PDFSignature newInstance(PDFDocument pdfDocument, String filter, String subfilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSignature pdfObject = new PDFSignature(cosObject);
        pdfObject.setType(ASName.k_Sig);
        pdfObject.setFilterName(ASName.create(filter));
        pdfObject.setSubFilterName(ASName.create(subfilter));
        return pdfObject;
    }

    protected void setType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, type);
    }

    public int getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_R)) {
            return this.getDictionaryIntValue(ASName.k_R);
        }
        return 0;
    }

    public void setVersion(int version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (version == 0) {
            this.removeValue(ASName.k_R);
        } else {
            this.setDictionaryIntValue(ASName.k_R, version);
        }
    }

    public ASName getFilterName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Filter);
    }

    void setFilterName(ASName filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (filter == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter:filter entry can not be null");
        }
        this.setDictionaryNameValue(ASName.k_Filter, filter);
    }

    public ASName getSubFilterName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_SubFilter);
    }

    public void setSubFilterName(ASName subFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_SubFilter, subFilter);
    }

    public byte[] getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosString contentsStr = this.getCosDictionary().getCosString(ASName.k_Contents);
        if (contentsStr != null) {
            return contentsStr.byteArrayValue();
        }
        return null;
    }

    public void setContents(byte[] contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (contents == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter:contents entry can not be null");
        }
        this.setDictionaryByteArrayValue(ASName.k_Contents, contents);
        CosString contentsStr = this.getCosDictionary().getCosString(ASName.k_Contents);
        contentsStr.setWriteHex(true);
        if (contentsStr.getToEncrypt()) {
            contentsStr.setToEncrypt(false);
        }
    }

    public long[] getByteRanges() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosByteRange = this.getDictionaryArrayValue(ASName.k_ByteRange);
        if (cosByteRange != null) {
            return cosByteRange.getArrayLong();
        }
        return null;
    }

    public void setByteRanges(long[] byteRanges) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosByteRanges = null;
        if (this.getCosDictionary().containsKey(ASName.k_ByteRange)) {
            cosByteRanges = this.getDictionaryArrayValue(ASName.k_ByteRange);
            cosByteRanges.clear();
        } else {
            cosByteRanges = PDFCosObject.newCosArray(this.getPDFDocument());
            this.setDictionaryArrayValue(ASName.k_ByteRange, cosByteRanges);
        }
        for (int i = 0; i < byteRanges.length; ++i) {
            cosByteRanges.addLong(i, byteRanges[i]);
        }
    }

    public byte[][] getCertificates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getDictionaryCosObjectValue(ASName.k_Cert);
        if (cosObj == null) {
            return null;
        }
        if (cosObj instanceof CosArray) {
            return ((CosArray)cosObj).getArrayBytes();
        }
        if (cosObj instanceof CosString) {
            CosString cosCerts = (CosString)cosObj;
            byte[][] certs = new byte[][]{cosCerts.byteArrayValue()};
            return certs;
        }
        throw new PDFInvalidDocumentException("Cos String or Array Expected");
    }

    public void setCertificate(byte[] cert) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryByteArrayValue(ASName.k_Cert, cert);
    }

    public void setCertificates(byte[][] certs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument pdfDocument = this.getPDFDocument();
        CosArray array = PDFCosObject.newCosArray(pdfDocument);
        for (int i = 0; i < certs.length; ++i) {
            CosString str = PDFCosObject.newCosString(pdfDocument, certs[i]);
            array.add(str);
        }
        this.setDictionaryArrayValue(ASName.k_Cert, array);
    }

    public PDFSignatureReferenceList getSignatureReferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_Reference);
        return PDFSignatureReferenceList.getInstance(cosArray);
    }

    public void setReferences(PDFSignatureReferenceList sigRefList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sigRefList == null) {
            this.removeValue(k_Reference);
        } else {
            this.setDictionaryArrayValue(k_Reference, sigRefList.getCosArray());
        }
    }

    public void setPDFBuildPropDictionary(PDFFilterBuildData filterDict, PDFAppBuildData appDict, PDFSigQBuildData sigQDict, PDFPubSecBuildData pubSecDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBuildProp buildPropDict = PDFBuildProp.newInstance(this.getPDFDocument());
        if (filterDict != null) {
            buildPropDict.setFilterDict(filterDict);
        }
        if (appDict != null) {
            buildPropDict.setAppDict(appDict);
        }
        if (sigQDict != null) {
            buildPropDict.setSigQDict(sigQDict);
        }
        if (pubSecDict != null) {
            buildPropDict.setPubSecDict(pubSecDict);
        }
        this.setDictionaryValue(ASName.k_Prop_Build, buildPropDict);
    }

    public PDFBuildProp getPDFBuildPropDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary buildPropDict = this.getDictionaryDictionaryValue(ASName.k_Prop_Build);
        if (buildPropDict != null) {
            return PDFBuildProp.getInstance(buildPropDict);
        }
        return null;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public int getRevision() {
        return this.getCosObject().getObjRevision();
    }

    public void setChanges(long[] changes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (changes == null) {
            this.removeValue(k_Changes);
        } else {
            this.setDictionaryArrayValue(k_Changes, changes);
        }
    }

    public long[] getChanges() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosChanges = this.getDictionaryArrayValue(k_Changes);
        if (cosChanges != null) {
            return cosChanges.getArrayLong();
        }
        return null;
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Name);
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            this.removeValue(ASName.k_Name);
        } else {
            this.setDictionaryStringValue(ASName.k_Name, name);
        }
    }

    public void setName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            this.removeValue(ASName.k_Name);
        } else {
            this.setDictionaryStringValue(ASName.k_Name, name, unicode);
        }
    }

    public ASDate getDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_M);
    }

    public void setDate(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (date == null) {
            this.removeValue(ASName.k_M);
        } else {
            this.setDictionaryDateValue(ASName.k_M, date);
        }
    }

    public String getLocation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Location);
    }

    public void setLocation(String location) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (location == null) {
            this.removeValue(ASName.k_Location);
        } else {
            this.setDictionaryStringValue(ASName.k_Location, location);
        }
    }

    public void setLocation(String location, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (location == null) {
            this.removeValue(ASName.k_Location);
        } else {
            this.setDictionaryStringValue(ASName.k_Location, location, unicode);
        }
    }

    public String getReason() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Reason);
    }

    public void setReason(String reason) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (reason == null) {
            this.removeValue(ASName.k_Reason);
        } else {
            this.setDictionaryStringValue(ASName.k_Reason, reason);
        }
    }

    public void setReason(String reason, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (reason == null) {
            this.removeValue(ASName.k_Reason);
        } else {
            this.setDictionaryStringValue(ASName.k_Reason, reason, unicode);
        }
    }

    public String getContactInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_ContactInfo);
    }

    public void setContactInfo(String contact) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (contact == null) {
            this.removeValue(ASName.k_ContactInfo);
        } else {
            this.setDictionaryStringValue(ASName.k_ContactInfo, contact);
        }
    }

    public long getAuthenticationTime() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number authTime = this.getDictionaryNumericValue(k_Prop_AuthTime);
        if (authTime != null) {
            return authTime.longValue();
        }
        return 0L;
    }

    public void setAuthenticationTime(Long sec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_Prop_AuthTime, sec);
    }

    public ASName getAuthenticationType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.create("Prop_AuthType"));
    }

    public void setAuthenticationType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (type == null) {
            this.removeValue(ASName.create("Prop_AuthType"));
        } else {
            this.setDictionaryNameValue(ASName.create("Prop_AuthType"), type);
        }
    }

    public CosDocument generateRollBackDocument() throws PDFCosParseException, PDFSecurityException, PDFIOException {
        SignatureEOFOptions options = new SignatureEOFOptions();
        options.setEofValue(this.getCosObject().getObjEOF());
        CosDocument newDoc = CosDocument.newDocument(this.getPDFDocument().getCosDocument().getByteReader(), options);
        SecurityManager origSecMgr = this.getPDFDocument().getCosDocument().getEncryption().getDecryptionSecurityManager();
        if (origSecMgr != null) {
            newDoc.getEncryption().setDecryptionSecurityManager(origSecMgr);
        }
        return newDoc;
    }

    private static final class SignatureEOFOptions
    extends CosOpenOptions {
        private SignatureEOFOptions() {
        }
    }
}

