/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.FontWidthStore;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PDFSimpleFontData {
    private Double[] widths = new Double[256];
    private Boolean applyHeuristicsToGetSpaceCharWidth;
    private Map<Long, int[]> charCodeUnicodeMap = new HashMap<Long, int[]>();
    private FontWidthStore fontWidthStore;

    PDFSimpleFontData() {
    }

    double getWidth(int charcode, PDFFontSimple fontSimple) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Double width = this.widths[charcode];
        if (width == null) {
            this.widths[charcode] = width = Double.valueOf(PDFFontUtils.getGlyphWidth(false, fontSimple, charcode)[0]);
        }
        return width;
    }

    boolean applyHeuristicsToGetSpaceCharWidth(PDFFontSimple fontSimple) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.applyHeuristicsToGetSpaceCharWidth == null) {
            this.applyHeuristicsToGetSpaceCharWidth = fontSimple.applyHeuristicsToGetSpaceCharWidth();
        }
        return this.applyHeuristicsToGetSpaceCharWidth;
    }

    List getCharCodesFromFont(byte[] bytes, boolean fetchUnicode, PDFFontSimple fontSimple) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fetchUnicode) {
            return fontSimple.getCharCodes(bytes, true, this.charCodeUnicodeMap);
        }
        return fontSimple.getCharCodes(bytes, false);
    }

    public FontWidthStore getFontWidthStore() {
        return this.fontWidthStore;
    }

    public void setFontWidthStore(FontWidthStore fontWidthStore) {
        this.fontWidthStore = fontWidthStore;
    }
}

