/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperators;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContentStreamProcessor {
    protected static final Map<ASName, ContentOperator> operators;
    protected IOperatorHandler operatorHandler;

    public void process(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = Content.newInstance(page);
        this.process(content);
    }

    public abstract void process(Content var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract void process(ContentReader var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public void process(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentOperator co = operators.get(instruction.getOperator());
        if (co != null) {
            try {
                co.process(instruction, this.operatorHandler);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
    }

    public IOperatorHandler getOperatorHandler() {
        return this.operatorHandler;
    }

    static {
        HashMap tempOperators = new HashMap();
        ContentOperators.bindCallbackObjects(tempOperators);
        operators = Collections.unmodifiableMap(tempOperators);
    }
}

