/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.image;

import com.adobe.internal.io.stream.BitInputStream;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.color.ColorSpace;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.image.ImageInputSource;
import com.adobe.internal.pdftoolkit.image.ImageResamplingMethod;
import com.adobe.internal.pdftoolkit.image.Resampler;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ARGBImage {
    public static final int MEMORY_THRESHOLD = 12000000;
    private int width;
    private int scaledWidth;
    private int height;
    private int scaledHeight;
    private int bpc;
    private ColorSpaceCache colorSpace;
    private InputStream imageInputStream = null;
    private ImageInputSource imageSource = null;
    private int references = 0;
    private ImageResamplingMethod downScalingMethod;
    private boolean resamplingPending = false;
    private int[] rgbIndexTable = null;
    private double[] decode = null;
    private List<Object> outputTiles = null;
    private Object mask;

    public double[] getDecode() {
        return this.decode;
    }

    public ARGBImage(ImageInputSource decodedImage, int width, int height, int bitsPerComponent, ColorSpaceCache colorSpace, double[] decode) throws IOException {
        this(decodedImage, width, height, bitsPerComponent, colorSpace, false, false, decode);
    }

    public ARGBImage(ImageInputSource decodedImage, int width, int height, int bitsPerComponent, ColorSpaceCache colorSpace) throws IOException {
        this(decodedImage, width, height, bitsPerComponent, colorSpace, false, false, null);
    }

    public ARGBImage(ImageInputSource imageSource, int width, int height, int bitsPerComponent, ColorSpaceCache colorSpace, boolean isInline, boolean isMask, double[] decode) throws IOException {
        this.width = width;
        this.height = height;
        this.scaledHeight = height;
        this.scaledWidth = width;
        this.bpc = bitsPerComponent;
        this.colorSpace = colorSpace;
        this.imageSource = imageSource;
        this.imageInputStream = imageSource.getImageInputStream();
        this.decode = decode;
        ++this.references;
    }

    private int[] initializeOutputStorage(int height, int width, int index) {
        if (this.outputTiles == null) {
            this.outputTiles = new ArrayList<Object>();
        }
        BufferedImage tileImage = new BufferedImage(width, height, 2);
        int[] out = ((DataBufferInt)tileImage.getRaster().getDataBuffer()).getData();
        if (index < this.outputTiles.size()) {
            this.outputTiles.set(index, tileImage);
        } else {
            this.outputTiles.add(tileImage);
        }
        return out;
    }

    private void handleICCColorSpace(ColorSpaceCache colorSpace, int bpc, int width, int height, int[] output, int transferType, DataBuffer buffer) throws Exception {
        BufferedImage colorTable = null;
        try {
            colorTable = this.convertToRGB(colorSpace, bpc, width, height, transferType, buffer);
        }
        catch (Exception e) {
            if (colorSpace.getSubstituteColorSpace().getUnderlyingColorspace().getName() == ASName.k_DeviceCMYK) {
                colorTable = this.convertToRGB(colorSpace.getSubstituteColorSpace(), bpc, width, height, transferType, buffer);
            }
            throw e;
        }
        System.arraycopy(((DataBufferInt)colorTable.getRaster().getDataBuffer()).getData(), 0, output, 0, width * height);
    }

    private void handleColorSpaceWithTintTransform(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, int[] output) throws Exception {
        double[] transformedValues = this.applyTintTransform(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height);
        this.handleICCColorSpace(colorSpace.getSubstituteColorSpace(), bpc, width, height, output, 5, new DataBufferDouble(transformedValues, transformedValues.length));
    }

    private boolean twoStepsForTintTransforms(ColorSpaceCache colorSpace) {
        return colorSpace.getSubstituteColorSpace().getUnderlyingColorspace().getName() == ASName.k_ICCBased || colorSpace.getSubstituteColorSpace().getUnderlyingColorspace().getName() == ASName.k_DeviceCMYK;
    }

    private void performAction(ColorSpaceCache colorSpace, BitInputStream bis, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, Action<?> action) {
        BitInputStream bitIS = null;
        try {
            bitIS = bis == null ? new BitInputStream(new ByteArrayInputStream(decodedData)) : bis;
            int numberOfComponents = colorSpace.getUnderlyingColorspace().getName() != ASName.k_Indexed ? colorSpace.getNumberOfComponents() : 1;
            double[] pixel = new double[numberOfComponents];
            double[] range = colorSpace.getRange();
            double inputRangeMax = Math.pow(2.0, bpc);
            if (updatedBpcVal != bpc) {
                bpc = updatedBpcVal;
            }
            int bitsReadinRow = 0;
            for (int i = 0; i < height; ++i) {
                bitsReadinRow = 0;
                for (int j = 0; j < width; ++j) {
                    for (int k = 0; k < numberOfComponents; ++k) {
                        bitsReadinRow += bpc;
                        pixel[k] = bitIS.read(bpc);
                        if (pixel[k] < 0.0) {
                            int n = k;
                            pixel[n] = pixel[n] + inputRangeMax;
                        }
                        if (colorSpace.getUnderlyingColorspace().getName() == ASName.k_Indexed || range == null || range[2 * k] == 0.0 && range[2 * k + 1] == inputRangeMax - 1.0) continue;
                        pixel[k] = GraphicsUtils.scaleToRange(0.0, inputRangeMax - 1.0, pixel[k], range[2 * k], range[2 * k + 1]);
                    }
                    action.perform(pixel, i, j);
                }
                if (bitsReadinRow % 8 == 0) continue;
                bitIS.skip(8 - bitsReadinRow % 8);
            }
        }
        catch (IOException e) {
            throw new PDFRuntimeException("IO Exception while convering image to RGB", e);
        }
        finally {
            if (bitIS != null && bis == null) {
                try {
                    bitIS.close();
                }
                catch (IOException e) {
                    throw new PDFRuntimeException("IO Exception while closing BitInputStream.", e);
                }
            }
        }
    }

    private double[] applyTintTransform(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height) {
        int transformedPixelSize = colorSpace.getSubstituteColorSpace().getNumberOfComponents();
        double[] transformedPixels = new double[width * height * transformedPixelSize];
        this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new ApplyTintTransform(colorSpace, transformedPixels, width, height, transformedPixelSize));
        return transformedPixels;
    }

    private void convertToRGB(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, int[] output) {
        String colorSpaceName;
        switch (colorSpaceName = colorSpace.getUnderlyingColorspace().getName().toString()) {
            case "/DeviceRGB": {
                this.convertDeviceRGBImageToSRGBImage(colorSpace, bpc, decodedData, width, height, output);
                break;
            }
            case "/Indexed": {
                this.convertIndexedColorspaceImagetoSRGBImage(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, output);
                break;
            }
            case "/Separation": 
            case "/DeviceN": {
                if (this.twoStepsForTintTransforms(colorSpace)) {
                    this.convertSeparationColorspaceToSRGBImage(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, output);
                    break;
                }
                this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new ConvertToRGB(colorSpace, output, width, height));
                break;
            }
            case "/ICCBased": 
            case "/DeviceCMYK": {
                if (Arrays.equals(colorSpace.getRange(), colorSpace.getUnderlyingColorspace().getRange())) {
                    this.convertICCbasedCMYKImagestoSRGBImage(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, output);
                    break;
                }
                this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new ConvertToRGB(colorSpace, output, width, height));
                break;
            }
            default: {
                this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new ConvertToRGB(colorSpace, output, width, height));
            }
        }
    }

    private void convertDeviceRGBImageToSRGBImage(ColorSpaceCache colorSpace, int bpc, byte[] decodedData, int width, int height, int[] output) {
        BufferedImage bImage = this.convertToRGB(colorSpace, bpc, width, height, 0, new DataBufferByte(decodedData, decodedData.length));
        decodedData = null;
        System.arraycopy(((DataBufferInt)bImage.getRaster().getDataBuffer()).getData(), 0, output, 0, width * height);
    }

    private void convertIndexedColorspaceImagetoSRGBImage(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, int[] output) {
        ColorSpaceCache baseCS = colorSpace.getSubstituteColorSpace();
        if (this.rgbIndexTable == null) {
            this.rgbIndexTable = new int[colorSpace.getHighValue() + 1];
            this.convertToRGB(baseCS, null, 8, 8, colorSpace.getLookupData(), colorSpace.getHighValue() + 1, 1, this.rgbIndexTable);
        }
        this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new MapIndices(this.rgbIndexTable, width, output));
    }

    private void convertSeparationColorspaceToSRGBImage(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, int[] output) {
        try {
            this.handleColorSpaceWithTintTransform(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, output);
        }
        catch (Exception e) {
            this.performAction(colorSpace, bitIS, bpc, updatedBpcVal, decodedData, width, height, new ConvertToRGB(colorSpace, output, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertICCbasedCMYKImagestoSRGBImage(ColorSpaceCache colorSpace, BitInputStream bitIS, int bpc, int updatedBpcVal, byte[] decodedData, int width, int height, int[] output) {
        block10: {
            BufferedImage destImage = null;
            if (decodedData != null) {
                try {
                    if (bpc > 8) {
                        try (BitInputStream bis = new BitInputStream(new ByteArrayInputStream(decodedData));){
                            int[] data = new int[decodedData.length * 8 / bpc];
                            bis.read(data, bpc, data.length);
                            this.handleICCColorSpace(colorSpace, bpc, width, height, output, 3, new DataBufferInt(data, data.length));
                            break block10;
                        }
                    }
                    if (bpc == 8 && colorSpace.getUnderlyingColorspace().getName() == ASName.k_DeviceCMYK) {
                        destImage = this.convertDeviceCMYKImagetoSRGBImage(colorSpace, decodedData, width, height);
                        System.arraycopy(((DataBufferInt)destImage.getRaster().getDataBuffer()).getData(), 0, output, 0, width * height);
                    } else {
                        this.handleICCColorSpace(colorSpace, bpc, width, height, output, 0, new DataBufferByte(decodedData, decodedData.length));
                    }
                }
                catch (Exception e) {
                    this.convertToRGB(colorSpace.getSubstituteColorSpace(), bitIS, bpc, updatedBpcVal, decodedData, width, height, output);
                }
            }
        }
    }

    private BufferedImage convertDeviceCMYKImagetoSRGBImage(ColorSpaceCache colorSpace, byte[] decodedData, int width, int height) {
        BufferedImage destImage = new BufferedImage(width, height, 2);
        int wIndex = 0;
        int hIndex = 0;
        int prevCyan = 0;
        int prevMagenta = 0;
        int prevYellow = 0;
        int prevBlack = 0;
        Color prevRGB = null;
        for (int i = 0; i < decodedData.length - 3; i += 4) {
            int cyan = this.convertByteSignedValtoUnsigned(decodedData[i]);
            int magenta = this.convertByteSignedValtoUnsigned(decodedData[i + 1]);
            int yellow = this.convertByteSignedValtoUnsigned(decodedData[i + 2]);
            int black = this.convertByteSignedValtoUnsigned(decodedData[i + 3]);
            Color rgb = null;
            rgb = i != 0 && prevCyan == cyan && prevMagenta == magenta && prevYellow == yellow && prevBlack == black && prevRGB != null ? prevRGB : ColorManager.convertDeviceCMYKtoRGB(cyan, magenta, yellow, black);
            destImage.setRGB(wIndex, hIndex, rgb.getRGB());
            if (++wIndex == width) {
                wIndex = 0;
                ++hIndex;
            }
            prevRGB = rgb;
            prevCyan = cyan;
            prevMagenta = magenta;
            prevYellow = yellow;
            prevBlack = black;
        }
        return destImage;
    }

    private int convertByteSignedValtoUnsigned(int val) {
        if (val < 0) {
            return this.changetopositive(val * -1);
        }
        return val;
    }

    private int changetopositive(int val) {
        return (~val & 0xFF) + 1;
    }

    private BufferedImage convertToRGB(ColorSpaceCache colorSpace, int bpc, int width, int height, int transferType, DataBuffer buffer) {
        ColorModel cm = colorSpace.createColorModel(bpc, transferType);
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        DataBufferWritableRaster newRaster = new DataBufferWritableRaster(raster.getSampleModel(), buffer, new Point(0, 0));
        BufferedImage srcImage = new BufferedImage(cm, newRaster, false, null);
        BufferedImage destImage = new BufferedImage(width, height, 2);
        ColorConvertOp colorConvOp = new ColorConvertOp(cm.getColorSpace(), java.awt.color.ColorSpace.getInstance(1000), null);
        colorConvOp.filter(srcImage, destImage);
        return destImage;
    }

    public int getHeight() {
        return this.scaledHeight;
    }

    public int getWidth() {
        return this.scaledWidth;
    }

    public void downsample(double hScale, double vScale, ImageResamplingMethod method) {
        this.resample((int)Math.round((double)this.height * vScale), (int)Math.round((double)this.width * hScale), method);
    }

    private void resample(int destHeight, int destWidth, ImageResamplingMethod method, int index) {
        this.scaledHeight = destHeight;
        this.scaledWidth = destWidth;
        this.downScalingMethod = method;
        if (this.outputTiles == null || this.outputTiles.isEmpty()) {
            this.resamplingPending = true;
            return;
        }
        BufferedImage curTile = null;
        Object obj = this.outputTiles.get(index);
        if (obj != null) {
            if (obj instanceof SoftReference) {
                obj = ((SoftReference)obj).get();
            }
            if (obj instanceof BufferedImage) {
                curTile = (BufferedImage)obj;
            }
        }
        int[] pixels = ((DataBufferInt)curTile.getRaster().getDataBuffer()).getData();
        int scaledTileHeight = (int)Math.ceil(1.0 * (double)this.scaledHeight / (double)this.height * (double)curTile.getHeight());
        switch (method) {
            case kResampleBicubic: {
                pixels = Resampler.downSampleWithBicubicMethod(this.scaledWidth, scaledTileHeight, curTile.getWidth(), curTile.getHeight(), pixels, 3);
                break;
            }
            case kResampleLinear: {
                throw new UnsupportedOperationException("Linear algorithm for resampling image not implemented yet.");
            }
            case kResampleNearestNeighbor: {
                pixels = Resampler.downSampleWithNearestNeighbourMethod(this.scaledWidth, scaledTileHeight, curTile.getWidth(), curTile.getHeight(), pixels);
                break;
            }
            default: {
                pixels = Resampler.downSampleWithNearestNeighbourMethod(this.scaledWidth, scaledTileHeight, curTile.getWidth(), curTile.getHeight(), pixels);
            }
        }
        curTile = null;
        this.outputTiles.set(index, null);
        BufferedImage bufImage = new BufferedImage(this.scaledWidth, scaledTileHeight, 2);
        System.arraycopy(pixels, 0, ((DataBufferInt)bufImage.getRaster().getDataBuffer()).getData(), 0, this.scaledWidth * scaledTileHeight);
        this.outputTiles.set(index, bufImage);
    }

    public void resample(int destHeight, int destWidth, ImageResamplingMethod method) {
        this.resample(destHeight, destWidth, method, this.outputTiles == null ? -1 : this.outputTiles.size() - 1);
    }

    public BitInputStream getImageBitInputStream() {
        if (this.imageInputStream == null) {
            return null;
        }
        try {
            BitInputStream bitInputStream = new BitInputStream(this.imageInputStream);
            return bitInputStream;
        }
        catch (IOException e) {
            throw new PDFRuntimeException("Exception occured while creating BitInputStream", e);
        }
        finally {
            this.imageInputStream = null;
        }
    }

    public int getReferences() {
        return this.references;
    }

    public void setMask(boolean[] mask) {
        this.mask = mask;
    }

    public boolean[] getMask() {
        if (this.mask instanceof boolean[]) {
            return (boolean[])this.mask;
        }
        if (this.mask instanceof SoftReference) {
            return (boolean[])((SoftReference)this.mask).get();
        }
        return null;
    }

    public Iterator<BufferedImage> getBufferedImagesIterator() {
        return new ARGBTilesIterator();
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace.getUnderlyingColorspace();
    }

    public ARGBImage slice(ImageInputSource imageSource) {
        ++this.references;
        if (this.mask != null) {
            if (this.mask instanceof SoftReference) {
                this.mask = ((SoftReference)this.mask).get();
            }
            if (!(this.mask instanceof boolean[])) {
                return null;
            }
        }
        if (imageSource != null && this.imageSource == null) {
            this.imageSource = imageSource;
        }
        return this;
    }

    public void close() {
        if (--this.references == 0) {
            try {
                if (this.imageInputStream != null) {
                    this.imageInputStream.close();
                }
                this.imageInputStream = null;
                if (this.imageSource != null) {
                    this.imageSource.close();
                }
                this.imageSource = null;
            }
            catch (IOException e) {
                throw new PDFRuntimeException(null, e);
            }
            finally {
                if (this.mask instanceof boolean[]) {
                    this.mask = new SoftReference<boolean[]>((boolean[])this.mask);
                }
                this.rgbIndexTable = null;
            }
        }
    }

    public boolean isClosed() {
        return this.references == 0;
    }

    static class DataBufferWritableRaster
    extends WritableRaster {
        DataBufferWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point sampleModelTranslate) {
            super(sampleModel, dataBuffer, sampleModelTranslate);
        }
    }

    private static class MapIndices<T>
    extends Action<Object> {
        private int[] colorTableArray = null;

        private MapIndices(int[] colorTableArray, int width, int[] output) {
            this.colorTableArray = colorTableArray;
            this.width = width;
            this.output = output;
        }

        @Override
        public void perform(double[] pixel, int row, int column) {
            ((int[])this.output)[row * this.width + column] = this.colorTableArray[Math.min((int)pixel[0], this.colorTableArray.length - 1)];
        }
    }

    private static class ConvertToRGB<T>
    extends Action<T> {
        private ASName csName = null;

        private ConvertToRGB(ColorSpaceCache colorSpace, T output, int width, int height) {
            super(colorSpace, output, width, height);
            this.csName = colorSpace.getUnderlyingColorspace().getName();
        }

        @Override
        public void perform(double[] pixel, int row, int column) {
            if (this.csName == ASName.k_DeviceGray) {
                int gray = GraphicsUtils.rint(pixel[0] * 255.0);
                ((int[])this.output)[row * this.width + column] = 0xFF000000 | gray << 16 | gray << 8 | gray;
            } else {
                double[] transformedPixel = this.colorSpace.toRGB(pixel);
                int red = GraphicsUtils.rint(transformedPixel[0] * 255.0);
                int green = GraphicsUtils.rint(transformedPixel[1] * 255.0);
                int blue = GraphicsUtils.rint(transformedPixel[2] * 255.0);
                ((int[])this.output)[row * this.width + column] = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        }
    }

    private static class ApplyTintTransform<T>
    extends Action<T> {
        private int outputPixelSize;

        private ApplyTintTransform(ColorSpaceCache colorSpace, T output, int width, int height, int outputPixelSize) {
            super(colorSpace, output, width, height);
            this.outputPixelSize = outputPixelSize;
        }

        @Override
        public void perform(double[] pixel, int row, int column) {
            double[] transformedPixel = this.colorSpace.applyTintTransform(pixel);
            for (int k = 0; k < this.outputPixelSize; ++k) {
                ((double[])this.output)[row * this.width * this.outputPixelSize + column * this.outputPixelSize + k] = transformedPixel[k];
            }
        }
    }

    private static abstract class Action<T> {
        protected ColorSpaceCache colorSpace;
        protected T output;
        protected int width;

        protected Action() {
        }

        protected Action(ColorSpaceCache colorSpace, T output, int width, int height) {
            this.colorSpace = colorSpace;
            this.output = output;
            this.width = width;
        }

        abstract void perform(double[] var1, int var2, int var3);
    }

    private class ARGBTilesIterator
    implements Iterator<BufferedImage> {
        private int pixelsProcessed = 0;
        private int totalPixelsToRead = -1;
        private boolean readDataToArray = false;
        private BitInputStream bis = null;
        private int index = 0;
        private int tileHeight = -1;
        private int localMemoryThreshold = -1;
        private int noc = -1;
        private int bytesPerComponent;
        private int bitsPerRow;
        private List<Integer> tilesHeight = new ArrayList<Integer>();
        private int lastIndex = -1;

        private void initializeImageStream() throws IOException {
            if (ARGBImage.this.imageInputStream == null && ARGBImage.this.imageSource != null) {
                ARGBImage.this.imageInputStream = ARGBImage.this.imageSource.getImageInputStream();
                this.bis = this.readDataToArray ? (ARGBImage.this.bpc < 8 ? new BitInputStream(ARGBImage.this.imageInputStream) : null) : new BitInputStream(ARGBImage.this.imageInputStream);
            }
        }

        private ARGBTilesIterator() {
            ARGBImage.this.imageInputStream = null;
            ASName csName = ARGBImage.this.colorSpace.getUnderlyingColorspace().getName();
            if (csName == ASName.k_ICCBased || csName == ASName.k_DeviceCMYK || csName == ASName.k_DeviceRGB || (csName == ASName.k_Separation || csName == ASName.k_DeviceN) && ARGBImage.this.twoStepsForTintTransforms(ARGBImage.this.colorSpace)) {
                this.readDataToArray = true;
            }
            if (this.readDataToArray) {
                this.bytesPerComponent = (int)Math.ceil(1.0 * (double)ARGBImage.this.bpc / 8.0);
                this.noc = ARGBImage.this.colorSpace.getUnderlyingColorspace().getName() == ASName.k_Indexed ? 1 : ARGBImage.this.colorSpace.getNumberOfComponents();
                this.bitsPerRow = ARGBImage.this.width * this.noc * ARGBImage.this.bpc;
                this.tileHeight = Math.min(ARGBImage.this.height, (int)Math.ceil(1.2E7 / Math.ceil(this.bitsPerRow / 8)));
                this.localMemoryThreshold = this.bytesPerComponent * this.tileHeight * ARGBImage.this.width * this.noc;
                this.totalPixelsToRead = ARGBImage.this.width * ARGBImage.this.height;
            } else {
                this.tileHeight = Math.min(ARGBImage.this.height, (int)Math.ceil(1.2E7 / (double)(3 * ARGBImage.this.width)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean ConvertToRGB() {
            try {
                if (this.pixelsProcessed >= this.totalPixelsToRead) return false;
                byte[] currentDataToProcess = null;
                byte[] decodedData = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    double size;
                    double tempHeight;
                    block23: {
                        int bytesPerRowToUse;
                        int bytesPerRowToRead;
                        block22: {
                            block20: {
                                block21: {
                                    if (ARGBImage.this.bpc >= 8) break block20;
                                    if (this.bitsPerRow % 8 == 0) break block21;
                                    bytesPerRowToRead = (int)Math.ceil((this.bitsPerRow + 8 - this.bitsPerRow % 8) / ARGBImage.this.bpc);
                                    bytesPerRowToUse = ARGBImage.this.width * this.noc * this.bytesPerComponent;
                                    currentDataToProcess = new byte[this.tileHeight * bytesPerRowToUse];
                                    break block22;
                                }
                                IO.copy(this.bis, (long)this.localMemoryThreshold, os, ARGBImage.this.bpc);
                                break block23;
                            }
                            IO.copy(ARGBImage.this.imageInputStream, this.localMemoryThreshold, os);
                            break block23;
                        }
                        for (int i = 0; i < this.tileHeight && IO.copy(this.bis, (long)bytesPerRowToRead, os, ARGBImage.this.bpc) != 0L; ++i) {
                            decodedData = os.toByteArray();
                            System.arraycopy(decodedData, 0, currentDataToProcess, i * bytesPerRowToUse, bytesPerRowToUse);
                            os.reset();
                        }
                    }
                    if (currentDataToProcess == null) {
                        currentDataToProcess = decodedData = os.toByteArray();
                    }
                    if ((tempHeight = 1.0 * (size = 1.0 * (double)currentDataToProcess.length / (double)(this.noc * this.bytesPerComponent)) / (double)ARGBImage.this.width) - (double)((int)tempHeight) == 0.0 || !(size < (double)(this.totalPixelsToRead - this.pixelsProcessed))) {
                        if (size > (double)(this.totalPixelsToRead - this.pixelsProcessed)) {
                            size = this.totalPixelsToRead - this.pixelsProcessed;
                        } else if (size == 0.0) {
                            if (os != null) {
                                os.close();
                            }
                            ARGBImage.this.resamplingPending = false;
                            boolean moreBytesToRead = false;
                            return moreBytesToRead;
                        }
                    } else {
                        tempHeight = (int)Math.ceil(tempHeight);
                        int moreBytesToRead = (int)tempHeight * ARGBImage.this.width * this.noc * this.bytesPerComponent - currentDataToProcess.length;
                        currentDataToProcess = new byte[decodedData.length + moreBytesToRead];
                        System.arraycopy(decodedData, 0, currentDataToProcess, 0, decodedData.length);
                        for (int i = 0; i < moreBytesToRead; ++i) {
                            currentDataToProcess[decodedData.length + i] = (byte)(ARGBImage.this.bpc < 8 ? this.bis.read(ARGBImage.this.bpc) : ARGBImage.this.imageInputStream.read());
                        }
                        size = (int)tempHeight * ARGBImage.this.width;
                    }
                    decodedData = null;
                    int[] out = ARGBImage.this.initializeOutputStorage((int)tempHeight, ARGBImage.this.width, this.index);
                    int updatedBpcVal = ARGBImage.this.bpc;
                    if (ARGBImage.this.bpc < 8) {
                        updatedBpcVal = 8;
                    }
                    ARGBImage.this.convertToRGB(ARGBImage.this.colorSpace, null, ARGBImage.this.bpc, updatedBpcVal, currentDataToProcess, ARGBImage.this.width, (int)tempHeight, out);
                    this.pixelsProcessed = (int)((double)this.pixelsProcessed + size);
                    return true;
                }
            }
            catch (IOException e) {
                throw new PDFRuntimeException("Exception occured while decoding image.", e);
            }
        }

        @Override
        public boolean hasNext() {
            Object obj;
            Object e = obj = ARGBImage.this.outputTiles == null || this.index >= ARGBImage.this.outputTiles.size() ? null : (Object)ARGBImage.this.outputTiles.get(this.index);
            if (obj != null) {
                if (obj instanceof SoftReference) {
                    obj = ((SoftReference)obj).get();
                }
                if (obj instanceof BufferedImage) {
                    ARGBImage.this.outputTiles.set(this.index, obj);
                    this.pixelsProcessed += ((BufferedImage)obj).getHeight() * ((BufferedImage)obj).getWidth();
                    return true;
                }
            }
            try {
                this.initializeImageStream();
            }
            catch (IOException e2) {
                throw new PDFRuntimeException("Exception occured while decoding image.", e2);
            }
            if (ARGBImage.this.outputTiles != null && this.index < ARGBImage.this.outputTiles.size()) {
                int totalHeight = 0;
                for (int i = this.lastIndex + 1; i < this.index; ++i) {
                    totalHeight += this.tilesHeight.get(i).intValue();
                }
                int bytesToSkip = totalHeight * (int)Math.ceil(1.0 * (double)this.bitsPerRow / 8.0);
                try {
                    if (this.bis != null) {
                        this.bis.skip(bytesToSkip * 8);
                    } else if (ARGBImage.this.imageInputStream != null) {
                        ARGBImage.this.imageInputStream.skip(bytesToSkip);
                    }
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
                this.lastIndex = this.index;
            }
            if (this.readDataToArray) {
                if (!this.ConvertToRGB()) {
                    return false;
                }
            } else {
                int th = Math.min(this.tileHeight, ARGBImage.this.height - this.index * this.tileHeight);
                if (th <= 0) {
                    return false;
                }
                int[] out = ARGBImage.this.initializeOutputStorage(th, ARGBImage.this.width, this.index);
                ARGBImage.this.convertToRGB(ARGBImage.this.colorSpace, this.bis, ARGBImage.this.bpc, ARGBImage.this.bpc, null, ARGBImage.this.width, th, out);
            }
            if (this.index < this.tilesHeight.size()) {
                this.tilesHeight.set(this.index, ((BufferedImage)ARGBImage.this.outputTiles.get(this.index)).getHeight());
            } else {
                this.tilesHeight.add(((BufferedImage)ARGBImage.this.outputTiles.get(this.index)).getHeight());
            }
            if (ARGBImage.this.resamplingPending && ARGBImage.this.downScalingMethod != null) {
                ARGBImage.this.resample(ARGBImage.this.scaledHeight, ARGBImage.this.scaledWidth, ARGBImage.this.downScalingMethod, this.index);
            }
            return true;
        }

        @Override
        public BufferedImage next() {
            BufferedImage bufImage = (BufferedImage)ARGBImage.this.outputTiles.get(this.index);
            ARGBImage.this.outputTiles.set(this.index, new SoftReference<BufferedImage>(bufImage));
            ++this.index;
            return bufImage;
        }

        @Override
        public void remove() {
            if (ARGBImage.this.outputTiles != null && this.index <= ARGBImage.this.outputTiles.size()) {
                ARGBImage.this.outputTiles.remove(this.index - 1);
            }
        }
    }
}

