/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM.utils;

import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.GlyphOutlineGenerator;
import java.awt.geom.GeneralPath;

public class GlyphAbsoluteOutlineGenerator
extends GlyphOutlineGenerator {
    public GlyphAbsoluteOutlineGenerator(ASMatrix textMatrix) {
        super(textMatrix);
        this.absolutePath = new GeneralPath();
    }

    private double[] getAbsoluteCoordinates(double x, double y) {
        x = this.matrix.applyToXYGetX(x, y);
        y = this.matrix.applyToXYGetY(x, y);
        if (this.textMatrix == null) {
            return new double[]{x, y};
        }
        ASCoordinate coord = new ASCoordinate(x, y);
        ASCoordinate trans = coord.transform(this.textMatrix);
        return new double[]{trans.x(), trans.y()};
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3) {
        double[] p1 = this.getAbsoluteCoordinates(x2, y2);
        double[] p2 = this.getAbsoluteCoordinates(x3, y3);
        this.absolutePath.quadTo((float)p1[0], (float)p1[1], (float)p2[0], (float)p2[1]);
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        double[] p1 = this.getAbsoluteCoordinates(x2, y2);
        double[] p2 = this.getAbsoluteCoordinates(x3, y3);
        double[] p3 = this.getAbsoluteCoordinates(x4, y4);
        this.absolutePath.curveTo((float)p1[0], (float)p1[1], (float)p2[0], (float)p2[1], (float)p3[0], (float)p3[1]);
    }

    @Override
    public void lineto(double x, double y) {
        double[] p1 = this.getAbsoluteCoordinates(x, y);
        this.absolutePath.lineTo((float)p1[0], (float)p1[1]);
    }

    @Override
    public void moveto(double x, double y) {
        double[] p1 = this.getAbsoluteCoordinates(x, y);
        this.absolutePath.moveTo((float)p1[0], (float)p1[1]);
    }
}

