/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;

class CosObjectRef
extends CosObject {
    CosObjectRef(CosDocument doc, CosObjectInfo info) {
        super(doc, null);
        this.setInfo(info);
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosObjectInfo info = this.getInfo();
        int objNum = info.getObjNum();
        outStream.write(StringOps.toByteArray(Integer.toString(objNum)));
        outStream.write(32);
        int objGen = info.getObjGen();
        if (objGen != 0 && this.getDocument().willBeCompressed(objNum)) {
            objGen = 0;
        }
        outStream.write(StringOps.toByteArray(Integer.toString(objGen)));
        outStream.write(StringOps.toByteArray(" R"));
    }

    @Override
    public Object getValue() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj;
        try {
            obj = this.getDocument().resolveReference(this);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return obj.getValue();
    }

    public int getValueType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj;
        try {
            obj = this.getDocument().resolveReference(this);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return obj.getType();
    }

    @Override
    public boolean equals(CosObject value) {
        return value == this;
    }
}

