/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosLinearization;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosUnexpectedTypeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;

public abstract class CosObject {
    private CosDocument mDoc;
    private CosObjectInfo mInfo;
    public static final int t_Null = 0;
    public static final int t_Numeric = 1;
    public static final int t_Boolean = 2;
    public static final int t_Name = 3;
    public static final int t_String = 4;
    public static final int t_Array = 5;
    public static final int t_Dictionary = 6;
    public static final int t_Stream = 7;
    public static final int t_ObjectRef = 8;
    public static final int t_KeyAbsent = 9;
    public static final int DIRECT = 0;
    public static final int INDIRECT = 1;
    protected boolean repaired = false;

    CosObject(CosDocument doc, CosObjectInfo info) {
        this.mDoc = doc;
        if (info != null && info.getObjNum() != 0) {
            this.mInfo = info;
            this.mInfo.setObject(this);
        }
    }

    abstract void writeOut(OutputByteStream var1, boolean var2, boolean var3) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException;

    void writeOut(OutputByteStream outStream) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.writeOut(outStream, false, false);
    }

    void close() throws IOException {
        this.mDoc = null;
        this.mInfo = null;
    }

    void release() throws IOException {
        this.markNotDirty();
    }

    public abstract int getType();

    public abstract Object getValue() throws PDFCosParseException, PDFIOException, PDFSecurityException;

    public boolean isIndirect() {
        return this.mInfo != null;
    }

    public int getObjNum() {
        if (this.mInfo != null) {
            return this.mInfo.getObjNum();
        }
        return 0;
    }

    public int getObjGen() {
        if (this.mInfo != null) {
            return this.mInfo.getObjGen();
        }
        return -1;
    }

    public long getObjEOF() {
        if (this.mInfo == null) {
            CosContainer parentObj = null;
            if (this instanceof CosContainer) {
                parentObj = ((CosContainer)this).getParentObj();
            }
            if (this instanceof CosString) {
                parentObj = ((CosString)this).getParentObj();
            }
            if (parentObj == null) {
                return 0L;
            }
            return this.mDoc.getObjEOF(parentObj);
        }
        return this.mDoc.getObjEOF(this);
    }

    public int getObjRevision() {
        if (this.mInfo == null) {
            CosContainer parentObj = null;
            if (this instanceof CosContainer) {
                parentObj = ((CosContainer)this).getParentObj();
            }
            if (this instanceof CosString) {
                parentObj = ((CosString)this).getParentObj();
            }
            if (parentObj == null) {
                return -1;
            }
            return this.mDoc.getObjRevision(parentObj);
        }
        return this.mDoc.getObjRevision(this);
    }

    public long getObjPos() {
        if (this.mInfo == null) {
            CosContainer parentObj = null;
            if (this instanceof CosContainer) {
                parentObj = ((CosContainer)this).getParentObj();
            }
            if (this instanceof CosString) {
                parentObj = ((CosString)this).getParentObj();
            }
            if (parentObj == null) {
                return 0L;
            }
            return this.mDoc.getObjPos(parentObj);
        }
        return this.mDoc.getObjPos(this);
    }

    public boolean isCompressed() {
        if (this.mInfo == null) {
            return false;
        }
        return this.mInfo.isCompressed();
    }

    boolean flushCachedObject() {
        if (this.mInfo == null) {
            return false;
        }
        if (!this.mInfo.flushCachedObject()) {
            return false;
        }
        this.mInfo = null;
        return true;
    }

    boolean markNotDirty() {
        if (this.mInfo == null) {
            return false;
        }
        return this.mInfo.markNotDirty();
    }

    public int intValue() {
        throw new PDFCosUnexpectedTypeException("expected CosNumeric");
    }

    public long longValue() {
        throw new PDFCosUnexpectedTypeException("expected CosNumeric");
    }

    public double doubleValue() {
        throw new PDFCosUnexpectedTypeException("expected CosNumeric");
    }

    public Number numberValue() {
        throw new PDFCosUnexpectedTypeException("expected CosNumeric");
    }

    public boolean booleanValue() {
        throw new PDFCosUnexpectedTypeException("expected CosBoolean");
    }

    public ASName nameValue() {
        throw new PDFCosUnexpectedTypeException("expected CosName");
    }

    public ASString stringValue() throws PDFSecurityException {
        throw new PDFCosUnexpectedTypeException("expected CosString");
    }

    public ASHexString hexStringValue() throws PDFSecurityException {
        throw new PDFCosUnexpectedTypeException("expected CosString");
    }

    public String textValue() throws PDFSecurityException {
        throw new PDFCosUnexpectedTypeException("expected CosString or CosName");
    }

    byte[] getObjectEncryptionKey(boolean write) {
        CosLinearization cosLin;
        byte[] key = new byte[5];
        int objNum = this.getInfo().getObjNum();
        int gen = this.getInfo().getObjGen();
        if (!write && (cosLin = this.getDocument().getLinearization()) != null && !(this instanceof CosObjectStream)) {
            objNum = cosLin.mapNewToOldObjNum(objNum);
            gen = cosLin.mapNewToOldObjGen(objNum);
        }
        System.arraycopy(ByteOps.splitInt2Bytes(objNum, 3), 0, key, 0, 3);
        System.arraycopy(ByteOps.splitInt2Bytes(gen, 2), 0, key, 3, 2);
        return key;
    }

    public CosDocument getDocument() {
        return this.mDoc;
    }

    public StreamManager getStreamManager() {
        return this.getDocument().getStreamManager();
    }

    CosObjectInfo getInfo() {
        return this.mInfo;
    }

    void setInfo(CosObjectInfo info) {
        this.mInfo = info;
    }

    public boolean isDirty() {
        if (this.mInfo != null) {
            return this.mInfo.isDirty();
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toString(boolean inDebug) {
        InputByteStream stream = null;
        try {
            OutputByteStream outStream = this.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 10000L);
            this.writeOut(outStream, true, inDebug);
            stream = outStream.closeAndConvert();
            StringBuilder string = new StringBuilder((int)stream.length());
            while (stream.bytesAvailable() > 0L) {
                string.append((char)stream.read());
            }
            String string2 = string.toString();
            return string2;
        }
        catch (PDFException e) {
            String string = e.toString();
            return string;
        }
        catch (IOException e) {
            String string = e.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return e.toString();
                }
            }
        }
    }

    public abstract boolean equals(CosObject var1);

    public boolean equals(Object value) {
        if (!(value instanceof CosObject)) {
            return false;
        }
        return this.equals((CosObject)value);
    }

    void setRepaired(boolean repaired) {
        this.repaired = repaired;
        this.mDoc.setDocumentCosLevelRepaired();
    }

    boolean isRepaired() {
        return this.repaired;
    }
}

