/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputByteStreamImpl;
import com.adobe.internal.io.stream.StreamManager;
import java.io.IOException;

final class ByteReaderInputByteStream
extends InputByteStreamImpl {
    private StreamManager streamManager;
    private boolean isSlice = false;
    public ByteReader byteReader = null;
    private long position;
    private long start;
    private long length;
    public boolean lengthInitialized;
    private boolean registered = false;

    ByteReaderInputByteStream(StreamManager streamManager, ByteReader byteReader, boolean register) throws IOException {
        this(streamManager, byteReader, 0L, -1L, register);
    }

    ByteReaderInputByteStream(StreamManager streamManager, ByteReader byteReader, long startOffset, long length, boolean register) throws IOException {
        if (byteReader == null) {
            throw new IOException("Null ByteReader parameter.");
        }
        this.streamManager = streamManager;
        this.byteReader = byteReader;
        this.start = startOffset;
        this.length = length;
        this.lengthInitialized = false;
        this.registered = register;
        if (this.registered) {
            this.streamManager.registerInputByteStream(this, this.byteReader, this.isSlice);
        }
    }

    ByteReaderInputByteStream(ByteReaderInputByteStream original, long startOffset, long length) throws IOException {
        if (startOffset < 0L || length < 0L || startOffset + length > original.length()) {
            throw new IOException("Invalid slice of Bytestream");
        }
        this.streamManager = original.streamManager;
        this.byteReader = original.byteReader;
        this.start = original.start + startOffset;
        this.length = length;
        this.position = this.start;
        this.lengthInitialized = original.lengthInitialized;
        this.isSlice = true;
        this.registered = original.registered;
        if (this.registered) {
            this.streamManager.registerInputByteStream(this, this.byteReader, this.isSlice);
        }
    }

    public InputByteStream slice(long begin, long length) throws IOException {
        return new ByteReaderInputByteStream(this, begin, length);
    }

    public void close() throws IOException {
        if (this.registered) {
            this.streamManager.deregisterInputByteStream(this, this.byteReader, this.isSlice);
        } else if (!this.isSlice) {
            this.byteReader.close();
        }
        this.byteReader = null;
    }

    public InputByteStream seek(long position) throws IOException {
        if (position < 0L) {
            position = 0L;
        }
        if (position > this.length()) {
            position = this.length();
        }
        this.position = position + this.start;
        return this;
    }

    public long getPosition() throws IOException {
        return this.position - this.start;
    }

    public long length() throws IOException {
        if (!this.lengthInitialized) {
            this.length = this.length == -1L ? this.byteReader.length() : Math.min(this.byteReader.length() - this.start, this.length);
            this.lengthInitialized = true;
        }
        return this.length;
    }

    public int read() throws IOException {
        int b = -1;
        if (this.position - this.start < this.length || !this.lengthInitialized && this.getPosition() < this.length()) {
            b = this.byteReader.read(this.position);
            ++this.position;
        }
        return b;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if ((length = (int)Math.min((long)length, this.length() - this.getPosition())) == 0) {
            return -1;
        }
        int bytesRead = this.byteReader.read(this.position, b, offset, length);
        this.seek(this.getPosition() + (long)bytesRead);
        return bytesRead;
    }
}

