/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.afml;

import com.adobe.internal.afml.AFMLAnomalies;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;

public class AFMLSpaceRange {
    public static final double const_AUTO = Double.POSITIVE_INFINITY;
    public static final double const_UNSET = Double.NEGATIVE_INFINITY;
    public static final int PRECEDENCE_FORCE = Integer.MAX_VALUE;
    public static final boolean CONDITIONALITY_RETAIN = true;
    public static final boolean CONDITIONALITY_DISCARD = false;
    private double pvt_Optimum;
    private double pvt_Minimum;
    private double pvt_Maximum;
    private int pvt_Precedence;
    private boolean pvt_Conditionality;

    public AFMLSpaceRange(double in_Minimum, double in_Optimum, double in_Maximum, int in_Precedence, boolean in_Conditionality) throws AFMLExceptionInvalidParameter {
        this.pvt_Optimum = in_Optimum;
        this.pvt_Minimum = in_Minimum;
        this.pvt_Maximum = in_Maximum;
        this.pvt_Precedence = in_Precedence;
        this.pvt_Conditionality = in_Conditionality;
        if (this.pvt_Minimum == Double.NEGATIVE_INFINITY || this.pvt_Optimum == Double.NEGATIVE_INFINITY || this.pvt_Minimum != Double.POSITIVE_INFINITY && this.pvt_Optimum != Double.POSITIVE_INFINITY && this.pvt_Minimum > this.pvt_Optimum) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
        if (this.pvt_Optimum == Double.NEGATIVE_INFINITY || this.pvt_Maximum == Double.NEGATIVE_INFINITY || this.pvt_Optimum != Double.POSITIVE_INFINITY && this.pvt_Maximum != Double.POSITIVE_INFINITY && this.pvt_Optimum > this.pvt_Maximum) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
    }

    public AFMLSpaceRange(double in_Optimum, int in_Precedence, boolean in_Conditionality) throws AFMLExceptionInvalidParameter {
        this.pvt_Optimum = in_Optimum;
        this.pvt_Minimum = in_Optimum;
        this.pvt_Maximum = in_Optimum;
        this.pvt_Precedence = in_Precedence;
        this.pvt_Conditionality = in_Conditionality;
        if (this.pvt_Minimum == Double.NEGATIVE_INFINITY || this.pvt_Optimum == Double.NEGATIVE_INFINITY || this.pvt_Minimum != Double.POSITIVE_INFINITY && this.pvt_Optimum != Double.POSITIVE_INFINITY && this.pvt_Minimum > this.pvt_Optimum) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
        if (this.pvt_Optimum == Double.NEGATIVE_INFINITY || this.pvt_Maximum == Double.NEGATIVE_INFINITY || this.pvt_Optimum != Double.POSITIVE_INFINITY && this.pvt_Maximum != Double.POSITIVE_INFINITY && this.pvt_Optimum > this.pvt_Maximum) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
    }

    public AFMLSpaceRange resolveSpaces(AFMLSpaceRange in_AdjacentSpace) throws AFMLExceptionInvalidParameter {
        AFMLSpaceRange var_New = new AFMLSpaceRange(in_AdjacentSpace.getOptimum(), in_AdjacentSpace.getMinimum(), in_AdjacentSpace.getMaximum(), in_AdjacentSpace.getPrecedence(), true);
        if (in_AdjacentSpace.getPrecedence() == Integer.MAX_VALUE) {
            if (this.getPrecedence() == Integer.MAX_VALUE) {
                var_New.setOptimum(this.getOptimum() + in_AdjacentSpace.getOptimum());
                var_New.setMinimum(this.getMinimum() + in_AdjacentSpace.getOptimum());
                var_New.setMaximum(this.getMaximum() + in_AdjacentSpace.getOptimum());
                var_New.setPrecedence(Integer.MAX_VALUE);
            } else {
                var_New.setPrecedence(Integer.MAX_VALUE);
            }
        } else if (this.getPrecedence() == Integer.MAX_VALUE) {
            var_New.setOptimum(this.getOptimum());
            var_New.setMinimum(this.getMinimum());
            var_New.setMaximum(this.getMaximum());
            var_New.setPrecedence(Integer.MAX_VALUE);
        } else if (in_AdjacentSpace.getPrecedence() <= this.getPrecedence()) {
            if (in_AdjacentSpace.getPrecedence() < this.getPrecedence()) {
                var_New.setOptimum(this.getOptimum());
                var_New.setMinimum(this.getMinimum());
                var_New.setMaximum(this.getMaximum());
                var_New.setPrecedence(this.getPrecedence());
            } else if (!(in_AdjacentSpace.getOptimum() > this.getOptimum())) {
                if (in_AdjacentSpace.getOptimum() < this.getOptimum()) {
                    var_New.setOptimum(this.getOptimum());
                    var_New.setMinimum(this.getMinimum());
                    var_New.setMaximum(this.getMaximum());
                } else {
                    if (in_AdjacentSpace.getMinimum() < this.getMinimum()) {
                        var_New.setMinimum(this.getMinimum());
                    }
                    if (in_AdjacentSpace.getMaximum() > this.getMaximum()) {
                        var_New.setMaximum(this.getMaximum());
                    }
                }
            }
        }
        if (var_New.getMinimum() == Double.NEGATIVE_INFINITY || var_New.getOptimum() == Double.NEGATIVE_INFINITY || var_New.getMinimum() != Double.POSITIVE_INFINITY && var_New.getOptimum() != Double.POSITIVE_INFINITY && var_New.getMinimum() > var_New.getOptimum()) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
        if (var_New.getOptimum() == Double.NEGATIVE_INFINITY || var_New.getMaximum() == Double.NEGATIVE_INFINITY || var_New.getOptimum() != Double.POSITIVE_INFINITY && var_New.getMaximum() != Double.POSITIVE_INFINITY && var_New.getOptimum() > var_New.getMaximum()) {
            AFMLAnomalies.AFMLInvalidParameterStop("AFMLSpaceRange: Must preserve: space.minimum < space.optimum < space.maximum");
        }
        return var_New;
    }

    public void setToZero() {
        this.setOptimum(0.0);
        this.setMinimum(0.0);
        this.setMaximum(0.0);
        this.setPrecedence(0);
        this.setConditionality(true);
    }

    public boolean getConditionality() {
        return this.pvt_Conditionality;
    }

    public double getMaximum() {
        return this.pvt_Maximum;
    }

    public double getMinimum() {
        return this.pvt_Minimum;
    }

    public double getOptimum() {
        return this.pvt_Optimum;
    }

    public int getPrecedence() {
        return this.pvt_Precedence;
    }

    protected void setConditionality(boolean b) {
        this.pvt_Conditionality = b;
    }

    protected void setMaximum(double d) {
        this.pvt_Maximum = d;
    }

    protected void setMinimum(double d) {
        this.pvt_Minimum = d;
    }

    protected void setOptimum(double d) {
        this.pvt_Optimum = d;
    }

    protected void setPrecedence(int i) {
        this.pvt_Precedence = i;
    }
}

