/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.SparseArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GlyphNames {
    static Object mutex = new Object();
    static final Map aglNameList;
    static final Map aglNameListMulti;
    static final Map dingbatNameList;
    static final SparseArray charTable;
    static final SparseArray dingbatCharTable;

    public static String resolveUSVWithAGNCNameTable(int usv) {
        List glyphNameList = (List)charTable.get(usv);
        if (glyphNameList == null) {
            return null;
        }
        GlyphNameEntry entry = (GlyphNameEntry)glyphNameList.get(0);
        return entry.getName();
    }

    public static String resolveUSVToAGNCName(int usv) {
        String name = GlyphNames.resolveUSVWithAGNCNameTable(usv);
        if (name == null) {
            name = GlyphNames.generateUPlusName(usv);
        }
        return name;
    }

    public static String generateUPlusName(int usv) {
        if (usv >= 0 && usv <= 0x10FFFF) {
            String number = Integer.toHexString(usv).toUpperCase();
            switch (number.length()) {
                case 1: {
                    return "u000" + number;
                }
                case 2: {
                    return "u00" + number;
                }
                case 3: {
                    return "u0" + number;
                }
            }
            return "u" + number;
        }
        return null;
    }

    public static List resolveAGNCName(String name, boolean isDingbats) {
        ArrayList usvs = new ArrayList();
        int firstPeriod = name.indexOf(46);
        if (firstPeriod != -1) {
            name = name.substring(0, firstPeriod);
        }
        String[] components = name.split("_");
        for (int i = 0; i < components.length; ++i) {
            if ((!isDingbats ? GlyphNames.resolveGlyphList(components[i], usvs) : GlyphNames.resolveDingbatsList(components[i], usvs)) || GlyphNames.resolveUniName(components[i], usvs)) continue;
            GlyphNames.resolveUPlusName(components[i], usvs);
        }
        return usvs;
    }

    public static int[] resolveAGNCNameIntoArray(String name, boolean isDingbats) {
        List usvs = GlyphNames.resolveAGNCName(name, isDingbats);
        int[] array = new int[usvs.size()];
        for (int i = 0; i < usvs.size(); ++i) {
            array[i] = (Integer)usvs.get(i);
        }
        return array;
    }

    public static String getAGNCNameSuffix(String name) {
        int firstPeriod = name.indexOf(46);
        if (firstPeriod == -1 || firstPeriod == name.length() - 1) {
            return null;
        }
        return name.substring(firstPeriod + 1, name.length());
    }

    private static boolean resolveUPlusName(String component, List usvs) {
        if (component.matches("^u(([\\dA-F]{4})|([1-9A-F][\\dA-F]{4})|(1[\\dA-F]{5}))")) {
            usvs.add(new Integer(Integer.parseInt(component.substring(1), 16)));
            return true;
        }
        return false;
    }

    private static boolean resolveUniName(String component, List usvs) {
        int added = 0;
        if (component.matches("^uni([\\dA-F]{4})+")) {
            for (int start = 3; start < component.length(); start += 4) {
                int value = Integer.parseInt(component.substring(start, start + 4), 16);
                if (value >= 0 && value <= 55295 || value >= 57344 && value <= 65535) {
                    usvs.add(new Integer(value));
                    ++added;
                    continue;
                }
                for (int i = 0; i < added; ++i) {
                    usvs.remove(usvs.size() - 1);
                }
                break;
            }
        }
        return added != 0;
    }

    private static boolean resolveGlyphList(String component, List usvs) {
        GlyphNameEntry entry = (GlyphNameEntry)aglNameList.get(component);
        if (entry == null) {
            return false;
        }
        usvs.add(entry.getUSV());
        return true;
    }

    private static boolean resolveDingbatsList(String component, List usvs) {
        GlyphNameEntry entry = (GlyphNameEntry)dingbatNameList.get(component);
        if (entry == null) {
            return false;
        }
        usvs.add(entry.getUSV());
        return true;
    }

    public static Map getAdobeGlyphNameList() {
        HashMap retVal = new HashMap();
        for (Object key : aglNameList.keySet()) {
            GlyphNameEntry entry = (GlyphNameEntry)aglNameList.get(key);
            retVal.put(key, entry.getUSV());
        }
        return retVal;
    }

    public static Map getAdobeGlyphNameListMulti() {
        HashMap retVal = new HashMap();
        for (Object key : aglNameListMulti.keySet()) {
            GlyphNameMultiEntry entry = (GlyphNameMultiEntry)aglNameListMulti.get(key);
            retVal.put(key, entry.getUSVS());
        }
        return retVal;
    }

    public static Map getDingbatNameList() {
        HashMap retVal = new HashMap();
        for (Object key : dingbatNameList.keySet()) {
            GlyphNameEntry entry = (GlyphNameEntry)dingbatNameList.get(key);
            retVal.put(key, entry.getUSV());
        }
        return retVal;
    }

    static {
        try {
            ObjectInputStream is = new ObjectInputStream(GlyphNames.class.getResourceAsStream("agnc"));
            aglNameList = (Map)is.readObject();
            aglNameListMulti = (Map)is.readObject();
            charTable = (SparseArray)is.readObject();
            dingbatNameList = (Map)is.readObject();
            dingbatCharTable = (SparseArray)is.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot load AFE AGNC resources", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load AFE AGNC resources", e);
        }
    }

    protected static class GlyphNameMultiEntry
    implements Serializable {
        static final long serialVersionUID = 1L;
        protected List usvs;
        protected String name;

        protected GlyphNameMultiEntry(List usvs, String name) {
            this.usvs = new ArrayList(usvs);
            this.name = name;
        }

        protected List getUSVS() {
            return this.usvs;
        }

        protected String getName() {
            return this.name;
        }

        public String toString() {
            return "[ " + this.usvs + ", " + this.name + " ]";
        }
    }

    protected static class GlyphNameEntry
    implements Serializable {
        static final long serialVersionUID = 1L;
        protected Integer usv;
        protected String name;

        protected GlyphNameEntry(Integer usv, String name) {
            this.usv = usv;
            this.name = name;
        }

        protected GlyphNameEntry(int usv, String name) {
            this.usv = new Integer(usv);
            this.name = name;
        }

        protected Integer getUSV() {
            return this.usv;
        }

        protected String getName() {
            return this.name;
        }

        public String toString() {
            return "[ " + this.usv + ", " + this.name + " ]";
        }
    }
}

