/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.search.AggregateType;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Grouping
implements ISelfValidate {
    private static final Log LOG = LogFactory.getLog(Grouping.class);
    private SortDirection sortDirection = SortDirection.Ascending;
    private PropertyDefinitionBase groupOn;
    private PropertyDefinitionBase aggregateOn;
    private AggregateType aggregateType = AggregateType.Minimum;

    private void internalValidate() throws Exception {
        EwsUtilities.validateParam(this.groupOn, "GroupOn");
        EwsUtilities.validateParam(this.aggregateOn, "AggregateOn");
    }

    public Grouping() {
    }

    public Grouping(PropertyDefinitionBase groupOn, SortDirection sortDirection, PropertyDefinitionBase aggregateOn, AggregateType aggregateType) throws Exception {
        this();
        EwsUtilities.validateParam(groupOn, "groupOn");
        EwsUtilities.validateParam(aggregateOn, "aggregateOn");
        this.groupOn = groupOn;
        this.sortDirection = sortDirection;
        this.aggregateOn = aggregateOn;
        this.aggregateType = aggregateType;
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Messages, "GroupBy");
        writer.writeAttributeValue("Order", (Object)this.sortDirection);
        this.groupOn.writeToXml(writer);
        writer.writeStartElement(XmlNamespace.Types, "AggregateOn");
        writer.writeAttributeValue("Aggregate", (Object)this.aggregateType);
        this.aggregateOn.writeToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public PropertyDefinitionBase getGroupOn() {
        return this.groupOn;
    }

    public void setGroupOn(PropertyDefinitionBase groupOn) {
        this.groupOn = groupOn;
    }

    public PropertyDefinitionBase getAggregateOn() {
        return this.aggregateOn;
    }

    public void setAggregateOn(PropertyDefinitionBase aggregateOn) {
        this.aggregateOn = aggregateOn;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    public void validate() {
        try {
            this.internalValidate();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }
}

