/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.availability;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.availability.SuggestionQuality;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.availability.TimeSuggestion;

public final class Suggestion
extends ComplexProperty {
    private Date date;
    private SuggestionQuality quality;
    private Collection<TimeSuggestion> timeSuggestions = new ArrayList<TimeSuggestion>();

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("Date")) {
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.date = sdfin.parse(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("DayQuality")) {
            this.quality = reader.readElementValue(SuggestionQuality.class);
            return true;
        }
        if (reader.getLocalName().equals("SuggestionArray")) {
            if (!reader.isEmptyElement()) {
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Types, "Suggestion")) continue;
                    TimeSuggestion timeSuggestion = new TimeSuggestion();
                    timeSuggestion.loadFromXml(reader, reader.getLocalName());
                    this.timeSuggestions.add(timeSuggestion);
                } while (!reader.isEndElement(XmlNamespace.Types, "SuggestionArray"));
            }
            return true;
        }
        return false;
    }

    public Date getDate() {
        return this.date;
    }

    public SuggestionQuality getQuality() {
        return this.quality;
    }

    public Collection<TimeSuggestion> getTimeSuggestions() {
        return this.timeSuggestions;
    }
}

