/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public abstract class NotificationEvent {
    private EventType eventType;
    private Date timestamp;
    private FolderId parentFolderId;
    private FolderId oldParentFolderId;

    protected NotificationEvent(EventType eventType, Date timestamp) {
        this.eventType = eventType;
        this.timestamp = timestamp;
    }

    protected void internalLoadFromXml(EwsServiceXmlReader reader) throws Exception {
    }

    protected void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        this.internalLoadFromXml(reader);
        reader.readEndElementIfNecessary(XmlNamespace.Types, xmlElementName);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    protected void setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public FolderId getOldParentFolderId() {
        return this.oldParentFolderId;
    }

    protected void setOldParentFolderId(FolderId oldParentFolderId) {
        this.oldParentFolderId = oldParentFolderId;
    }
}

